<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cCustomsArticle Struct
 * @subpackage Structs
 */
class CCustomsArticle extends AbstractStructBase
{
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $quantity;
    /**
     * The description
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $description;
    /**
     * The country_origin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country_origin;
    /**
     * The tariff
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $tariff;
    /**
     * The weight_net
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $weight_net;
    /**
     * The weight_gross
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $weight_gross;
    /**
     * The price
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $price;
    /**
     * Constructor method for cCustomsArticle
     * @uses CCustomsArticle::setQuantity()
     * @uses CCustomsArticle::setDescription()
     * @uses CCustomsArticle::setCountry_origin()
     * @uses CCustomsArticle::setTariff()
     * @uses CCustomsArticle::setWeight_net()
     * @uses CCustomsArticle::setWeight_gross()
     * @uses CCustomsArticle::setPrice()
     * @param int $quantity
     * @param string $description
     * @param string $country_origin
     * @param string $tariff
     * @param float $weight_net
     * @param float $weight_gross
     * @param float $price
     */
    public function __construct($quantity = null, $description = null, $country_origin = null, $tariff = null, $weight_net = null, $weight_gross = null, $price = null)
    {
        $this
            ->setQuantity($quantity)
            ->setDescription($description)
            ->setCountry_origin($country_origin)
            ->setTariff($tariff)
            ->setWeight_net($weight_net)
            ->setWeight_gross($weight_gross)
            ->setPrice($price);
    }
    /**
     * Get quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \GLS\CCustomsArticle
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get description value
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \GLS\CCustomsArticle
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get country_origin value
     * @return string
     */
    public function getCountry_origin()
    {
        return $this->country_origin;
    }
    /**
     * Set country_origin value
     * @param string $country_origin
     * @return \GLS\CCustomsArticle
     */
    public function setCountry_origin($country_origin = null)
    {
        // validation for constraint: string
        if (!is_null($country_origin) && !is_string($country_origin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country_origin, true), gettype($country_origin)), __LINE__);
        }
        $this->country_origin = $country_origin;
        return $this;
    }
    /**
     * Get tariff value
     * @return string
     */
    public function getTariff()
    {
        return $this->tariff;
    }
    /**
     * Set tariff value
     * @param string $tariff
     * @return \GLS\CCustomsArticle
     */
    public function setTariff($tariff = null)
    {
        // validation for constraint: string
        if (!is_null($tariff) && !is_string($tariff)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tariff, true), gettype($tariff)), __LINE__);
        }
        $this->tariff = $tariff;
        return $this;
    }
    /**
     * Get weight_net value
     * @return float
     */
    public function getWeight_net()
    {
        return $this->weight_net;
    }
    /**
     * Set weight_net value
     * @param float $weight_net
     * @return \GLS\CCustomsArticle
     */
    public function setWeight_net($weight_net = null)
    {
        // validation for constraint: float
        if (!is_null($weight_net) && !(is_float($weight_net) || is_numeric($weight_net))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight_net, true), gettype($weight_net)), __LINE__);
        }
        $this->weight_net = $weight_net;
        return $this;
    }
    /**
     * Get weight_gross value
     * @return float
     */
    public function getWeight_gross()
    {
        return $this->weight_gross;
    }
    /**
     * Set weight_gross value
     * @param float $weight_gross
     * @return \GLS\CCustomsArticle
     */
    public function setWeight_gross($weight_gross = null)
    {
        // validation for constraint: float
        if (!is_null($weight_gross) && !(is_float($weight_gross) || is_numeric($weight_gross))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($weight_gross, true), gettype($weight_gross)), __LINE__);
        }
        $this->weight_gross = $weight_gross;
        return $this;
    }
    /**
     * Get price value
     * @return float
     */
    public function getPrice()
    {
        return $this->price;
    }
    /**
     * Set price value
     * @param float $price
     * @return \GLS\CCustomsArticle
     */
    public function setPrice($price = null)
    {
        // validation for constraint: float
        if (!is_null($price) && !(is_float($price) || is_numeric($price))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($price, true), gettype($price)), __LINE__);
        }
        $this->price = $price;
        return $this;
    }
}
