<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cBulkCustomsClearanceLineItem Struct
 * @subpackage Structs
 */
class CBulkCustomsClearanceLineItem extends AbstractStructBase
{
    /**
     * The quantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLS\CQuantityExt
     */
    public $quantity;
    /**
     * The commodityCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $commodityCode;
    /**
     * The goodsDescription
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $goodsDescription;
    /**
     * The countryOfOrigin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $countryOfOrigin;
    /**
     * The valueInInvoiceCurrency
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $valueInInvoiceCurrency;
    /**
     * The grossWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLS\CWeightExt
     */
    public $grossWeight;
    /**
     * The netWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLS\CWeightExt
     */
    public $netWeight;
    /**
     * The preferentialTrade
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLS\CBulkCustomsClearanceLineItemPreferentialTrade
     */
    public $preferentialTrade;
    /**
     * The statisticalValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLS\CAmountOfMoney
     */
    public $statisticalValue;
    /**
     * The statisticalQuantity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $statisticalQuantity;
    /**
     * The nationalCustomsFields
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLS\CBulkCustomsClearanceLineItemNationalCustomsFields
     */
    public $nationalCustomsFields;
    /**
     * Constructor method for cBulkCustomsClearanceLineItem
     * @uses CBulkCustomsClearanceLineItem::setQuantity()
     * @uses CBulkCustomsClearanceLineItem::setCommodityCode()
     * @uses CBulkCustomsClearanceLineItem::setGoodsDescription()
     * @uses CBulkCustomsClearanceLineItem::setCountryOfOrigin()
     * @uses CBulkCustomsClearanceLineItem::setValueInInvoiceCurrency()
     * @uses CBulkCustomsClearanceLineItem::setGrossWeight()
     * @uses CBulkCustomsClearanceLineItem::setNetWeight()
     * @uses CBulkCustomsClearanceLineItem::setPreferentialTrade()
     * @uses CBulkCustomsClearanceLineItem::setStatisticalValue()
     * @uses CBulkCustomsClearanceLineItem::setStatisticalQuantity()
     * @uses CBulkCustomsClearanceLineItem::setNationalCustomsFields()
     * @param \GLS\CQuantityExt $quantity
     * @param string $commodityCode
     * @param string $goodsDescription
     * @param string $countryOfOrigin
     * @param float $valueInInvoiceCurrency
     * @param \GLS\CWeightExt $grossWeight
     * @param \GLS\CWeightExt $netWeight
     * @param \GLS\CBulkCustomsClearanceLineItemPreferentialTrade $preferentialTrade
     * @param \GLS\CAmountOfMoney $statisticalValue
     * @param float $statisticalQuantity
     * @param \GLS\CBulkCustomsClearanceLineItemNationalCustomsFields $nationalCustomsFields
     */
    public function __construct(\GLS\CQuantityExt $quantity = null, $commodityCode = null, $goodsDescription = null, $countryOfOrigin = null, $valueInInvoiceCurrency = null, \GLS\CWeightExt $grossWeight = null, \GLS\CWeightExt $netWeight = null, \GLS\CBulkCustomsClearanceLineItemPreferentialTrade $preferentialTrade = null, \GLS\CAmountOfMoney $statisticalValue = null, $statisticalQuantity = null, \GLS\CBulkCustomsClearanceLineItemNationalCustomsFields $nationalCustomsFields = null)
    {
        $this
            ->setQuantity($quantity)
            ->setCommodityCode($commodityCode)
            ->setGoodsDescription($goodsDescription)
            ->setCountryOfOrigin($countryOfOrigin)
            ->setValueInInvoiceCurrency($valueInInvoiceCurrency)
            ->setGrossWeight($grossWeight)
            ->setNetWeight($netWeight)
            ->setPreferentialTrade($preferentialTrade)
            ->setStatisticalValue($statisticalValue)
            ->setStatisticalQuantity($statisticalQuantity)
            ->setNationalCustomsFields($nationalCustomsFields);
    }
    /**
     * Get quantity value
     * @return \GLS\CQuantityExt
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param \GLS\CQuantityExt $quantity
     * @return \GLS\CBulkCustomsClearanceLineItem
     */
    public function setQuantity(\GLS\CQuantityExt $quantity = null)
    {
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get commodityCode value
     * @return string
     */
    public function getCommodityCode()
    {
        return $this->commodityCode;
    }
    /**
     * Set commodityCode value
     * @param string $commodityCode
     * @return \GLS\CBulkCustomsClearanceLineItem
     */
    public function setCommodityCode($commodityCode = null)
    {
        // validation for constraint: string
        if (!is_null($commodityCode) && !is_string($commodityCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($commodityCode, true), gettype($commodityCode)), __LINE__);
        }
        $this->commodityCode = $commodityCode;
        return $this;
    }
    /**
     * Get goodsDescription value
     * @return string
     */
    public function getGoodsDescription()
    {
        return $this->goodsDescription;
    }
    /**
     * Set goodsDescription value
     * @param string $goodsDescription
     * @return \GLS\CBulkCustomsClearanceLineItem
     */
    public function setGoodsDescription($goodsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($goodsDescription) && !is_string($goodsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($goodsDescription, true), gettype($goodsDescription)), __LINE__);
        }
        $this->goodsDescription = $goodsDescription;
        return $this;
    }
    /**
     * Get countryOfOrigin value
     * @return string
     */
    public function getCountryOfOrigin()
    {
        return $this->countryOfOrigin;
    }
    /**
     * Set countryOfOrigin value
     * @param string $countryOfOrigin
     * @return \GLS\CBulkCustomsClearanceLineItem
     */
    public function setCountryOfOrigin($countryOfOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($countryOfOrigin) && !is_string($countryOfOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countryOfOrigin, true), gettype($countryOfOrigin)), __LINE__);
        }
        $this->countryOfOrigin = $countryOfOrigin;
        return $this;
    }
    /**
     * Get valueInInvoiceCurrency value
     * @return float
     */
    public function getValueInInvoiceCurrency()
    {
        return $this->valueInInvoiceCurrency;
    }
    /**
     * Set valueInInvoiceCurrency value
     * @param float $valueInInvoiceCurrency
     * @return \GLS\CBulkCustomsClearanceLineItem
     */
    public function setValueInInvoiceCurrency($valueInInvoiceCurrency = null)
    {
        // validation for constraint: float
        if (!is_null($valueInInvoiceCurrency) && !(is_float($valueInInvoiceCurrency) || is_numeric($valueInInvoiceCurrency))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($valueInInvoiceCurrency, true), gettype($valueInInvoiceCurrency)), __LINE__);
        }
        $this->valueInInvoiceCurrency = $valueInInvoiceCurrency;
        return $this;
    }
    /**
     * Get grossWeight value
     * @return \GLS\CWeightExt
     */
    public function getGrossWeight()
    {
        return $this->grossWeight;
    }
    /**
     * Set grossWeight value
     * @param \GLS\CWeightExt $grossWeight
     * @return \GLS\CBulkCustomsClearanceLineItem
     */
    public function setGrossWeight(\GLS\CWeightExt $grossWeight = null)
    {
        $this->grossWeight = $grossWeight;
        return $this;
    }
    /**
     * Get netWeight value
     * @return \GLS\CWeightExt
     */
    public function getNetWeight()
    {
        return $this->netWeight;
    }
    /**
     * Set netWeight value
     * @param \GLS\CWeightExt $netWeight
     * @return \GLS\CBulkCustomsClearanceLineItem
     */
    public function setNetWeight(\GLS\CWeightExt $netWeight = null)
    {
        $this->netWeight = $netWeight;
        return $this;
    }
    /**
     * Get preferentialTrade value
     * @return \GLS\CBulkCustomsClearanceLineItemPreferentialTrade|null
     */
    public function getPreferentialTrade()
    {
        return $this->preferentialTrade;
    }
    /**
     * Set preferentialTrade value
     * @param \GLS\CBulkCustomsClearanceLineItemPreferentialTrade $preferentialTrade
     * @return \GLS\CBulkCustomsClearanceLineItem
     */
    public function setPreferentialTrade(\GLS\CBulkCustomsClearanceLineItemPreferentialTrade $preferentialTrade = null)
    {
        $this->preferentialTrade = $preferentialTrade;
        return $this;
    }
    /**
     * Get statisticalValue value
     * @return \GLS\CAmountOfMoney|null
     */
    public function getStatisticalValue()
    {
        return $this->statisticalValue;
    }
    /**
     * Set statisticalValue value
     * @param \GLS\CAmountOfMoney $statisticalValue
     * @return \GLS\CBulkCustomsClearanceLineItem
     */
    public function setStatisticalValue(\GLS\CAmountOfMoney $statisticalValue = null)
    {
        $this->statisticalValue = $statisticalValue;
        return $this;
    }
    /**
     * Get statisticalQuantity value
     * @return float|null
     */
    public function getStatisticalQuantity()
    {
        return $this->statisticalQuantity;
    }
    /**
     * Set statisticalQuantity value
     * @param float $statisticalQuantity
     * @return \GLS\CBulkCustomsClearanceLineItem
     */
    public function setStatisticalQuantity($statisticalQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($statisticalQuantity) && !(is_float($statisticalQuantity) || is_numeric($statisticalQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($statisticalQuantity, true), gettype($statisticalQuantity)), __LINE__);
        }
        $this->statisticalQuantity = $statisticalQuantity;
        return $this;
    }
    /**
     * Get nationalCustomsFields value
     * @return \GLS\CBulkCustomsClearanceLineItemNationalCustomsFields|null
     */
    public function getNationalCustomsFields()
    {
        return $this->nationalCustomsFields;
    }
    /**
     * Set nationalCustomsFields value
     * @param \GLS\CBulkCustomsClearanceLineItemNationalCustomsFields $nationalCustomsFields
     * @return \GLS\CBulkCustomsClearanceLineItem
     */
    public function setNationalCustomsFields(\GLS\CBulkCustomsClearanceLineItemNationalCustomsFields $nationalCustomsFields = null)
    {
        $this->nationalCustomsFields = $nationalCustomsFields;
        return $this;
    }
}
