<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ade Service
 * @subpackage Services
 */
class Ade extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named adeLogin
     * Meta information extracted from the WSDL
     * - documentation: Login to ADE Plus.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeLogin $parameters
     * @return \GLS\AdeLoginResponse|bool
     */
    public function adeLogin(\GLS\AdeLogin $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLoginIntegrator
     * Meta information extracted from the WSDL
     * - documentation: Login integrator to ADE Plus.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeLoginIntegrator $parameters
     * @return \GLS\AdeLoginIntegratorResponse|bool
     */
    public function adeLoginIntegrator(\GLS\AdeLoginIntegrator $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLoginIntegrator($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLoginByLocalizationCode
     * Meta information extracted from the WSDL
     * - documentation: Login to ADE Plus by Localization Code.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeLoginByLocalizationCode $parameters
     * @return \GLS\AdeLoginByLocalizationCodeResponse|bool
     */
    public function adeLoginByLocalizationCode(\GLS\AdeLoginByLocalizationCode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLoginByLocalizationCode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLogout
     * Meta information extracted from the WSDL
     * - documentation: Logout from ADE Plus.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeLogout $parameters
     * @return \GLS\AdeLogoutResponse|bool
     */
    public function adeLogout(\GLS\AdeLogout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLogout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_Insert
     * Meta information extracted from the WSDL
     * - documentation: Insert consignment to preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePreparingBox_Insert $parameters
     * @return \GLS\AdePreparingBox_InsertResponse|bool
     */
    public function adePreparingBox_Insert(\GLS\AdePreparingBox_Insert $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_Insert($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_InsertExt
     * Meta information extracted from the WSDL
     * - documentation: Insert consignment to preparing box (version with Customs Declaration).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePreparingBox_InsertExt $parameters
     * @return \GLS\AdePreparingBox_InsertExtResponse|bool
     */
    public function adePreparingBox_InsertExt(\GLS\AdePreparingBox_InsertExt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_InsertExt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsignIDs
     * Meta information extracted from the WSDL
     * - documentation: List consignments from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePreparingBox_GetConsignIDs $parameters
     * @return \GLS\AdePreparingBox_GetConsignIDsResponse|bool
     */
    public function adePreparingBox_GetConsignIDs(\GLS\AdePreparingBox_GetConsignIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_DeleteConsign
     * Meta information extracted from the WSDL
     * - documentation: Delete consignment from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePreparingBox_DeleteConsign $parameters
     * @return \GLS\AdePreparingBox_DeleteConsignResponse|bool
     */
    public function adePreparingBox_DeleteConsign(\GLS\AdePreparingBox_DeleteConsign $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_DeleteConsign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_DeleteParcel
     * Meta information extracted from the WSDL
     * - documentation: Delete consignment from preparing box based on number of parcel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePreparingBox_DeleteParcel $parameters
     * @return \GLS\AdePreparingBox_DeleteParcelResponse|bool
     */
    public function adePreparingBox_DeleteParcel(\GLS\AdePreparingBox_DeleteParcel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_DeleteParcel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsign
     * Meta information extracted from the WSDL
     * - documentation: Get data about consignment from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePreparingBox_GetConsign $parameters
     * @return \GLS\AdePreparingBox_GetConsignResponse|bool
     */
    public function adePreparingBox_GetConsign(\GLS\AdePreparingBox_GetConsign $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsignLabels
     * Meta information extracted from the WSDL
     * - documentation: Get consignment labels from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePreparingBox_GetConsignLabels $parameters
     * @return \GLS\AdePreparingBox_GetConsignLabelsResponse|bool
     */
    public function adePreparingBox_GetConsignLabels(\GLS\AdePreparingBox_GetConsignLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * adePreparingBox_GetConsignLabelsExt
     * Meta information extracted from the WSDL
     * - documentation: Get consignment labels from preparing box (separately).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePreparingBox_GetConsignLabelsExt $parameters
     * @return \GLS\AdePreparingBox_GetConsignLabelsExtResponse|bool
     */
    public function adePreparingBox_GetConsignLabelsExt(\GLS\AdePreparingBox_GetConsignLabelsExt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignLabelsExt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsignDocs
     * Meta information extracted from the WSDL
     * - documentation: Get all consignment documents from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePreparingBox_GetConsignDocs $parameters
     * @return \GLS\AdePreparingBox_GetConsignDocsResponse|bool
     */
    public function adePreparingBox_GetConsignDocs(\GLS\AdePreparingBox_GetConsignDocs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignDocs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetConsignsLabels
     * Meta information extracted from the WSDL
     * - documentation: Get consignment labels from preparing box (via consign ids array)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePreparingBox_GetConsignsLabels $parameters
     * @return \GLS\AdePreparingBox_GetConsignsLabelsResponse|bool
     */
    public function adePreparingBox_GetConsignsLabels(\GLS\AdePreparingBox_GetConsignsLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignsLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePreparingBox_GetParcelLabel
     * Meta information extracted from the WSDL
     * - documentation: Get parcel label from preparing box
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePreparingBox_GetParcelLabel $parameters
     * @return \GLS\AdePreparingBox_GetParcelLabelResponse|bool
     */
    public function adePreparingBox_GetParcelLabel(\GLS\AdePreparingBox_GetParcelLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetParcelLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_Create
     * Meta information extracted from the WSDL
     * - documentation: Create pickup from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_Create $parameters
     * @return \GLS\AdePickup_CreateResponse|bool
     */
    public function adePickup_Create(\GLS\AdePickup_Create $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_Create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetIDs
     * Meta information extracted from the WSDL
     * - documentation: List avail pickups.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_GetIDs $parameters
     * @return \GLS\AdePickup_GetIDsResponse|bool
     */
    public function adePickup_GetIDs(\GLS\AdePickup_GetIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_Get
     * Meta information extracted from the WSDL
     * - documentation: Get info about pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_Get $parameters
     * @return \GLS\AdePickup_GetResponse|bool
     */
    public function adePickup_Get(\GLS\AdePickup_Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignBinds
     * Meta information extracted from the WSDL
     * - documentation: List of shipment IDs with their associated/bind shipment IDs from preparing box for a single shipment confirmation.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_GetConsignBinds $parameters
     * @return \GLS\AdePickup_GetConsignBindsResponse|bool
     */
    public function adePickup_GetConsignBinds(\GLS\AdePickup_GetConsignBinds $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignBinds($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignIDs
     * Meta information extracted from the WSDL
     * - documentation: List consignments from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_GetConsignIDs $parameters
     * @return \GLS\AdePickup_GetConsignIDsResponse|bool
     */
    public function adePickup_GetConsignIDs(\GLS\AdePickup_GetConsignIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsign
     * Meta information extracted from the WSDL
     * - documentation: Get data about consignment.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_GetConsign $parameters
     * @return \GLS\AdePickup_GetConsignResponse|bool
     */
    public function adePickup_GetConsign(\GLS\AdePickup_GetConsign $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsign($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetReceipt
     * Meta information extracted from the WSDL
     * - documentation: Get receipt from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_GetReceipt $parameters
     * @return \GLS\AdePickup_GetReceiptResponse|bool
     */
    public function adePickup_GetReceipt(\GLS\AdePickup_GetReceipt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetReceipt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetLabels
     * Meta information extracted from the WSDL
     * - documentation: Get labels from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_GetLabels $parameters
     * @return \GLS\AdePickup_GetLabelsResponse|bool
     */
    public function adePickup_GetLabels(\GLS\AdePickup_GetLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetIdent
     * Meta information extracted from the WSDL
     * - documentation: Get ident document from pickup.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_GetIdent $parameters
     * @return \GLS\AdePickup_GetIdentResponse|bool
     */
    public function adePickup_GetIdent(\GLS\AdePickup_GetIdent $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetIdent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignLabels
     * Meta information extracted from the WSDL
     * - documentation: Get labels from consignment.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_GetConsignLabels $parameters
     * @return \GLS\AdePickup_GetConsignLabelsResponse|bool
     */
    public function adePickup_GetConsignLabels(\GLS\AdePickup_GetConsignLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignLabelsExt
     * Meta information extracted from the WSDL
     * - documentation: Get labels from consignment (separately).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_GetConsignLabelsExt $parameters
     * @return \GLS\AdePickup_GetConsignLabelsExtResponse|bool
     */
    public function adePickup_GetConsignLabelsExt(\GLS\AdePickup_GetConsignLabelsExt $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignLabelsExt($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetParcelLabel
     * Meta information extracted from the WSDL
     * - documentation: Get parcel label from pickup
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_GetParcelLabel $parameters
     * @return \GLS\AdePickup_GetParcelLabelResponse|bool
     */
    public function adePickup_GetParcelLabel(\GLS\AdePickup_GetParcelLabel $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetParcelLabel($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetParcelsLabels
     * Meta information extracted from the WSDL
     * - documentation: Get parcels labels from pickup (array nums on input)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_GetParcelsLabels $parameters
     * @return \GLS\AdePickup_GetParcelsLabelsResponse|bool
     */
    public function adePickup_GetParcelsLabels(\GLS\AdePickup_GetParcelsLabels $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetParcelsLabels($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_ParcelNumberSearch
     * Meta information extracted from the WSDL
     * - documentation: Search for consignment based on number of parcel.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_ParcelNumberSearch $parameters
     * @return \GLS\AdePickup_ParcelNumberSearchResponse|bool
     */
    public function adePickup_ParcelNumberSearch(\GLS\AdePickup_ParcelNumberSearch $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_ParcelNumberSearch($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePartner_GetParcelNumber
     * Meta information extracted from the WSDL
     * - documentation: Search for partner parcel number based on GLS parcel number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePartner_GetParcelNumber $parameters
     * @return \GLS\AdePartner_GetParcelNumberResponse|bool
     */
    public function adePartner_GetParcelNumber(\GLS\AdePartner_GetParcelNumber $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePartner_GetParcelNumber($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeTrackID_Get
     * Meta information extracted from the WSDL
     * - documentation: Search for TrackID based on GLS parcel number.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeTrackID_Get $parameters
     * @return \GLS\AdeTrackID_GetResponse|bool
     */
    public function adeTrackID_Get(\GLS\AdeTrackID_Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeTrackID_Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeProfile_GetIDs
     * Meta information extracted from the WSDL
     * - documentation: Get profiles info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeProfile_GetIDs $parameters
     * @return \GLS\AdeProfile_GetIDsResponse|bool
     */
    public function adeProfile_GetIDs(\GLS\AdeProfile_GetIDs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeProfile_GetIDs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeProfile_GetActive
     * Meta information extracted from the WSDL
     * - documentation: Get active profile info.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeProfile_GetActive $parameters
     * @return \GLS\AdeProfile_GetActiveResponse|bool
     */
    public function adeProfile_GetActive(\GLS\AdeProfile_GetActive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeProfile_GetActive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeProfile_Change
     * Meta information extracted from the WSDL
     * - documentation: Change profile.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeProfile_Change $parameters
     * @return \GLS\AdeProfile_ChangeResponse|bool
     */
    public function adeProfile_Change(\GLS\AdeProfile_Change $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeProfile_Change($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLang_GetActive
     * Meta information extracted from the WSDL
     * - documentation: Get active language.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeLang_GetActive $parameters
     * @return \GLS\AdeLang_GetActiveResponse|bool
     */
    public function adeLang_GetActive(\GLS\AdeLang_GetActive $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLang_GetActive($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeLang_Change
     * Meta information extracted from the WSDL
     * - documentation: Change language
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeLang_Change $parameters
     * @return \GLS\AdeLang_ChangeResponse|bool
     */
    public function adeLang_Change(\GLS\AdeLang_Change $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeLang_Change($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePfc_GetStatus
     * Meta information extracted from the WSDL
     * - documentation: Return the PFC status.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePfc_GetStatus $parameters
     * @return \GLS\AdePfc_GetStatusResponse|bool
     */
    public function adePfc_GetStatus(\GLS\AdePfc_GetStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePfc_GetStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePfc_GetDictionary
     * Meta information extracted from the WSDL
     * - documentation: Return the addresss of the sender dictionary.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePfc_GetDictionary $parameters
     * @return \GLS\AdePfc_GetDictionaryResponse|bool
     */
    public function adePfc_GetDictionary(\GLS\AdePfc_GetDictionary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePfc_GetDictionary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeSendAddr_GetStatus
     * Meta information extracted from the WSDL
     * - documentation: Return the PFC status.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeSendAddr_GetStatus $parameters
     * @return \GLS\AdeSendAddr_GetStatusResponse|bool
     */
    public function adeSendAddr_GetStatus(\GLS\AdeSendAddr_GetStatus $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeSendAddr_GetStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeSendAddr_GetDictionary
     * Meta information extracted from the WSDL
     * - documentation: Return the addresss of the sender dictionary.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeSendAddr_GetDictionary $parameters
     * @return \GLS\AdeSendAddr_GetDictionaryResponse|bool
     */
    public function adeSendAddr_GetDictionary(\GLS\AdeSendAddr_GetDictionary $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeSendAddr_GetDictionary($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetAllowed
     * Meta information extracted from the WSDL
     * - documentation: Get allowed services for user.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeServices_GetAllowed $parameters
     * @return \GLS\AdeServices_GetAllowedResponse|bool
     */
    public function adeServices_GetAllowed(\GLS\AdeServices_GetAllowed $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetAllowed($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetMaxCOD
     * Meta information extracted from the WSDL
     * - documentation: Return maximum amount of COD.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeServices_GetMaxCOD $parameters
     * @return \GLS\AdeServices_GetMaxCODResponse|bool
     */
    public function adeServices_GetMaxCOD(\GLS\AdeServices_GetMaxCOD $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetMaxCOD($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetMaxParcelWeights
     * Meta information extracted from the WSDL
     * - documentation: Return maximum parcel weights (national and international).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeServices_GetMaxParcelWeights $parameters
     * @return \GLS\AdeServices_GetMaxParcelWeightsResponse|bool
     */
    public function adeServices_GetMaxParcelWeights(\GLS\AdeServices_GetMaxParcelWeights $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetMaxParcelWeights($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetGuaranteed
     * Meta information extracted from the WSDL
     * - documentation: Get guaranteed services for given zip code.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeServices_GetGuaranteed $parameters
     * @return \GLS\AdeServices_GetGuaranteedResponse|bool
     */
    public function adeServices_GetGuaranteed(\GLS\AdeServices_GetGuaranteed $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetGuaranteed($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetCountriesSDS
     * Meta information extracted from the WSDL
     * - documentation: Return the list of countries supporting SDS service.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeServices_GetCountriesSDS $parameters
     * @return \GLS\AdeServices_GetCountriesSDSResponse|bool
     */
    public function adeServices_GetCountriesSDS(\GLS\AdeServices_GetCountriesSDS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetCountriesSDS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetCountriesSRS
     * Meta information extracted from the WSDL
     * - documentation: Return the list of countries supporting SRS service.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeServices_GetCountriesSRS $parameters
     * @return \GLS\AdeServices_GetCountriesSRSResponse|bool
     */
    public function adeServices_GetCountriesSRS(\GLS\AdeServices_GetCountriesSRS $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetCountriesSRS($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeServices_GetCountriesCDX
     * Meta information extracted from the WSDL
     * - documentation: Return the list of countries, maximum CDX amount and currency supporting CDX service.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeServices_GetCountriesCDX $parameters
     * @return \GLS\AdeServices_GetCountriesCDXResponse|bool
     */
    public function adeServices_GetCountriesCDX(\GLS\AdeServices_GetCountriesCDX $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeServices_GetCountriesCDX($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeZip_GetCity
     * Meta information extracted from the WSDL
     * - documentation: Search for city.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeZip_GetCity $parameters
     * @return \GLS\AdeZip_GetCityResponse|bool
     */
    public function adeZip_GetCity(\GLS\AdeZip_GetCity $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeZip_GetCity($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeZip_CustomsRequired
     * Meta information extracted from the WSDL
     * - documentation: Search for custom declaration requirements.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeZip_CustomsRequired $parameters
     * @return \GLS\AdeZip_CustomsRequiredResponse|bool
     */
    public function adeZip_CustomsRequired(\GLS\AdeZip_CustomsRequired $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeZip_CustomsRequired($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeOption_Get
     * Meta information extracted from the WSDL
     * - documentation: Get system option.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeOption_Get $parameters
     * @return \GLS\AdeOption_GetResponse|bool
     */
    public function adeOption_Get(\GLS\AdeOption_Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeOption_Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeOption_Set
     * Meta information extracted from the WSDL
     * - documentation: Set system option.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeOption_Set $parameters
     * @return \GLS\AdeOption_SetResponse|bool
     */
    public function adeOption_Set(\GLS\AdeOption_Set $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeOption_Set($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop_SearchByZip
     * Meta information extracted from the WSDL
     * - documentation: Search for ParcelShop by zip
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeParcelShop_SearchByZip $parameters
     * @return \GLS\AdeParcelShop_SearchByZipResponse|bool
     */
    public function adeParcelShop_SearchByZip(\GLS\AdeParcelShop_SearchByZip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop_SearchByZip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop_SearchByID
     * Meta information extracted from the WSDL
     * - documentation: Search for ParcelShop by ID
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeParcelShop_SearchByID $parameters
     * @return \GLS\AdeParcelShop_SearchByIDResponse|bool
     */
    public function adeParcelShop_SearchByID(\GLS\AdeParcelShop_SearchByID $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop_SearchByID($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop_GetByCountry
     * Meta information extracted from the WSDL
     * - documentation: Get active ParcelShops by country
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeParcelShop_GetByCountry $parameters
     * @return \GLS\AdeParcelShop_GetByCountryResponse|bool
     */
    public function adeParcelShop_GetByCountry(\GLS\AdeParcelShop_GetByCountry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop_GetByCountry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop2_GetByCountry
     * Meta information extracted from the WSDL
     * - documentation: Get active ParcelShops by country (version 2)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeParcelShop2_GetByCountry $parameters
     * @return \GLS\AdeParcelShop2_GetByCountryResponse|bool
     */
    public function adeParcelShop2_GetByCountry(\GLS\AdeParcelShop2_GetByCountry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop2_GetByCountry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop2_SearchByZip
     * Meta information extracted from the WSDL
     * - documentation: Search for ParcelShop by Zip (version 2)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeParcelShop2_SearchByZip $parameters
     * @return \GLS\AdeParcelShop2_SearchByZipResponse|bool
     */
    public function adeParcelShop2_SearchByZip(\GLS\AdeParcelShop2_SearchByZip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop2_SearchByZip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop3_GetByCountry
     * Meta information extracted from the WSDL
     * - documentation: Get active ParcelShops by country (version 3)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeParcelShop3_GetByCountry $parameters
     * @return \GLS\AdeParcelShop3_GetByCountryResponse|bool
     */
    public function adeParcelShop3_GetByCountry(\GLS\AdeParcelShop3_GetByCountry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop3_GetByCountry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeParcelShop3_SearchByZip
     * Meta information extracted from the WSDL
     * - documentation: Search for ParcelShop by Zip (version 3)
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeParcelShop3_SearchByZip $parameters
     * @return \GLS\AdeParcelShop3_SearchByZipResponse|bool
     */
    public function adeParcelShop3_SearchByZip(\GLS\AdeParcelShop3_SearchByZip $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeParcelShop3_SearchByZip($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * adePreparingBox_GetConsignCustomsDec
     * Meta information extracted from the WSDL
     * - documentation: Get consignment customs declarations from preparing box.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePreparingBox_GetConsignCustomsDec $parameters
     * @return \GLS\AdePreparingBox_GetConsignCustomsDecResponse|bool
     */
    public function adePreparingBox_GetConsignCustomsDec(\GLS\AdePreparingBox_GetConsignCustomsDec $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePreparingBox_GetConsignCustomsDec($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignCustomsDec
     * Meta information extracted from the WSDL
     * - documentation: Get customs declarations for consignment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_GetConsignCustomsDec $parameters
     * @return \GLS\AdePickup_GetConsignCustomsDecResponse|bool
     */
    public function adePickup_GetConsignCustomsDec(\GLS\AdePickup_GetConsignCustomsDec $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignCustomsDec($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePickup_GetConsignPODs
     * Meta information extracted from the WSDL
     * - documentation: Get PODs pdf files from consignment (separately).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePickup_GetConsignPODs $parameters
     * @return \GLS\AdePickup_GetConsignPODsResponse|bool
     */
    public function adePickup_GetConsignPODs(\GLS\AdePickup_GetConsignPODs $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePickup_GetConsignPODs($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adePOD_Get
     * Meta information extracted from the WSDL
     * - documentation: Get POD pdf file for parcel
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdePOD_Get $parameters
     * @return \GLS\AdePOD_GetResponse|bool
     */
    public function adePOD_Get(\GLS\AdePOD_Get $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adePOD_Get($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeCourier_Order
     * Meta information extracted from the WSDL
     * - documentation: Order courier
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeCourier_Order $parameters
     * @return \GLS\AdeCourier_OrderResponse|bool
     */
    public function adeCourier_Order(\GLS\AdeCourier_Order $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeCourier_Order($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named adeBulkCustomsClearance_Create
     * Meta information extracted from the WSDL
     * - documentation: Create customs declaration for list of parcels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeBulkCustomsClearance_Create $parameters
     * @return \GLS\AdeBulkCustomsClearance_CreateResponse|bool
     */
    public function adeBulkCustomsClearance_Create(\GLS\AdeBulkCustomsClearance_Create $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeBulkCustomsClearance_Create($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * adeBulkCustomsClearance_UploadDocument
     * Meta information extracted from the WSDL
     * - documentation: Create customs declaration for list of parcels
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \GLS\AdeBulkCustomsClearance_UploadDocument $parameters
     * @return \GLS\AdeBulkCustomsClearance_UploadDocumentResponse|bool
     */
    public function adeBulkCustomsClearance_UploadDocument(\GLS\AdeBulkCustomsClearance_UploadDocument $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->adeBulkCustomsClearance_UploadDocument($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \GLS\AdeBulkCustomsClearance_CreateResponse|\GLS\AdeBulkCustomsClearance_UploadDocumentResponse|\GLS\AdeCourier_OrderResponse|\GLS\AdeLang_ChangeResponse|\GLS\AdeLang_GetActiveResponse|\GLS\AdeLoginByLocalizationCodeResponse|\GLS\AdeLoginIntegratorResponse|\GLS\AdeLoginResponse|\GLS\AdeLogoutResponse|\GLS\AdeOption_GetResponse|\GLS\AdeOption_SetResponse|\GLS\AdeParcelShop2_GetByCountryResponse|\GLS\AdeParcelShop2_SearchByZipResponse|\GLS\AdeParcelShop3_GetByCountryResponse|\GLS\AdeParcelShop3_SearchByZipResponse|\GLS\AdeParcelShop_GetByCountryResponse|\GLS\AdeParcelShop_SearchByIDResponse|\GLS\AdeParcelShop_SearchByZipResponse|\GLS\AdePartner_GetParcelNumberResponse|\GLS\AdePfc_GetDictionaryResponse|\GLS\AdePfc_GetStatusResponse|\GLS\AdePickup_CreateResponse|\GLS\AdePickup_GetConsignBindsResponse|\GLS\AdePickup_GetConsignCustomsDecResponse|\GLS\AdePickup_GetConsignIDsResponse|\GLS\AdePickup_GetConsignLabelsExtResponse|\GLS\AdePickup_GetConsignLabelsResponse|\GLS\AdePickup_GetConsignPODsResponse|\GLS\AdePickup_GetConsignResponse|\GLS\AdePickup_GetIdentResponse|\GLS\AdePickup_GetIDsResponse|\GLS\AdePickup_GetLabelsResponse|\GLS\AdePickup_GetParcelLabelResponse|\GLS\AdePickup_GetParcelsLabelsResponse|\GLS\AdePickup_GetReceiptResponse|\GLS\AdePickup_GetResponse|\GLS\AdePickup_ParcelNumberSearchResponse|\GLS\AdePOD_GetResponse|\GLS\AdePreparingBox_DeleteConsignResponse|\GLS\AdePreparingBox_DeleteParcelResponse|\GLS\AdePreparingBox_GetConsignCustomsDecResponse|\GLS\AdePreparingBox_GetConsignDocsResponse|\GLS\AdePreparingBox_GetConsignIDsResponse|\GLS\AdePreparingBox_GetConsignLabelsExtResponse|\GLS\AdePreparingBox_GetConsignLabelsResponse|\GLS\AdePreparingBox_GetConsignResponse|\GLS\AdePreparingBox_GetConsignsLabelsResponse|\GLS\AdePreparingBox_GetParcelLabelResponse|\GLS\AdePreparingBox_InsertExtResponse|\GLS\AdePreparingBox_InsertResponse|\GLS\AdeProfile_ChangeResponse|\GLS\AdeProfile_GetActiveResponse|\GLS\AdeProfile_GetIDsResponse|\GLS\AdeSendAddr_GetDictionaryResponse|\GLS\AdeSendAddr_GetStatusResponse|\GLS\AdeServices_GetAllowedResponse|\GLS\AdeServices_GetCountriesCDXResponse|\GLS\AdeServices_GetCountriesSDSResponse|\GLS\AdeServices_GetCountriesSRSResponse|\GLS\AdeServices_GetGuaranteedResponse|\GLS\AdeServices_GetMaxCODResponse|\GLS\AdeServices_GetMaxParcelWeightsResponse|\GLS\AdeTrackID_GetResponse|\GLS\AdeZip_CustomsRequiredResponse|\GLS\AdeZip_GetCityResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
