<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for cConsignBindIDsArray Array
 * @subpackage Arrays
 */
class CConsignBindIDsArray extends AbstractStructArrayBase
{
    /**
     * The items
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \GLS\CConsignBindIDs[]
     */
    public $items;
    /**
     * Constructor method for cConsignBindIDsArray
     * @uses CConsignBindIDsArray::setItems()
     * @param \GLS\CConsignBindIDs[] $items
     */
    public function __construct(array $items = array())
    {
        $this
            ->setItems($items);
    }
    /**
     * Get items value
     * @return \GLS\CConsignBindIDs[]
     */
    public function getItems()
    {
        return $this->items;
    }
    /**
     * This method is responsible for validating the values passed to the setItems method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItems method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemsForArrayConstraintsFromSetItems(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cConsignBindIDsArrayItemsItem) {
            // validation for constraint: itemType
            if (!$cConsignBindIDsArrayItemsItem instanceof \GLS\CConsignBindIDs) {
                $invalidValues[] = is_object($cConsignBindIDsArrayItemsItem) ? get_class($cConsignBindIDsArrayItemsItem) : sprintf('%s(%s)', gettype($cConsignBindIDsArrayItemsItem), var_export($cConsignBindIDsArrayItemsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The items property can only contain items of type \GLS\CConsignBindIDs, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set items value
     * @throws \InvalidArgumentException
     * @param \GLS\CConsignBindIDs[] $items
     * @return \GLS\CConsignBindIDsArray
     */
    public function setItems(array $items = array())
    {
        // validation for constraint: array
        if ('' !== ($itemsArrayErrorMessage = self::validateItemsForArrayConstraintsFromSetItems($items))) {
            throw new \InvalidArgumentException($itemsArrayErrorMessage, __LINE__);
        }
        $this->items = $items;
        return $this;
    }
    /**
     * Add item to items value
     * @throws \InvalidArgumentException
     * @param \GLS\CConsignBindIDs $item
     * @return \GLS\CConsignBindIDsArray
     */
    public function addToItems(\GLS\CConsignBindIDs $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \GLS\CConsignBindIDs) {
            throw new \InvalidArgumentException(sprintf('The items property can only contain items of type \GLS\CConsignBindIDs, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->items[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \GLS\CConsignBindIDs
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \GLS\CConsignBindIDs
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \GLS\CConsignBindIDs
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \GLS\CConsignBindIDs
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \GLS\CConsignBindIDs
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string items
     */
    public function getAttributeName()
    {
        return 'items';
    }
}
