<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cBulkCustomsClearanceInvoice Struct
 * @subpackage Structs
 */
class CBulkCustomsClearanceInvoice extends AbstractStructBase
{
    /**
     * The invoiceNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $invoiceNumber;
    /**
     * The invoiceDate
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $invoiceDate;
    /**
     * The totalGoodsValue
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLS\CAmountOfMoney
     */
    public $totalGoodsValue;
    /**
     * Constructor method for cBulkCustomsClearanceInvoice
     * @uses CBulkCustomsClearanceInvoice::setInvoiceNumber()
     * @uses CBulkCustomsClearanceInvoice::setInvoiceDate()
     * @uses CBulkCustomsClearanceInvoice::setTotalGoodsValue()
     * @param string $invoiceNumber
     * @param string $invoiceDate
     * @param \GLS\CAmountOfMoney $totalGoodsValue
     */
    public function __construct($invoiceNumber = null, $invoiceDate = null, \GLS\CAmountOfMoney $totalGoodsValue = null)
    {
        $this
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceDate($invoiceDate)
            ->setTotalGoodsValue($totalGoodsValue);
    }
    /**
     * Get invoiceNumber value
     * @return string
     */
    public function getInvoiceNumber()
    {
        return $this->invoiceNumber;
    }
    /**
     * Set invoiceNumber value
     * @param string $invoiceNumber
     * @return \GLS\CBulkCustomsClearanceInvoice
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        $this->invoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get invoiceDate value
     * @return string
     */
    public function getInvoiceDate()
    {
        return $this->invoiceDate;
    }
    /**
     * Set invoiceDate value
     * @param string $invoiceDate
     * @return \GLS\CBulkCustomsClearanceInvoice
     */
    public function setInvoiceDate($invoiceDate = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceDate) && !is_string($invoiceDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceDate, true), gettype($invoiceDate)), __LINE__);
        }
        $this->invoiceDate = $invoiceDate;
        return $this;
    }
    /**
     * Get totalGoodsValue value
     * @return \GLS\CAmountOfMoney
     */
    public function getTotalGoodsValue()
    {
        return $this->totalGoodsValue;
    }
    /**
     * Set totalGoodsValue value
     * @param \GLS\CAmountOfMoney $totalGoodsValue
     * @return \GLS\CBulkCustomsClearanceInvoice
     */
    public function setTotalGoodsValue(\GLS\CAmountOfMoney $totalGoodsValue = null)
    {
        $this->totalGoodsValue = $totalGoodsValue;
        return $this;
    }
}
