<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cBulkCustomsClearance Struct
 * @subpackage Structs
 */
class CBulkCustomsClearance extends AbstractStructBase
{
    /**
     * The parcelNumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLS\CStringArray
     */
    public $parcelNumbers;
    /**
     * The glsIncotermCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $glsIncotermCode;
    /**
     * The totalGrossWeight
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLS\CWeightExt
     */
    public $totalGrossWeight;
    /**
     * The exporter
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLS\CBulkCustomsClearanceExporter
     */
    public $exporter;
    /**
     * The importer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLS\CBulkCustomsClearanceImporter
     */
    public $importer;
    /**
     * The invoice
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLS\CBulkCustomsClearanceInvoice
     */
    public $invoice;
    /**
     * The lineItems
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \GLS\CBulkCustomsClearanceLineItemsArray
     */
    public $lineItems;
    /**
     * The customerReference
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $customerReference;
    /**
     * The isExportDeclarationRequested
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $isExportDeclarationRequested;
    /**
     * The exportDeclarationNumbers
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLS\CStringArray
     */
    public $exportDeclarationNumbers;
    /**
     * The transitMRNs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLS\CStringArray
     */
    public $transitMRNs;
    /**
     * The transitType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $transitType;
    /**
     * The consignee
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLS\CBulkCustomsClearanceConsignee
     */
    public $consignee;
    /**
     * The documents
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \GLS\CBulkCustomsClearanceAttachedFilesArray
     */
    public $documents;
    /**
     * Constructor method for cBulkCustomsClearance
     * @uses CBulkCustomsClearance::setParcelNumbers()
     * @uses CBulkCustomsClearance::setGlsIncotermCode()
     * @uses CBulkCustomsClearance::setTotalGrossWeight()
     * @uses CBulkCustomsClearance::setExporter()
     * @uses CBulkCustomsClearance::setImporter()
     * @uses CBulkCustomsClearance::setInvoice()
     * @uses CBulkCustomsClearance::setLineItems()
     * @uses CBulkCustomsClearance::setCustomerReference()
     * @uses CBulkCustomsClearance::setIsExportDeclarationRequested()
     * @uses CBulkCustomsClearance::setExportDeclarationNumbers()
     * @uses CBulkCustomsClearance::setTransitMRNs()
     * @uses CBulkCustomsClearance::setTransitType()
     * @uses CBulkCustomsClearance::setConsignee()
     * @uses CBulkCustomsClearance::setDocuments()
     * @param \GLS\CStringArray $parcelNumbers
     * @param string $glsIncotermCode
     * @param \GLS\CWeightExt $totalGrossWeight
     * @param \GLS\CBulkCustomsClearanceExporter $exporter
     * @param \GLS\CBulkCustomsClearanceImporter $importer
     * @param \GLS\CBulkCustomsClearanceInvoice $invoice
     * @param \GLS\CBulkCustomsClearanceLineItemsArray $lineItems
     * @param string $customerReference
     * @param bool $isExportDeclarationRequested
     * @param \GLS\CStringArray $exportDeclarationNumbers
     * @param \GLS\CStringArray $transitMRNs
     * @param string $transitType
     * @param \GLS\CBulkCustomsClearanceConsignee $consignee
     * @param \GLS\CBulkCustomsClearanceAttachedFilesArray $documents
     */
    public function __construct(\GLS\CStringArray $parcelNumbers = null, $glsIncotermCode = null, \GLS\CWeightExt $totalGrossWeight = null, \GLS\CBulkCustomsClearanceExporter $exporter = null, \GLS\CBulkCustomsClearanceImporter $importer = null, \GLS\CBulkCustomsClearanceInvoice $invoice = null, \GLS\CBulkCustomsClearanceLineItemsArray $lineItems = null, $customerReference = null, $isExportDeclarationRequested = null, \GLS\CStringArray $exportDeclarationNumbers = null, \GLS\CStringArray $transitMRNs = null, $transitType = null, \GLS\CBulkCustomsClearanceConsignee $consignee = null, \GLS\CBulkCustomsClearanceAttachedFilesArray $documents = null)
    {
        $this
            ->setParcelNumbers($parcelNumbers)
            ->setGlsIncotermCode($glsIncotermCode)
            ->setTotalGrossWeight($totalGrossWeight)
            ->setExporter($exporter)
            ->setImporter($importer)
            ->setInvoice($invoice)
            ->setLineItems($lineItems)
            ->setCustomerReference($customerReference)
            ->setIsExportDeclarationRequested($isExportDeclarationRequested)
            ->setExportDeclarationNumbers($exportDeclarationNumbers)
            ->setTransitMRNs($transitMRNs)
            ->setTransitType($transitType)
            ->setConsignee($consignee)
            ->setDocuments($documents);
    }
    /**
     * Get parcelNumbers value
     * @return \GLS\CStringArray
     */
    public function getParcelNumbers()
    {
        return $this->parcelNumbers;
    }
    /**
     * Set parcelNumbers value
     * @param \GLS\CStringArray $parcelNumbers
     * @return \GLS\CBulkCustomsClearance
     */
    public function setParcelNumbers(\GLS\CStringArray $parcelNumbers = null)
    {
        $this->parcelNumbers = $parcelNumbers;
        return $this;
    }
    /**
     * Get glsIncotermCode value
     * @return string
     */
    public function getGlsIncotermCode()
    {
        return $this->glsIncotermCode;
    }
    /**
     * Set glsIncotermCode value
     * @param string $glsIncotermCode
     * @return \GLS\CBulkCustomsClearance
     */
    public function setGlsIncotermCode($glsIncotermCode = null)
    {
        // validation for constraint: string
        if (!is_null($glsIncotermCode) && !is_string($glsIncotermCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($glsIncotermCode, true), gettype($glsIncotermCode)), __LINE__);
        }
        $this->glsIncotermCode = $glsIncotermCode;
        return $this;
    }
    /**
     * Get totalGrossWeight value
     * @return \GLS\CWeightExt
     */
    public function getTotalGrossWeight()
    {
        return $this->totalGrossWeight;
    }
    /**
     * Set totalGrossWeight value
     * @param \GLS\CWeightExt $totalGrossWeight
     * @return \GLS\CBulkCustomsClearance
     */
    public function setTotalGrossWeight(\GLS\CWeightExt $totalGrossWeight = null)
    {
        $this->totalGrossWeight = $totalGrossWeight;
        return $this;
    }
    /**
     * Get exporter value
     * @return \GLS\CBulkCustomsClearanceExporter
     */
    public function getExporter()
    {
        return $this->exporter;
    }
    /**
     * Set exporter value
     * @param \GLS\CBulkCustomsClearanceExporter $exporter
     * @return \GLS\CBulkCustomsClearance
     */
    public function setExporter(\GLS\CBulkCustomsClearanceExporter $exporter = null)
    {
        $this->exporter = $exporter;
        return $this;
    }
    /**
     * Get importer value
     * @return \GLS\CBulkCustomsClearanceImporter
     */
    public function getImporter()
    {
        return $this->importer;
    }
    /**
     * Set importer value
     * @param \GLS\CBulkCustomsClearanceImporter $importer
     * @return \GLS\CBulkCustomsClearance
     */
    public function setImporter(\GLS\CBulkCustomsClearanceImporter $importer = null)
    {
        $this->importer = $importer;
        return $this;
    }
    /**
     * Get invoice value
     * @return \GLS\CBulkCustomsClearanceInvoice
     */
    public function getInvoice()
    {
        return $this->invoice;
    }
    /**
     * Set invoice value
     * @param \GLS\CBulkCustomsClearanceInvoice $invoice
     * @return \GLS\CBulkCustomsClearance
     */
    public function setInvoice(\GLS\CBulkCustomsClearanceInvoice $invoice = null)
    {
        $this->invoice = $invoice;
        return $this;
    }
    /**
     * Get lineItems value
     * @return \GLS\CBulkCustomsClearanceLineItemsArray
     */
    public function getLineItems()
    {
        return $this->lineItems;
    }
    /**
     * Set lineItems value
     * @param \GLS\CBulkCustomsClearanceLineItemsArray $lineItems
     * @return \GLS\CBulkCustomsClearance
     */
    public function setLineItems(\GLS\CBulkCustomsClearanceLineItemsArray $lineItems = null)
    {
        $this->lineItems = $lineItems;
        return $this;
    }
    /**
     * Get customerReference value
     * @return string|null
     */
    public function getCustomerReference()
    {
        return $this->customerReference;
    }
    /**
     * Set customerReference value
     * @param string $customerReference
     * @return \GLS\CBulkCustomsClearance
     */
    public function setCustomerReference($customerReference = null)
    {
        // validation for constraint: string
        if (!is_null($customerReference) && !is_string($customerReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerReference, true), gettype($customerReference)), __LINE__);
        }
        $this->customerReference = $customerReference;
        return $this;
    }
    /**
     * Get isExportDeclarationRequested value
     * @return bool|null
     */
    public function getIsExportDeclarationRequested()
    {
        return $this->isExportDeclarationRequested;
    }
    /**
     * Set isExportDeclarationRequested value
     * @param bool $isExportDeclarationRequested
     * @return \GLS\CBulkCustomsClearance
     */
    public function setIsExportDeclarationRequested($isExportDeclarationRequested = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExportDeclarationRequested) && !is_bool($isExportDeclarationRequested)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExportDeclarationRequested, true), gettype($isExportDeclarationRequested)), __LINE__);
        }
        $this->isExportDeclarationRequested = $isExportDeclarationRequested;
        return $this;
    }
    /**
     * Get exportDeclarationNumbers value
     * @return \GLS\CStringArray|null
     */
    public function getExportDeclarationNumbers()
    {
        return $this->exportDeclarationNumbers;
    }
    /**
     * Set exportDeclarationNumbers value
     * @param \GLS\CStringArray $exportDeclarationNumbers
     * @return \GLS\CBulkCustomsClearance
     */
    public function setExportDeclarationNumbers(\GLS\CStringArray $exportDeclarationNumbers = null)
    {
        $this->exportDeclarationNumbers = $exportDeclarationNumbers;
        return $this;
    }
    /**
     * Get transitMRNs value
     * @return \GLS\CStringArray|null
     */
    public function getTransitMRNs()
    {
        return $this->transitMRNs;
    }
    /**
     * Set transitMRNs value
     * @param \GLS\CStringArray $transitMRNs
     * @return \GLS\CBulkCustomsClearance
     */
    public function setTransitMRNs(\GLS\CStringArray $transitMRNs = null)
    {
        $this->transitMRNs = $transitMRNs;
        return $this;
    }
    /**
     * Get transitType value
     * @return string|null
     */
    public function getTransitType()
    {
        return $this->transitType;
    }
    /**
     * Set transitType value
     * @param string $transitType
     * @return \GLS\CBulkCustomsClearance
     */
    public function setTransitType($transitType = null)
    {
        // validation for constraint: string
        if (!is_null($transitType) && !is_string($transitType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transitType, true), gettype($transitType)), __LINE__);
        }
        $this->transitType = $transitType;
        return $this;
    }
    /**
     * Get consignee value
     * @return \GLS\CBulkCustomsClearanceConsignee|null
     */
    public function getConsignee()
    {
        return $this->consignee;
    }
    /**
     * Set consignee value
     * @param \GLS\CBulkCustomsClearanceConsignee $consignee
     * @return \GLS\CBulkCustomsClearance
     */
    public function setConsignee(\GLS\CBulkCustomsClearanceConsignee $consignee = null)
    {
        $this->consignee = $consignee;
        return $this;
    }
    /**
     * Get documents value
     * @return \GLS\CBulkCustomsClearanceAttachedFilesArray|null
     */
    public function getDocuments()
    {
        return $this->documents;
    }
    /**
     * Set documents value
     * @param \GLS\CBulkCustomsClearanceAttachedFilesArray $documents
     * @return \GLS\CBulkCustomsClearance
     */
    public function setDocuments(\GLS\CBulkCustomsClearanceAttachedFilesArray $documents = null)
    {
        $this->documents = $documents;
        return $this;
    }
}
