<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://adeplus.gls-poland.com/adeplus/pm1/ade_webapi2.php?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://adeplus.gls-poland.com/adeplus/pm1/ade_webapi2.php?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \GLS\ClassMap::get(),
);
/**
 * Samples for Ade ServiceType
 */
$ade = new \GLS\Ade($options);
/**
 * Sample call for adeLogin operation/method
 */
if ($ade->adeLogin(new \GLS\AdeLogin()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeLoginIntegrator operation/method
 */
if ($ade->adeLoginIntegrator(new \GLS\AdeLoginIntegrator()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeLoginByLocalizationCode operation/method
 */
if ($ade->adeLoginByLocalizationCode(new \GLS\AdeLoginByLocalizationCode()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeLogout operation/method
 */
if ($ade->adeLogout(new \GLS\AdeLogout()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_Insert operation/method
 */
if ($ade->adePreparingBox_Insert(new \GLS\AdePreparingBox_Insert()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_InsertExt operation/method
 */
if ($ade->adePreparingBox_InsertExt(new \GLS\AdePreparingBox_InsertExt()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsignIDs operation/method
 */
if ($ade->adePreparingBox_GetConsignIDs(new \GLS\AdePreparingBox_GetConsignIDs()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_DeleteConsign operation/method
 */
if ($ade->adePreparingBox_DeleteConsign(new \GLS\AdePreparingBox_DeleteConsign()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsign operation/method
 */
if ($ade->adePreparingBox_GetConsign(new \GLS\AdePreparingBox_GetConsign()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsignLabels operation/method
 */
if ($ade->adePreparingBox_GetConsignLabels(new \GLS\AdePreparingBox_GetConsignLabels()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsignLabelsExt operation/method
 */
if ($ade->adePreparingBox_GetConsignLabelsExt(new \GLS\AdePreparingBox_GetConsignLabelsExt()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsignDocs operation/method
 */
if ($ade->adePreparingBox_GetConsignDocs(new \GLS\AdePreparingBox_GetConsignDocs()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsignsLabels operation/method
 */
if ($ade->adePreparingBox_GetConsignsLabels(new \GLS\AdePreparingBox_GetConsignsLabels()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetParcelLabel operation/method
 */
if ($ade->adePreparingBox_GetParcelLabel(new \GLS\AdePreparingBox_GetParcelLabel()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_Create operation/method
 */
if ($ade->adePickup_Create(new \GLS\AdePickup_Create()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetIDs operation/method
 */
if ($ade->adePickup_GetIDs(new \GLS\AdePickup_GetIDs()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_Get operation/method
 */
if ($ade->adePickup_Get(new \GLS\AdePickup_Get()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetConsignBinds operation/method
 */
if ($ade->adePickup_GetConsignBinds(new \GLS\AdePickup_GetConsignBinds()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetConsignIDs operation/method
 */
if ($ade->adePickup_GetConsignIDs(new \GLS\AdePickup_GetConsignIDs()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetConsign operation/method
 */
if ($ade->adePickup_GetConsign(new \GLS\AdePickup_GetConsign()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetReceipt operation/method
 */
if ($ade->adePickup_GetReceipt(new \GLS\AdePickup_GetReceipt()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetLabels operation/method
 */
if ($ade->adePickup_GetLabels(new \GLS\AdePickup_GetLabels()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetIdent operation/method
 */
if ($ade->adePickup_GetIdent(new \GLS\AdePickup_GetIdent()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetConsignLabels operation/method
 */
if ($ade->adePickup_GetConsignLabels(new \GLS\AdePickup_GetConsignLabels()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetConsignLabelsExt operation/method
 */
if ($ade->adePickup_GetConsignLabelsExt(new \GLS\AdePickup_GetConsignLabelsExt()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetParcelLabel operation/method
 */
if ($ade->adePickup_GetParcelLabel(new \GLS\AdePickup_GetParcelLabel()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetParcelsLabels operation/method
 */
if ($ade->adePickup_GetParcelsLabels(new \GLS\AdePickup_GetParcelsLabels()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_ParcelNumberSearch operation/method
 */
if ($ade->adePickup_ParcelNumberSearch(new \GLS\AdePickup_ParcelNumberSearch()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePartner_GetParcelNumber operation/method
 */
if ($ade->adePartner_GetParcelNumber(new \GLS\AdePartner_GetParcelNumber()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeTrackID_Get operation/method
 */
if ($ade->adeTrackID_Get(new \GLS\AdeTrackID_Get()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeProfile_GetIDs operation/method
 */
if ($ade->adeProfile_GetIDs(new \GLS\AdeProfile_GetIDs()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeProfile_GetActive operation/method
 */
if ($ade->adeProfile_GetActive(new \GLS\AdeProfile_GetActive()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeProfile_Change operation/method
 */
if ($ade->adeProfile_Change(new \GLS\AdeProfile_Change()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeLang_GetActive operation/method
 */
if ($ade->adeLang_GetActive(new \GLS\AdeLang_GetActive()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeLang_Change operation/method
 */
if ($ade->adeLang_Change(new \GLS\AdeLang_Change()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePfc_GetStatus operation/method
 */
if ($ade->adePfc_GetStatus(new \GLS\AdePfc_GetStatus()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePfc_GetDictionary operation/method
 */
if ($ade->adePfc_GetDictionary(new \GLS\AdePfc_GetDictionary()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeSendAddr_GetStatus operation/method
 */
if ($ade->adeSendAddr_GetStatus(new \GLS\AdeSendAddr_GetStatus()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeSendAddr_GetDictionary operation/method
 */
if ($ade->adeSendAddr_GetDictionary(new \GLS\AdeSendAddr_GetDictionary()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeServices_GetAllowed operation/method
 */
if ($ade->adeServices_GetAllowed(new \GLS\AdeServices_GetAllowed()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeServices_GetMaxCOD operation/method
 */
if ($ade->adeServices_GetMaxCOD(new \GLS\AdeServices_GetMaxCOD()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeServices_GetMaxParcelWeights operation/method
 */
if ($ade->adeServices_GetMaxParcelWeights(new \GLS\AdeServices_GetMaxParcelWeights()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeServices_GetGuaranteed operation/method
 */
if ($ade->adeServices_GetGuaranteed(new \GLS\AdeServices_GetGuaranteed()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeServices_GetCountriesSDS operation/method
 */
if ($ade->adeServices_GetCountriesSDS(new \GLS\AdeServices_GetCountriesSDS()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeServices_GetCountriesSRS operation/method
 */
if ($ade->adeServices_GetCountriesSRS(new \GLS\AdeServices_GetCountriesSRS()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeServices_GetCountriesCDX operation/method
 */
if ($ade->adeServices_GetCountriesCDX(new \GLS\AdeServices_GetCountriesCDX()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeZip_GetCity operation/method
 */
if ($ade->adeZip_GetCity(new \GLS\AdeZip_GetCity()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeZip_CustomsRequired operation/method
 */
if ($ade->adeZip_CustomsRequired(new \GLS\AdeZip_CustomsRequired()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeOption_Get operation/method
 */
if ($ade->adeOption_Get(new \GLS\AdeOption_Get()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeOption_Set operation/method
 */
if ($ade->adeOption_Set(new \GLS\AdeOption_Set()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeParcelShop_SearchByZip operation/method
 */
if ($ade->adeParcelShop_SearchByZip(new \GLS\AdeParcelShop_SearchByZip()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeParcelShop_SearchByID operation/method
 */
if ($ade->adeParcelShop_SearchByID(new \GLS\AdeParcelShop_SearchByID()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeParcelShop_GetByCountry operation/method
 */
if ($ade->adeParcelShop_GetByCountry(new \GLS\AdeParcelShop_GetByCountry()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeParcelShop2_GetByCountry operation/method
 */
if ($ade->adeParcelShop2_GetByCountry(new \GLS\AdeParcelShop2_GetByCountry()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeParcelShop2_SearchByZip operation/method
 */
if ($ade->adeParcelShop2_SearchByZip(new \GLS\AdeParcelShop2_SearchByZip()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePreparingBox_GetConsignCustomsDec operation/method
 */
if ($ade->adePreparingBox_GetConsignCustomsDec(new \GLS\AdePreparingBox_GetConsignCustomsDec()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetConsignCustomsDec operation/method
 */
if ($ade->adePickup_GetConsignCustomsDec(new \GLS\AdePickup_GetConsignCustomsDec()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePickup_GetConsignPODs operation/method
 */
if ($ade->adePickup_GetConsignPODs(new \GLS\AdePickup_GetConsignPODs()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adePOD_Get operation/method
 */
if ($ade->adePOD_Get(new \GLS\AdePOD_Get()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
/**
 * Sample call for adeCourier_Order operation/method
 */
if ($ade->adeCourier_Order(new \GLS\AdeCourier_Order()) !== false) {
    print_r($ade->getResult());
} else {
    print_r($ade->getLastError());
}
