<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cLabels Struct
 * @subpackage Structs
 */
class CLabels extends AbstractStructBase
{
    /**
     * The labels
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $labels;
    /**
     * Constructor method for cLabels
     * @uses CLabels::setLabels()
     * @param string $labels
     */
    public function __construct($labels = null)
    {
        $this
            ->setLabels($labels);
    }
    /**
     * Get labels value
     * @return string
     */
    public function getLabels()
    {
        return $this->labels;
    }
    /**
     * Set labels value
     * @param string $labels
     * @return \GLS\CLabels
     */
    public function setLabels($labels = null)
    {
        // validation for constraint: string
        if (!is_null($labels) && !is_string($labels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($labels, true), gettype($labels)), __LINE__);
        }
        $this->labels = $labels;
        return $this;
    }
}
