<?php

namespace GLS;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for cCountryCDXMax Struct
 * @subpackage Structs
 */
class CCountryCDXMax extends AbstractStructBase
{
    /**
     * The country
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $country;
    /**
     * The max
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $max;
    /**
     * The curr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $curr;
    /**
     * Constructor method for cCountryCDXMax
     * @uses CCountryCDXMax::setCountry()
     * @uses CCountryCDXMax::setMax()
     * @uses CCountryCDXMax::setCurr()
     * @param string $country
     * @param float $max
     * @param string $curr
     */
    public function __construct($country = null, $max = null, $curr = null)
    {
        $this
            ->setCountry($country)
            ->setMax($max)
            ->setCurr($curr);
    }
    /**
     * Get country value
     * @return string
     */
    public function getCountry()
    {
        return $this->country;
    }
    /**
     * Set country value
     * @param string $country
     * @return \GLS\CCountryCDXMax
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->country = $country;
        return $this;
    }
    /**
     * Get max value
     * @return float
     */
    public function getMax()
    {
        return $this->max;
    }
    /**
     * Set max value
     * @param float $max
     * @return \GLS\CCountryCDXMax
     */
    public function setMax($max = null)
    {
        // validation for constraint: float
        if (!is_null($max) && !(is_float($max) || is_numeric($max))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($max, true), gettype($max)), __LINE__);
        }
        $this->max = $max;
        return $this;
    }
    /**
     * Get curr value
     * @return string
     */
    public function getCurr()
    {
        return $this->curr;
    }
    /**
     * Set curr value
     * @param string $curr
     * @return \GLS\CCountryCDXMax
     */
    public function setCurr($curr = null)
    {
        // validation for constraint: string
        if (!is_null($curr) && !is_string($curr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($curr, true), gettype($curr)), __LINE__);
        }
        $this->curr = $curr;
        return $this;
    }
}
