<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'main.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Process ServiceType
 */
$process = new \ServiceType\Process($options);
/**
 * Sample call for ProcessInsertedData operation/method
 */
if ($process->ProcessInsertedData(new \StructType\ProcessInsertedData()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessInsertedVRData operation/method
 */
if ($process->ProcessInsertedVRData(new \StructType\ProcessInsertedVRData()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessOfVRImportErrors operation/method
 */
if ($process->ProcessOfVRImportErrors(new \StructType\ProcessOfVRImportErrors()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessOfVRImportError operation/method
 */
if ($process->ProcessOfVRImportError(new \StructType\ProcessOfVRImportError()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessXMLImportEntry operation/method
 */
if ($process->ProcessXMLImportEntry(new \StructType\ProcessXMLImportEntry()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessInsertedScannerData operation/method
 */
if ($process->ProcessInsertedScannerData(new \StructType\ProcessInsertedScannerData()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessInsertedVT_KWTData operation/method
 */
if ($process->ProcessInsertedVT_KWTData(new \StructType\ProcessInsertedVT_KWTData()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Sample call for ProcessOfInternalInsertedXMLImport operation/method
 */
if ($process->ProcessOfInternalInsertedXMLImport(new \StructType\ProcessOfInternalInsertedXMLImport()) !== false) {
    print_r($process->getResult());
} else {
    print_r($process->getLastError());
}
/**
 * Samples for Show ServiceType
 */
$show = new \ServiceType\Show($options);
/**
 * Sample call for ShowStatusVRTransfer operation/method
 */
if ($show->ShowStatusVRTransfer(new \StructType\ShowStatusVRTransfer()) !== false) {
    print_r($show->getResult());
} else {
    print_r($show->getLastError());
}
/**
 * Samples for Reset ServiceType
 */
$reset = new \ServiceType\Reset($options);
/**
 * Sample call for ResetVRTransfer operation/method
 */
if ($reset->ResetVRTransfer(new \StructType\ResetVRTransfer()) !== false) {
    print_r($reset->getResult());
} else {
    print_r($reset->getLastError());
}
/**
 * Samples for Force ServiceType
 */
$force = new \ServiceType\Force($options);
/**
 * Sample call for ForceNewProcessOfVRImportErrorData operation/method
 */
if ($force->ForceNewProcessOfVRImportErrorData(new \StructType\ForceNewProcessOfVRImportErrorData()) !== false) {
    print_r($force->getResult());
} else {
    print_r($force->getLastError());
}
/**
 * Sample call for ForceNewProcessOfVRXMLImportDataWithStatusError operation/method
 */
if ($force->ForceNewProcessOfVRXMLImportDataWithStatusError(new \StructType\ForceNewProcessOfVRXMLImportDataWithStatusError()) !== false) {
    print_r($force->getResult());
} else {
    print_r($force->getLastError());
}
/**
 * Samples for Re ServiceType
 */
$re = new \ServiceType\Re($options);
/**
 * Sample call for ReProcessOfImportErrorsWithTimeout operation/method
 */
if ($re->ReProcessOfImportErrorsWithTimeout(new \StructType\ReProcessOfImportErrorsWithTimeout()) !== false) {
    print_r($re->getResult());
} else {
    print_r($re->getLastError());
}
/**
 * Sample call for ReProcessOfImportErrors operation/method
 */
if ($re->ReProcessOfImportErrors(new \StructType\ReProcessOfImportErrors()) !== false) {
    print_r($re->getResult());
} else {
    print_r($re->getLastError());
}
/**
 * Samples for Real ServiceType
 */
$real = new \ServiceType\Real($options);
/**
 * Sample call for RealProcessOfInternalInsertedXMLImports operation/method
 */
if ($real->RealProcessOfInternalInsertedXMLImports(new \StructType\RealProcessOfInternalInsertedXMLImports()) !== false) {
    print_r($real->getResult());
} else {
    print_r($real->getLastError());
}
/**
 * Samples for Import ServiceType
 */
$import = new \ServiceType\Import($options);
/**
 * Sample call for ImportPMSString operation/method
 */
if ($import->ImportPMSString() !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Sample call for ImportPMS operation/method
 */
if ($import->ImportPMS(new \StructType\Gemeinde(), $companyCode, $forceImportSettled, $forceImportCancelled, $loginID, $source, new \StructType\VTFormXml(), $checkOnly) !== false) {
    print_r($import->getResult());
} else {
    print_r($import->getLastError());
}
/**
 * Samples for Login ServiceType
 */
$login = new \ServiceType\Login($options);
/**
 * Sample call for Login operation/method
 */
if ($login->Login(new \StructType\Login()) !== false) {
    print_r($login->getResult());
} else {
    print_r($login->getLastError());
}
/**
 * Samples for PMSA ServiceType
 */
$pMSA = new \ServiceType\PMSA($options);
/**
 * Sample call for PMSAutoAssignVTBlock operation/method
 */
if ($pMSA->PMSAutoAssignVTBlock(new \StructType\PMSAutoAssignVTBlock()) !== false) {
    print_r($pMSA->getResult());
} else {
    print_r($pMSA->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetVTInfo operation/method
 */
if ($get->GetVTInfo(new \StructType\GetVTInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
