<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VTPriceType StructType
 * @subpackage Structs
 */
class VTPriceType extends AbstractStructBase
{
    /**
     * The TotalPrice
     * Meta information extracted from the WSDL
     * - use: required
     * @var float
     */
    public $TotalPrice;
    /**
     * The Tariff
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TariffType[]
     */
    public $Tariff;
    /**
     * Constructor method for VTPriceType
     * @uses VTPriceType::setTotalPrice()
     * @uses VTPriceType::setTariff()
     * @param float $totalPrice
     * @param \StructType\TariffType[] $tariff
     */
    public function __construct($totalPrice = null, array $tariff = array())
    {
        $this
            ->setTotalPrice($totalPrice)
            ->setTariff($tariff);
    }
    /**
     * Get TotalPrice value
     * @return float
     */
    public function getTotalPrice()
    {
        return $this->TotalPrice;
    }
    /**
     * Set TotalPrice value
     * @param float $totalPrice
     * @return \StructType\VTPriceType
     */
    public function setTotalPrice($totalPrice = null)
    {
        // validation for constraint: float
        if (!is_null($totalPrice) && !(is_float($totalPrice) || is_numeric($totalPrice))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalPrice, true), gettype($totalPrice)), __LINE__);
        }
        $this->TotalPrice = $totalPrice;
        return $this;
    }
    /**
     * Get Tariff value
     * @return \StructType\TariffType[]|null
     */
    public function getTariff()
    {
        return $this->Tariff;
    }
    /**
     * This method is responsible for validating the values passed to the setTariff method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTariff method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTariffForArrayConstraintsFromSetTariff(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vTPriceTypeTariffItem) {
            // validation for constraint: itemType
            if (!$vTPriceTypeTariffItem instanceof \StructType\TariffType) {
                $invalidValues[] = is_object($vTPriceTypeTariffItem) ? get_class($vTPriceTypeTariffItem) : sprintf('%s(%s)', gettype($vTPriceTypeTariffItem), var_export($vTPriceTypeTariffItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Tariff property can only contain items of type \StructType\TariffType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Tariff value
     * @throws \InvalidArgumentException
     * @param \StructType\TariffType[] $tariff
     * @return \StructType\VTPriceType
     */
    public function setTariff(array $tariff = array())
    {
        // validation for constraint: array
        if ('' !== ($tariffArrayErrorMessage = self::validateTariffForArrayConstraintsFromSetTariff($tariff))) {
            throw new \InvalidArgumentException($tariffArrayErrorMessage, __LINE__);
        }
        $this->Tariff = $tariff;
        return $this;
    }
    /**
     * Add item to Tariff value
     * @throws \InvalidArgumentException
     * @param \StructType\TariffType $item
     * @return \StructType\VTPriceType
     */
    public function addToTariff(\StructType\TariffType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TariffType) {
            throw new \InvalidArgumentException(sprintf('The Tariff property can only contain items of type \StructType\TariffType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Tariff[] = $item;
        return $this;
    }
}
