<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VTInventoryType StructType
 * @subpackage Structs
 */
class VTInventoryType extends AbstractStructBase
{
    /**
     * The ValidFrom
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ValidFrom;
    /**
     * The Objects
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Objects;
    /**
     * The Rooms
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Rooms;
    /**
     * The Beds
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Beds;
    /**
     * The AdditionalBeds
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $AdditionalBeds;
    /**
     * The EngagedRooms
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $EngagedRooms;
    /**
     * The ChangeDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ChangeDate;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The CategoryID
     * @var string
     */
    public $CategoryID;
    /**
     * The LoginID
     * @var string
     */
    public $LoginID;
    /**
     * Constructor method for VTInventoryType
     * @uses VTInventoryType::setValidFrom()
     * @uses VTInventoryType::setObjects()
     * @uses VTInventoryType::setRooms()
     * @uses VTInventoryType::setBeds()
     * @uses VTInventoryType::setAdditionalBeds()
     * @uses VTInventoryType::setEngagedRooms()
     * @uses VTInventoryType::setChangeDate()
     * @uses VTInventoryType::setID()
     * @uses VTInventoryType::setName()
     * @uses VTInventoryType::setCategoryID()
     * @uses VTInventoryType::setLoginID()
     * @param string $validFrom
     * @param int $objects
     * @param int $rooms
     * @param int $beds
     * @param int $additionalBeds
     * @param int $engagedRooms
     * @param string $changeDate
     * @param string $iD
     * @param string $name
     * @param string $categoryID
     * @param string $loginID
     */
    public function __construct($validFrom = null, $objects = null, $rooms = null, $beds = null, $additionalBeds = null, $engagedRooms = null, $changeDate = null, $iD = null, $name = null, $categoryID = null, $loginID = null)
    {
        $this
            ->setValidFrom($validFrom)
            ->setObjects($objects)
            ->setRooms($rooms)
            ->setBeds($beds)
            ->setAdditionalBeds($additionalBeds)
            ->setEngagedRooms($engagedRooms)
            ->setChangeDate($changeDate)
            ->setID($iD)
            ->setName($name)
            ->setCategoryID($categoryID)
            ->setLoginID($loginID);
    }
    /**
     * Get ValidFrom value
     * @return string
     */
    public function getValidFrom()
    {
        return $this->ValidFrom;
    }
    /**
     * Set ValidFrom value
     * @param string $validFrom
     * @return \StructType\VTInventoryType
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        $this->ValidFrom = $validFrom;
        return $this;
    }
    /**
     * Get Objects value
     * @return int
     */
    public function getObjects()
    {
        return $this->Objects;
    }
    /**
     * Set Objects value
     * @param int $objects
     * @return \StructType\VTInventoryType
     */
    public function setObjects($objects = null)
    {
        // validation for constraint: int
        if (!is_null($objects) && !(is_int($objects) || ctype_digit($objects))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($objects, true), gettype($objects)), __LINE__);
        }
        $this->Objects = $objects;
        return $this;
    }
    /**
     * Get Rooms value
     * @return int
     */
    public function getRooms()
    {
        return $this->Rooms;
    }
    /**
     * Set Rooms value
     * @param int $rooms
     * @return \StructType\VTInventoryType
     */
    public function setRooms($rooms = null)
    {
        // validation for constraint: int
        if (!is_null($rooms) && !(is_int($rooms) || ctype_digit($rooms))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rooms, true), gettype($rooms)), __LINE__);
        }
        $this->Rooms = $rooms;
        return $this;
    }
    /**
     * Get Beds value
     * @return int
     */
    public function getBeds()
    {
        return $this->Beds;
    }
    /**
     * Set Beds value
     * @param int $beds
     * @return \StructType\VTInventoryType
     */
    public function setBeds($beds = null)
    {
        // validation for constraint: int
        if (!is_null($beds) && !(is_int($beds) || ctype_digit($beds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($beds, true), gettype($beds)), __LINE__);
        }
        $this->Beds = $beds;
        return $this;
    }
    /**
     * Get AdditionalBeds value
     * @return int
     */
    public function getAdditionalBeds()
    {
        return $this->AdditionalBeds;
    }
    /**
     * Set AdditionalBeds value
     * @param int $additionalBeds
     * @return \StructType\VTInventoryType
     */
    public function setAdditionalBeds($additionalBeds = null)
    {
        // validation for constraint: int
        if (!is_null($additionalBeds) && !(is_int($additionalBeds) || ctype_digit($additionalBeds))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($additionalBeds, true), gettype($additionalBeds)), __LINE__);
        }
        $this->AdditionalBeds = $additionalBeds;
        return $this;
    }
    /**
     * Get EngagedRooms value
     * @return int
     */
    public function getEngagedRooms()
    {
        return $this->EngagedRooms;
    }
    /**
     * Set EngagedRooms value
     * @param int $engagedRooms
     * @return \StructType\VTInventoryType
     */
    public function setEngagedRooms($engagedRooms = null)
    {
        // validation for constraint: int
        if (!is_null($engagedRooms) && !(is_int($engagedRooms) || ctype_digit($engagedRooms))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($engagedRooms, true), gettype($engagedRooms)), __LINE__);
        }
        $this->EngagedRooms = $engagedRooms;
        return $this;
    }
    /**
     * Get ChangeDate value
     * @return string
     */
    public function getChangeDate()
    {
        return $this->ChangeDate;
    }
    /**
     * Set ChangeDate value
     * @param string $changeDate
     * @return \StructType\VTInventoryType
     */
    public function setChangeDate($changeDate = null)
    {
        // validation for constraint: string
        if (!is_null($changeDate) && !is_string($changeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeDate, true), gettype($changeDate)), __LINE__);
        }
        $this->ChangeDate = $changeDate;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\VTInventoryType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\VTInventoryType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get CategoryID value
     * @return string|null
     */
    public function getCategoryID()
    {
        return $this->CategoryID;
    }
    /**
     * Set CategoryID value
     * @param string $categoryID
     * @return \StructType\VTInventoryType
     */
    public function setCategoryID($categoryID = null)
    {
        // validation for constraint: string
        if (!is_null($categoryID) && !is_string($categoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryID, true), gettype($categoryID)), __LINE__);
        }
        $this->CategoryID = $categoryID;
        return $this;
    }
    /**
     * Get LoginID value
     * @return string|null
     */
    public function getLoginID()
    {
        return $this->LoginID;
    }
    /**
     * Set LoginID value
     * @param string $loginID
     * @return \StructType\VTInventoryType
     */
    public function setLoginID($loginID = null)
    {
        // validation for constraint: string
        if (!is_null($loginID) && !is_string($loginID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginID, true), gettype($loginID)), __LINE__);
        }
        $this->LoginID = $loginID;
        return $this;
    }
}
