<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VTCountryType StructType
 * @subpackage Structs
 */
class VTCountryType extends AbstractStructBase
{
    /**
     * The Country
     * @var string
     */
    public $Country;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * The StatisticCountry
     * @var string
     */
    public $StatisticCountry;
    /**
     * The ZipcodeFrom
     * @var string
     */
    public $ZipcodeFrom;
    /**
     * The ZipcodeTo
     * @var string
     */
    public $ZipcodeTo;
    /**
     * The ISO_2
     * @var string
     */
    public $ISO_2;
    /**
     * Constructor method for VTCountryType
     * @uses VTCountryType::setCountry()
     * @uses VTCountryType::setID()
     * @uses VTCountryType::setStatisticCountry()
     * @uses VTCountryType::setZipcodeFrom()
     * @uses VTCountryType::setZipcodeTo()
     * @uses VTCountryType::setISO_2()
     * @param string $country
     * @param string $iD
     * @param string $statisticCountry
     * @param string $zipcodeFrom
     * @param string $zipcodeTo
     * @param string $iSO_2
     */
    public function __construct($country = null, $iD = null, $statisticCountry = null, $zipcodeFrom = null, $zipcodeTo = null, $iSO_2 = null)
    {
        $this
            ->setCountry($country)
            ->setID($iD)
            ->setStatisticCountry($statisticCountry)
            ->setZipcodeFrom($zipcodeFrom)
            ->setZipcodeTo($zipcodeTo)
            ->setISO_2($iSO_2);
    }
    /**
     * Get Country value
     * @return string|null
     */
    public function getCountry()
    {
        return $this->Country;
    }
    /**
     * Set Country value
     * @param string $country
     * @return \StructType\VTCountryType
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($country, true), gettype($country)), __LINE__);
        }
        $this->Country = $country;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\VTCountryType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get StatisticCountry value
     * @return string|null
     */
    public function getStatisticCountry()
    {
        return $this->StatisticCountry;
    }
    /**
     * Set StatisticCountry value
     * @param string $statisticCountry
     * @return \StructType\VTCountryType
     */
    public function setStatisticCountry($statisticCountry = null)
    {
        // validation for constraint: string
        if (!is_null($statisticCountry) && !is_string($statisticCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statisticCountry, true), gettype($statisticCountry)), __LINE__);
        }
        $this->StatisticCountry = $statisticCountry;
        return $this;
    }
    /**
     * Get ZipcodeFrom value
     * @return string|null
     */
    public function getZipcodeFrom()
    {
        return $this->ZipcodeFrom;
    }
    /**
     * Set ZipcodeFrom value
     * @param string $zipcodeFrom
     * @return \StructType\VTCountryType
     */
    public function setZipcodeFrom($zipcodeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($zipcodeFrom) && !is_string($zipcodeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipcodeFrom, true), gettype($zipcodeFrom)), __LINE__);
        }
        $this->ZipcodeFrom = $zipcodeFrom;
        return $this;
    }
    /**
     * Get ZipcodeTo value
     * @return string|null
     */
    public function getZipcodeTo()
    {
        return $this->ZipcodeTo;
    }
    /**
     * Set ZipcodeTo value
     * @param string $zipcodeTo
     * @return \StructType\VTCountryType
     */
    public function setZipcodeTo($zipcodeTo = null)
    {
        // validation for constraint: string
        if (!is_null($zipcodeTo) && !is_string($zipcodeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipcodeTo, true), gettype($zipcodeTo)), __LINE__);
        }
        $this->ZipcodeTo = $zipcodeTo;
        return $this;
    }
    /**
     * Get iSO value
     * @return iSO
     */
    public function getISO_2()
    {
        return $this->{'ISO-2'};
    }
    /**
     * Set iSO value
     * @param iSO $iSO
     * @return \StructType\VTCountryType
     */
    public function setISO_2($iSO_2 = null)
    {
        // validation for constraint: string
        if (!is_null($iSO_2) && !is_string($iSO_2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iSO_2, true), gettype($iSO_2)), __LINE__);
        }
        $this->ISO_2 = $this->{'ISO-2'} = $iSO_2;
        return $this;
    }
}
