<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SettlementSPList StructType
 * @subpackage Structs
 */
class SettlementSPList extends AbstractStructBase
{
    /**
     * The Settlement
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SPSettlementType[]
     */
    public $Settlement;
    /**
     * The ServiceProviderId
     * @var string
     */
    public $ServiceProviderId;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for SettlementSPList
     * @uses SettlementSPList::setSettlement()
     * @uses SettlementSPList::setServiceProviderId()
     * @uses SettlementSPList::setName()
     * @uses SettlementSPList::setCode()
     * @param \StructType\SPSettlementType[] $settlement
     * @param string $serviceProviderId
     * @param string $name
     * @param string $code
     */
    public function __construct(array $settlement = array(), $serviceProviderId = null, $name = null, $code = null)
    {
        $this
            ->setSettlement($settlement)
            ->setServiceProviderId($serviceProviderId)
            ->setName($name)
            ->setCode($code);
    }
    /**
     * Get Settlement value
     * @return \StructType\SPSettlementType[]|null
     */
    public function getSettlement()
    {
        return $this->Settlement;
    }
    /**
     * This method is responsible for validating the values passed to the setSettlement method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSettlement method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSettlementForArrayConstraintsFromSetSettlement(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $settlementSPListSettlementItem) {
            // validation for constraint: itemType
            if (!$settlementSPListSettlementItem instanceof \StructType\SPSettlementType) {
                $invalidValues[] = is_object($settlementSPListSettlementItem) ? get_class($settlementSPListSettlementItem) : sprintf('%s(%s)', gettype($settlementSPListSettlementItem), var_export($settlementSPListSettlementItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Settlement property can only contain items of type \StructType\SPSettlementType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Settlement value
     * @throws \InvalidArgumentException
     * @param \StructType\SPSettlementType[] $settlement
     * @return \StructType\SettlementSPList
     */
    public function setSettlement(array $settlement = array())
    {
        // validation for constraint: array
        if ('' !== ($settlementArrayErrorMessage = self::validateSettlementForArrayConstraintsFromSetSettlement($settlement))) {
            throw new \InvalidArgumentException($settlementArrayErrorMessage, __LINE__);
        }
        $this->Settlement = $settlement;
        return $this;
    }
    /**
     * Add item to Settlement value
     * @throws \InvalidArgumentException
     * @param \StructType\SPSettlementType $item
     * @return \StructType\SettlementSPList
     */
    public function addToSettlement(\StructType\SPSettlementType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SPSettlementType) {
            throw new \InvalidArgumentException(sprintf('The Settlement property can only contain items of type \StructType\SPSettlementType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Settlement[] = $item;
        return $this;
    }
    /**
     * Get ServiceProviderId value
     * @return string|null
     */
    public function getServiceProviderId()
    {
        return $this->ServiceProviderId;
    }
    /**
     * Set ServiceProviderId value
     * @param string $serviceProviderId
     * @return \StructType\SettlementSPList
     */
    public function setServiceProviderId($serviceProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderId) && !is_string($serviceProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceProviderId, true), gettype($serviceProviderId)), __LINE__);
        }
        $this->ServiceProviderId = $serviceProviderId;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\SettlementSPList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\SettlementSPList
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
}
