<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceProviderVTBlocksType StructType
 * @subpackage Structs
 */
class ServiceProviderVTBlocksType extends AbstractStructBase
{
    /**
     * The AssignedVTBlock
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AssignedVTBlockType[]
     */
    public $AssignedVTBlock;
    /**
     * The ServiceProviderID
     * @var string
     */
    public $ServiceProviderID;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for ServiceProviderVTBlocksType
     * @uses ServiceProviderVTBlocksType::setAssignedVTBlock()
     * @uses ServiceProviderVTBlocksType::setServiceProviderID()
     * @uses ServiceProviderVTBlocksType::setName()
     * @uses ServiceProviderVTBlocksType::setCode()
     * @param \StructType\AssignedVTBlockType[] $assignedVTBlock
     * @param string $serviceProviderID
     * @param string $name
     * @param string $code
     */
    public function __construct(array $assignedVTBlock = array(), $serviceProviderID = null, $name = null, $code = null)
    {
        $this
            ->setAssignedVTBlock($assignedVTBlock)
            ->setServiceProviderID($serviceProviderID)
            ->setName($name)
            ->setCode($code);
    }
    /**
     * Get AssignedVTBlock value
     * @return \StructType\AssignedVTBlockType[]|null
     */
    public function getAssignedVTBlock()
    {
        return $this->AssignedVTBlock;
    }
    /**
     * This method is responsible for validating the values passed to the setAssignedVTBlock method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssignedVTBlock method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAssignedVTBlockForArrayConstraintsFromSetAssignedVTBlock(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serviceProviderVTBlocksTypeAssignedVTBlockItem) {
            // validation for constraint: itemType
            if (!$serviceProviderVTBlocksTypeAssignedVTBlockItem instanceof \StructType\AssignedVTBlockType) {
                $invalidValues[] = is_object($serviceProviderVTBlocksTypeAssignedVTBlockItem) ? get_class($serviceProviderVTBlocksTypeAssignedVTBlockItem) : sprintf('%s(%s)', gettype($serviceProviderVTBlocksTypeAssignedVTBlockItem), var_export($serviceProviderVTBlocksTypeAssignedVTBlockItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AssignedVTBlock property can only contain items of type \StructType\AssignedVTBlockType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AssignedVTBlock value
     * @throws \InvalidArgumentException
     * @param \StructType\AssignedVTBlockType[] $assignedVTBlock
     * @return \StructType\ServiceProviderVTBlocksType
     */
    public function setAssignedVTBlock(array $assignedVTBlock = array())
    {
        // validation for constraint: array
        if ('' !== ($assignedVTBlockArrayErrorMessage = self::validateAssignedVTBlockForArrayConstraintsFromSetAssignedVTBlock($assignedVTBlock))) {
            throw new \InvalidArgumentException($assignedVTBlockArrayErrorMessage, __LINE__);
        }
        $this->AssignedVTBlock = $assignedVTBlock;
        return $this;
    }
    /**
     * Add item to AssignedVTBlock value
     * @throws \InvalidArgumentException
     * @param \StructType\AssignedVTBlockType $item
     * @return \StructType\ServiceProviderVTBlocksType
     */
    public function addToAssignedVTBlock(\StructType\AssignedVTBlockType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AssignedVTBlockType) {
            throw new \InvalidArgumentException(sprintf('The AssignedVTBlock property can only contain items of type \StructType\AssignedVTBlockType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AssignedVTBlock[] = $item;
        return $this;
    }
    /**
     * Get ServiceProviderID value
     * @return string|null
     */
    public function getServiceProviderID()
    {
        return $this->ServiceProviderID;
    }
    /**
     * Set ServiceProviderID value
     * @param string $serviceProviderID
     * @return \StructType\ServiceProviderVTBlocksType
     */
    public function setServiceProviderID($serviceProviderID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderID) && !is_string($serviceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceProviderID, true), gettype($serviceProviderID)), __LINE__);
        }
        $this->ServiceProviderID = $serviceProviderID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ServiceProviderVTBlocksType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ServiceProviderVTBlocksType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
}
