<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SPSettlementType StructType
 * @subpackage Structs
 */
class SPSettlementType extends AbstractStructBase
{
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CreateDate;
    /**
     * The SettleDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $SettleDate;
    /**
     * The People
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $People;
    /**
     * The Nights
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Nights;
    /**
     * The Arrival
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Arrival;
    /**
     * The Departure
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Departure;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The PrePayment
     * Meta information extracted from the WSDL
     * - use: required
     * @var float
     */
    public $PrePayment;
    /**
     * The Payment
     * Meta information extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Payment;
    /**
     * The SheetNumber
     * @var string
     */
    public $SheetNumber;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * Constructor method for SPSettlementType
     * @uses SPSettlementType::setCreateDate()
     * @uses SPSettlementType::setSettleDate()
     * @uses SPSettlementType::setPeople()
     * @uses SPSettlementType::setNights()
     * @uses SPSettlementType::setArrival()
     * @uses SPSettlementType::setDeparture()
     * @uses SPSettlementType::setAmount()
     * @uses SPSettlementType::setPrePayment()
     * @uses SPSettlementType::setPayment()
     * @uses SPSettlementType::setSheetNumber()
     * @uses SPSettlementType::setStatus()
     * @param string $createDate
     * @param string $settleDate
     * @param int $people
     * @param int $nights
     * @param string $arrival
     * @param string $departure
     * @param float $amount
     * @param float $prePayment
     * @param float $payment
     * @param string $sheetNumber
     * @param string $status
     */
    public function __construct($createDate = null, $settleDate = null, $people = null, $nights = null, $arrival = null, $departure = null, $amount = null, $prePayment = null, $payment = null, $sheetNumber = null, $status = null)
    {
        $this
            ->setCreateDate($createDate)
            ->setSettleDate($settleDate)
            ->setPeople($people)
            ->setNights($nights)
            ->setArrival($arrival)
            ->setDeparture($departure)
            ->setAmount($amount)
            ->setPrePayment($prePayment)
            ->setPayment($payment)
            ->setSheetNumber($sheetNumber)
            ->setStatus($status);
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\SPSettlementType
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get SettleDate value
     * @return string
     */
    public function getSettleDate()
    {
        return $this->SettleDate;
    }
    /**
     * Set SettleDate value
     * @param string $settleDate
     * @return \StructType\SPSettlementType
     */
    public function setSettleDate($settleDate = null)
    {
        // validation for constraint: string
        if (!is_null($settleDate) && !is_string($settleDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($settleDate, true), gettype($settleDate)), __LINE__);
        }
        $this->SettleDate = $settleDate;
        return $this;
    }
    /**
     * Get People value
     * @return int
     */
    public function getPeople()
    {
        return $this->People;
    }
    /**
     * Set People value
     * @param int $people
     * @return \StructType\SPSettlementType
     */
    public function setPeople($people = null)
    {
        // validation for constraint: int
        if (!is_null($people) && !(is_int($people) || ctype_digit($people))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($people, true), gettype($people)), __LINE__);
        }
        $this->People = $people;
        return $this;
    }
    /**
     * Get Nights value
     * @return int
     */
    public function getNights()
    {
        return $this->Nights;
    }
    /**
     * Set Nights value
     * @param int $nights
     * @return \StructType\SPSettlementType
     */
    public function setNights($nights = null)
    {
        // validation for constraint: int
        if (!is_null($nights) && !(is_int($nights) || ctype_digit($nights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nights, true), gettype($nights)), __LINE__);
        }
        $this->Nights = $nights;
        return $this;
    }
    /**
     * Get Arrival value
     * @return string
     */
    public function getArrival()
    {
        return $this->Arrival;
    }
    /**
     * Set Arrival value
     * @param string $arrival
     * @return \StructType\SPSettlementType
     */
    public function setArrival($arrival = null)
    {
        // validation for constraint: string
        if (!is_null($arrival) && !is_string($arrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrival, true), gettype($arrival)), __LINE__);
        }
        $this->Arrival = $arrival;
        return $this;
    }
    /**
     * Get Departure value
     * @return string
     */
    public function getDeparture()
    {
        return $this->Departure;
    }
    /**
     * Set Departure value
     * @param string $departure
     * @return \StructType\SPSettlementType
     */
    public function setDeparture($departure = null)
    {
        // validation for constraint: string
        if (!is_null($departure) && !is_string($departure)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departure, true), gettype($departure)), __LINE__);
        }
        $this->Departure = $departure;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\SPSettlementType
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get PrePayment value
     * @return float
     */
    public function getPrePayment()
    {
        return $this->PrePayment;
    }
    /**
     * Set PrePayment value
     * @param float $prePayment
     * @return \StructType\SPSettlementType
     */
    public function setPrePayment($prePayment = null)
    {
        // validation for constraint: float
        if (!is_null($prePayment) && !(is_float($prePayment) || is_numeric($prePayment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($prePayment, true), gettype($prePayment)), __LINE__);
        }
        $this->PrePayment = $prePayment;
        return $this;
    }
    /**
     * Get Payment value
     * @return float
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param float $payment
     * @return \StructType\SPSettlementType
     */
    public function setPayment($payment = null)
    {
        // validation for constraint: float
        if (!is_null($payment) && !(is_float($payment) || is_numeric($payment))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($payment, true), gettype($payment)), __LINE__);
        }
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Get SheetNumber value
     * @return string|null
     */
    public function getSheetNumber()
    {
        return $this->SheetNumber;
    }
    /**
     * Set SheetNumber value
     * @param string $sheetNumber
     * @return \StructType\SPSettlementType
     */
    public function setSheetNumber($sheetNumber = null)
    {
        // validation for constraint: string
        if (!is_null($sheetNumber) && !is_string($sheetNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sheetNumber, true), gettype($sheetNumber)), __LINE__);
        }
        $this->SheetNumber = $sheetNumber;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\SPSettlementType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
}
