<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResponseType StructType
 * @subpackage Structs
 */
class ResponseType extends AbstractStructBase
{
    /**
     * The AssignedVTBlocks
     * Meta information extracted from the WSDL
     * - choice: AssignedVTBlocks | AutoAssignedVTBlock | ClosedPeriods | Communities | ServiceProvider | ServiceProviders | Settlements | VTCategories | VTCountries | VTInventories | VTPrice
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceProviderVTBlocksType
     */
    public $AssignedVTBlocks;
    /**
     * The AutoAssignedVTBlock
     * Meta information extracted from the WSDL
     * - choice: AssignedVTBlocks | AutoAssignedVTBlock | ClosedPeriods | Communities | ServiceProvider | ServiceProviders | Settlements | VTCategories | VTCountries | VTInventories | VTPrice
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AutoAssignedVTBlockType
     */
    public $AutoAssignedVTBlock;
    /**
     * The ClosedPeriods
     * Meta information extracted from the WSDL
     * - choice: AssignedVTBlocks | AutoAssignedVTBlock | ClosedPeriods | Communities | ServiceProvider | ServiceProviders | Settlements | VTCategories | VTCountries | VTInventories | VTPrice
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ClosedPeriodsType
     */
    public $ClosedPeriods;
    /**
     * The Communities
     * Meta information extracted from the WSDL
     * - choice: AssignedVTBlocks | AutoAssignedVTBlock | ClosedPeriods | Communities | ServiceProvider | ServiceProviders | Settlements | VTCategories | VTCountries | VTInventories | VTPrice
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CommunityList
     */
    public $Communities;
    /**
     * The ServiceProvider
     * Meta information extracted from the WSDL
     * - choice: AssignedVTBlocks | AutoAssignedVTBlock | ClosedPeriods | Communities | ServiceProvider | ServiceProviders | Settlements | VTCategories | VTCountries | VTInventories | VTPrice
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceProviderType
     */
    public $ServiceProvider;
    /**
     * The ServiceProviders
     * Meta information extracted from the WSDL
     * - choice: AssignedVTBlocks | AutoAssignedVTBlock | ClosedPeriods | Communities | ServiceProvider | ServiceProviders | Settlements | VTCategories | VTCountries | VTInventories | VTPrice
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VTServiceProviderList
     */
    public $ServiceProviders;
    /**
     * The Settlements
     * Meta information extracted from the WSDL
     * - choice: AssignedVTBlocks | AutoAssignedVTBlock | ClosedPeriods | Communities | ServiceProvider | ServiceProviders | Settlements | VTCategories | VTCountries | VTInventories | VTPrice
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SettlementSPList
     */
    public $Settlements;
    /**
     * The VTCategories
     * Meta information extracted from the WSDL
     * - choice: AssignedVTBlocks | AutoAssignedVTBlock | ClosedPeriods | Communities | ServiceProvider | ServiceProviders | Settlements | VTCategories | VTCountries | VTInventories | VTPrice
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VTCategoryList
     */
    public $VTCategories;
    /**
     * The VTCountries
     * Meta information extracted from the WSDL
     * - choice: AssignedVTBlocks | AutoAssignedVTBlock | ClosedPeriods | Communities | ServiceProvider | ServiceProviders | Settlements | VTCategories | VTCountries | VTInventories | VTPrice
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VTCountryList
     */
    public $VTCountries;
    /**
     * The VTInventories
     * Meta information extracted from the WSDL
     * - choice: AssignedVTBlocks | AutoAssignedVTBlock | ClosedPeriods | Communities | ServiceProvider | ServiceProviders | Settlements | VTCategories | VTCountries | VTInventories | VTPrice
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VTInventoryList
     */
    public $VTInventories;
    /**
     * The VTPrice
     * Meta information extracted from the WSDL
     * - choice: AssignedVTBlocks | AutoAssignedVTBlock | ClosedPeriods | Communities | ServiceProvider | ServiceProviders | Settlements | VTCategories | VTCountries | VTInventories | VTPrice
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\VTPriceType
     */
    public $VTPrice;
    /**
     * Constructor method for ResponseType
     * @uses ResponseType::setAssignedVTBlocks()
     * @uses ResponseType::setAutoAssignedVTBlock()
     * @uses ResponseType::setClosedPeriods()
     * @uses ResponseType::setCommunities()
     * @uses ResponseType::setServiceProvider()
     * @uses ResponseType::setServiceProviders()
     * @uses ResponseType::setSettlements()
     * @uses ResponseType::setVTCategories()
     * @uses ResponseType::setVTCountries()
     * @uses ResponseType::setVTInventories()
     * @uses ResponseType::setVTPrice()
     * @param \StructType\ServiceProviderVTBlocksType $assignedVTBlocks
     * @param \StructType\AutoAssignedVTBlockType $autoAssignedVTBlock
     * @param \StructType\ClosedPeriodsType $closedPeriods
     * @param \StructType\CommunityList $communities
     * @param \StructType\ServiceProviderType $serviceProvider
     * @param \StructType\VTServiceProviderList $serviceProviders
     * @param \StructType\SettlementSPList $settlements
     * @param \StructType\VTCategoryList $vTCategories
     * @param \StructType\VTCountryList $vTCountries
     * @param \StructType\VTInventoryList $vTInventories
     * @param \StructType\VTPriceType $vTPrice
     */
    public function __construct(\StructType\ServiceProviderVTBlocksType $assignedVTBlocks = null, \StructType\AutoAssignedVTBlockType $autoAssignedVTBlock = null, \StructType\ClosedPeriodsType $closedPeriods = null, \StructType\CommunityList $communities = null, \StructType\ServiceProviderType $serviceProvider = null, \StructType\VTServiceProviderList $serviceProviders = null, \StructType\SettlementSPList $settlements = null, \StructType\VTCategoryList $vTCategories = null, \StructType\VTCountryList $vTCountries = null, \StructType\VTInventoryList $vTInventories = null, \StructType\VTPriceType $vTPrice = null)
    {
        $this
            ->setAssignedVTBlocks($assignedVTBlocks)
            ->setAutoAssignedVTBlock($autoAssignedVTBlock)
            ->setClosedPeriods($closedPeriods)
            ->setCommunities($communities)
            ->setServiceProvider($serviceProvider)
            ->setServiceProviders($serviceProviders)
            ->setSettlements($settlements)
            ->setVTCategories($vTCategories)
            ->setVTCountries($vTCountries)
            ->setVTInventories($vTInventories)
            ->setVTPrice($vTPrice);
    }
    /**
     * Get AssignedVTBlocks value
     * @return \StructType\ServiceProviderVTBlocksType|null
     */
    public function getAssignedVTBlocks()
    {
        return isset($this->AssignedVTBlocks) ? $this->AssignedVTBlocks : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAssignedVTBlocks method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAssignedVTBlocks method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAssignedVTBlocksForChoiceConstraintsFromSetAssignedVTBlocks($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AutoAssignedVTBlock',
            'ClosedPeriods',
            'Communities',
            'ServiceProvider',
            'ServiceProviders',
            'Settlements',
            'VTCategories',
            'VTCountries',
            'VTInventories',
            'VTPrice',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AssignedVTBlocks can\'t be set as the property %s is already set. Only one property must be set among these properties: AssignedVTBlocks, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AssignedVTBlocks value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceProviderVTBlocksType $assignedVTBlocks
     * @return \StructType\ResponseType
     */
    public function setAssignedVTBlocks(\StructType\ServiceProviderVTBlocksType $assignedVTBlocks = null)
    {
        // validation for constraint: choice(AssignedVTBlocks, AutoAssignedVTBlock, ClosedPeriods, Communities, ServiceProvider, ServiceProviders, Settlements, VTCategories, VTCountries, VTInventories, VTPrice)
        if ('' !== ($assignedVTBlocksChoiceErrorMessage = self::validateAssignedVTBlocksForChoiceConstraintsFromSetAssignedVTBlocks($assignedVTBlocks))) {
            throw new \InvalidArgumentException($assignedVTBlocksChoiceErrorMessage, __LINE__);
        }
        if (is_null($assignedVTBlocks) || (is_array($assignedVTBlocks) && empty($assignedVTBlocks))) {
            unset($this->AssignedVTBlocks);
        } else {
            $this->AssignedVTBlocks = $assignedVTBlocks;
        }
        return $this;
    }
    /**
     * Get AutoAssignedVTBlock value
     * @return \StructType\AutoAssignedVTBlockType|null
     */
    public function getAutoAssignedVTBlock()
    {
        return isset($this->AutoAssignedVTBlock) ? $this->AutoAssignedVTBlock : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAutoAssignedVTBlock method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAutoAssignedVTBlock method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAutoAssignedVTBlockForChoiceConstraintsFromSetAutoAssignedVTBlock($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AssignedVTBlocks',
            'ClosedPeriods',
            'Communities',
            'ServiceProvider',
            'ServiceProviders',
            'Settlements',
            'VTCategories',
            'VTCountries',
            'VTInventories',
            'VTPrice',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property AutoAssignedVTBlock can\'t be set as the property %s is already set. Only one property must be set among these properties: AutoAssignedVTBlock, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set AutoAssignedVTBlock value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AutoAssignedVTBlockType $autoAssignedVTBlock
     * @return \StructType\ResponseType
     */
    public function setAutoAssignedVTBlock(\StructType\AutoAssignedVTBlockType $autoAssignedVTBlock = null)
    {
        // validation for constraint: choice(AssignedVTBlocks, AutoAssignedVTBlock, ClosedPeriods, Communities, ServiceProvider, ServiceProviders, Settlements, VTCategories, VTCountries, VTInventories, VTPrice)
        if ('' !== ($autoAssignedVTBlockChoiceErrorMessage = self::validateAutoAssignedVTBlockForChoiceConstraintsFromSetAutoAssignedVTBlock($autoAssignedVTBlock))) {
            throw new \InvalidArgumentException($autoAssignedVTBlockChoiceErrorMessage, __LINE__);
        }
        if (is_null($autoAssignedVTBlock) || (is_array($autoAssignedVTBlock) && empty($autoAssignedVTBlock))) {
            unset($this->AutoAssignedVTBlock);
        } else {
            $this->AutoAssignedVTBlock = $autoAssignedVTBlock;
        }
        return $this;
    }
    /**
     * Get ClosedPeriods value
     * @return \StructType\ClosedPeriodsType|null
     */
    public function getClosedPeriods()
    {
        return isset($this->ClosedPeriods) ? $this->ClosedPeriods : null;
    }
    /**
     * This method is responsible for validating the value passed to the setClosedPeriods method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClosedPeriods method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateClosedPeriodsForChoiceConstraintsFromSetClosedPeriods($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AssignedVTBlocks',
            'AutoAssignedVTBlock',
            'Communities',
            'ServiceProvider',
            'ServiceProviders',
            'Settlements',
            'VTCategories',
            'VTCountries',
            'VTInventories',
            'VTPrice',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ClosedPeriods can\'t be set as the property %s is already set. Only one property must be set among these properties: ClosedPeriods, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ClosedPeriods value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ClosedPeriodsType $closedPeriods
     * @return \StructType\ResponseType
     */
    public function setClosedPeriods(\StructType\ClosedPeriodsType $closedPeriods = null)
    {
        // validation for constraint: choice(AssignedVTBlocks, AutoAssignedVTBlock, ClosedPeriods, Communities, ServiceProvider, ServiceProviders, Settlements, VTCategories, VTCountries, VTInventories, VTPrice)
        if ('' !== ($closedPeriodsChoiceErrorMessage = self::validateClosedPeriodsForChoiceConstraintsFromSetClosedPeriods($closedPeriods))) {
            throw new \InvalidArgumentException($closedPeriodsChoiceErrorMessage, __LINE__);
        }
        if (is_null($closedPeriods) || (is_array($closedPeriods) && empty($closedPeriods))) {
            unset($this->ClosedPeriods);
        } else {
            $this->ClosedPeriods = $closedPeriods;
        }
        return $this;
    }
    /**
     * Get Communities value
     * @return \StructType\CommunityList|null
     */
    public function getCommunities()
    {
        return isset($this->Communities) ? $this->Communities : null;
    }
    /**
     * This method is responsible for validating the value passed to the setCommunities method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommunities method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateCommunitiesForChoiceConstraintsFromSetCommunities($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AssignedVTBlocks',
            'AutoAssignedVTBlock',
            'ClosedPeriods',
            'ServiceProvider',
            'ServiceProviders',
            'Settlements',
            'VTCategories',
            'VTCountries',
            'VTInventories',
            'VTPrice',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Communities can\'t be set as the property %s is already set. Only one property must be set among these properties: Communities, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Communities value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CommunityList $communities
     * @return \StructType\ResponseType
     */
    public function setCommunities(\StructType\CommunityList $communities = null)
    {
        // validation for constraint: choice(AssignedVTBlocks, AutoAssignedVTBlock, ClosedPeriods, Communities, ServiceProvider, ServiceProviders, Settlements, VTCategories, VTCountries, VTInventories, VTPrice)
        if ('' !== ($communitiesChoiceErrorMessage = self::validateCommunitiesForChoiceConstraintsFromSetCommunities($communities))) {
            throw new \InvalidArgumentException($communitiesChoiceErrorMessage, __LINE__);
        }
        if (is_null($communities) || (is_array($communities) && empty($communities))) {
            unset($this->Communities);
        } else {
            $this->Communities = $communities;
        }
        return $this;
    }
    /**
     * Get ServiceProvider value
     * @return \StructType\ServiceProviderType|null
     */
    public function getServiceProvider()
    {
        return isset($this->ServiceProvider) ? $this->ServiceProvider : null;
    }
    /**
     * This method is responsible for validating the value passed to the setServiceProvider method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceProvider method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServiceProviderForChoiceConstraintsFromSetServiceProvider($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AssignedVTBlocks',
            'AutoAssignedVTBlock',
            'ClosedPeriods',
            'Communities',
            'ServiceProviders',
            'Settlements',
            'VTCategories',
            'VTCountries',
            'VTInventories',
            'VTPrice',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ServiceProvider can\'t be set as the property %s is already set. Only one property must be set among these properties: ServiceProvider, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ServiceProvider value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceProviderType $serviceProvider
     * @return \StructType\ResponseType
     */
    public function setServiceProvider(\StructType\ServiceProviderType $serviceProvider = null)
    {
        // validation for constraint: choice(AssignedVTBlocks, AutoAssignedVTBlock, ClosedPeriods, Communities, ServiceProvider, ServiceProviders, Settlements, VTCategories, VTCountries, VTInventories, VTPrice)
        if ('' !== ($serviceProviderChoiceErrorMessage = self::validateServiceProviderForChoiceConstraintsFromSetServiceProvider($serviceProvider))) {
            throw new \InvalidArgumentException($serviceProviderChoiceErrorMessage, __LINE__);
        }
        if (is_null($serviceProvider) || (is_array($serviceProvider) && empty($serviceProvider))) {
            unset($this->ServiceProvider);
        } else {
            $this->ServiceProvider = $serviceProvider;
        }
        return $this;
    }
    /**
     * Get ServiceProviders value
     * @return \StructType\VTServiceProviderList|null
     */
    public function getServiceProviders()
    {
        return isset($this->ServiceProviders) ? $this->ServiceProviders : null;
    }
    /**
     * This method is responsible for validating the value passed to the setServiceProviders method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceProviders method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateServiceProvidersForChoiceConstraintsFromSetServiceProviders($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AssignedVTBlocks',
            'AutoAssignedVTBlock',
            'ClosedPeriods',
            'Communities',
            'ServiceProvider',
            'Settlements',
            'VTCategories',
            'VTCountries',
            'VTInventories',
            'VTPrice',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property ServiceProviders can\'t be set as the property %s is already set. Only one property must be set among these properties: ServiceProviders, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set ServiceProviders value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VTServiceProviderList $serviceProviders
     * @return \StructType\ResponseType
     */
    public function setServiceProviders(\StructType\VTServiceProviderList $serviceProviders = null)
    {
        // validation for constraint: choice(AssignedVTBlocks, AutoAssignedVTBlock, ClosedPeriods, Communities, ServiceProvider, ServiceProviders, Settlements, VTCategories, VTCountries, VTInventories, VTPrice)
        if ('' !== ($serviceProvidersChoiceErrorMessage = self::validateServiceProvidersForChoiceConstraintsFromSetServiceProviders($serviceProviders))) {
            throw new \InvalidArgumentException($serviceProvidersChoiceErrorMessage, __LINE__);
        }
        if (is_null($serviceProviders) || (is_array($serviceProviders) && empty($serviceProviders))) {
            unset($this->ServiceProviders);
        } else {
            $this->ServiceProviders = $serviceProviders;
        }
        return $this;
    }
    /**
     * Get Settlements value
     * @return \StructType\SettlementSPList|null
     */
    public function getSettlements()
    {
        return isset($this->Settlements) ? $this->Settlements : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSettlements method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSettlements method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSettlementsForChoiceConstraintsFromSetSettlements($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AssignedVTBlocks',
            'AutoAssignedVTBlock',
            'ClosedPeriods',
            'Communities',
            'ServiceProvider',
            'ServiceProviders',
            'VTCategories',
            'VTCountries',
            'VTInventories',
            'VTPrice',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Settlements can\'t be set as the property %s is already set. Only one property must be set among these properties: Settlements, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Settlements value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SettlementSPList $settlements
     * @return \StructType\ResponseType
     */
    public function setSettlements(\StructType\SettlementSPList $settlements = null)
    {
        // validation for constraint: choice(AssignedVTBlocks, AutoAssignedVTBlock, ClosedPeriods, Communities, ServiceProvider, ServiceProviders, Settlements, VTCategories, VTCountries, VTInventories, VTPrice)
        if ('' !== ($settlementsChoiceErrorMessage = self::validateSettlementsForChoiceConstraintsFromSetSettlements($settlements))) {
            throw new \InvalidArgumentException($settlementsChoiceErrorMessage, __LINE__);
        }
        if (is_null($settlements) || (is_array($settlements) && empty($settlements))) {
            unset($this->Settlements);
        } else {
            $this->Settlements = $settlements;
        }
        return $this;
    }
    /**
     * Get VTCategories value
     * @return \StructType\VTCategoryList|null
     */
    public function getVTCategories()
    {
        return isset($this->VTCategories) ? $this->VTCategories : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVTCategories method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVTCategories method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVTCategoriesForChoiceConstraintsFromSetVTCategories($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AssignedVTBlocks',
            'AutoAssignedVTBlock',
            'ClosedPeriods',
            'Communities',
            'ServiceProvider',
            'ServiceProviders',
            'Settlements',
            'VTCountries',
            'VTInventories',
            'VTPrice',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VTCategories can\'t be set as the property %s is already set. Only one property must be set among these properties: VTCategories, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VTCategories value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VTCategoryList $vTCategories
     * @return \StructType\ResponseType
     */
    public function setVTCategories(\StructType\VTCategoryList $vTCategories = null)
    {
        // validation for constraint: choice(AssignedVTBlocks, AutoAssignedVTBlock, ClosedPeriods, Communities, ServiceProvider, ServiceProviders, Settlements, VTCategories, VTCountries, VTInventories, VTPrice)
        if ('' !== ($vTCategoriesChoiceErrorMessage = self::validateVTCategoriesForChoiceConstraintsFromSetVTCategories($vTCategories))) {
            throw new \InvalidArgumentException($vTCategoriesChoiceErrorMessage, __LINE__);
        }
        if (is_null($vTCategories) || (is_array($vTCategories) && empty($vTCategories))) {
            unset($this->VTCategories);
        } else {
            $this->VTCategories = $vTCategories;
        }
        return $this;
    }
    /**
     * Get VTCountries value
     * @return \StructType\VTCountryList|null
     */
    public function getVTCountries()
    {
        return isset($this->VTCountries) ? $this->VTCountries : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVTCountries method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVTCountries method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVTCountriesForChoiceConstraintsFromSetVTCountries($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AssignedVTBlocks',
            'AutoAssignedVTBlock',
            'ClosedPeriods',
            'Communities',
            'ServiceProvider',
            'ServiceProviders',
            'Settlements',
            'VTCategories',
            'VTInventories',
            'VTPrice',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VTCountries can\'t be set as the property %s is already set. Only one property must be set among these properties: VTCountries, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VTCountries value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VTCountryList $vTCountries
     * @return \StructType\ResponseType
     */
    public function setVTCountries(\StructType\VTCountryList $vTCountries = null)
    {
        // validation for constraint: choice(AssignedVTBlocks, AutoAssignedVTBlock, ClosedPeriods, Communities, ServiceProvider, ServiceProviders, Settlements, VTCategories, VTCountries, VTInventories, VTPrice)
        if ('' !== ($vTCountriesChoiceErrorMessage = self::validateVTCountriesForChoiceConstraintsFromSetVTCountries($vTCountries))) {
            throw new \InvalidArgumentException($vTCountriesChoiceErrorMessage, __LINE__);
        }
        if (is_null($vTCountries) || (is_array($vTCountries) && empty($vTCountries))) {
            unset($this->VTCountries);
        } else {
            $this->VTCountries = $vTCountries;
        }
        return $this;
    }
    /**
     * Get VTInventories value
     * @return \StructType\VTInventoryList|null
     */
    public function getVTInventories()
    {
        return isset($this->VTInventories) ? $this->VTInventories : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVTInventories method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVTInventories method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVTInventoriesForChoiceConstraintsFromSetVTInventories($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AssignedVTBlocks',
            'AutoAssignedVTBlock',
            'ClosedPeriods',
            'Communities',
            'ServiceProvider',
            'ServiceProviders',
            'Settlements',
            'VTCategories',
            'VTCountries',
            'VTPrice',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VTInventories can\'t be set as the property %s is already set. Only one property must be set among these properties: VTInventories, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VTInventories value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VTInventoryList $vTInventories
     * @return \StructType\ResponseType
     */
    public function setVTInventories(\StructType\VTInventoryList $vTInventories = null)
    {
        // validation for constraint: choice(AssignedVTBlocks, AutoAssignedVTBlock, ClosedPeriods, Communities, ServiceProvider, ServiceProviders, Settlements, VTCategories, VTCountries, VTInventories, VTPrice)
        if ('' !== ($vTInventoriesChoiceErrorMessage = self::validateVTInventoriesForChoiceConstraintsFromSetVTInventories($vTInventories))) {
            throw new \InvalidArgumentException($vTInventoriesChoiceErrorMessage, __LINE__);
        }
        if (is_null($vTInventories) || (is_array($vTInventories) && empty($vTInventories))) {
            unset($this->VTInventories);
        } else {
            $this->VTInventories = $vTInventories;
        }
        return $this;
    }
    /**
     * Get VTPrice value
     * @return \StructType\VTPriceType|null
     */
    public function getVTPrice()
    {
        return isset($this->VTPrice) ? $this->VTPrice : null;
    }
    /**
     * This method is responsible for validating the value passed to the setVTPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVTPrice method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateVTPriceForChoiceConstraintsFromSetVTPrice($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'AssignedVTBlocks',
            'AutoAssignedVTBlock',
            'ClosedPeriods',
            'Communities',
            'ServiceProvider',
            'ServiceProviders',
            'Settlements',
            'VTCategories',
            'VTCountries',
            'VTInventories',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property VTPrice can\'t be set as the property %s is already set. Only one property must be set among these properties: VTPrice, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set VTPrice value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\VTPriceType $vTPrice
     * @return \StructType\ResponseType
     */
    public function setVTPrice(\StructType\VTPriceType $vTPrice = null)
    {
        // validation for constraint: choice(AssignedVTBlocks, AutoAssignedVTBlock, ClosedPeriods, Communities, ServiceProvider, ServiceProviders, Settlements, VTCategories, VTCountries, VTInventories, VTPrice)
        if ('' !== ($vTPriceChoiceErrorMessage = self::validateVTPriceForChoiceConstraintsFromSetVTPrice($vTPrice))) {
            throw new \InvalidArgumentException($vTPriceChoiceErrorMessage, __LINE__);
        }
        if (is_null($vTPrice) || (is_array($vTPrice) && empty($vTPrice))) {
            unset($this->VTPrice);
        } else {
            $this->VTPrice = $vTPrice;
        }
        return $this;
    }
}
