<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonGroupType StructType
 * @subpackage Structs
 */
class PersonGroupType extends AbstractStructBase
{
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The AgeFrom
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $AgeFrom;
    /**
     * The AgeTo
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $AgeTo;
    /**
     * The ValidFrom
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ValidFrom;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for PersonGroupType
     * @uses PersonGroupType::setType()
     * @uses PersonGroupType::setAgeFrom()
     * @uses PersonGroupType::setAgeTo()
     * @uses PersonGroupType::setValidFrom()
     * @uses PersonGroupType::setID()
     * @uses PersonGroupType::setName()
     * @uses PersonGroupType::setCode()
     * @param string $type
     * @param int $ageFrom
     * @param int $ageTo
     * @param string $validFrom
     * @param string $iD
     * @param string $name
     * @param string $code
     */
    public function __construct($type = null, $ageFrom = null, $ageTo = null, $validFrom = null, $iD = null, $name = null, $code = null)
    {
        $this
            ->setType($type)
            ->setAgeFrom($ageFrom)
            ->setAgeTo($ageTo)
            ->setValidFrom($validFrom)
            ->setID($iD)
            ->setName($name)
            ->setCode($code);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\PersonGroupTypeEnum::valueIsValid()
     * @uses \EnumType\PersonGroupTypeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\PersonGroupType
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PersonGroupTypeEnum::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PersonGroupTypeEnum', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\PersonGroupTypeEnum::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get AgeFrom value
     * @return int
     */
    public function getAgeFrom()
    {
        return $this->AgeFrom;
    }
    /**
     * Set AgeFrom value
     * @param int $ageFrom
     * @return \StructType\PersonGroupType
     */
    public function setAgeFrom($ageFrom = null)
    {
        // validation for constraint: int
        if (!is_null($ageFrom) && !(is_int($ageFrom) || ctype_digit($ageFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ageFrom, true), gettype($ageFrom)), __LINE__);
        }
        $this->AgeFrom = $ageFrom;
        return $this;
    }
    /**
     * Get AgeTo value
     * @return int
     */
    public function getAgeTo()
    {
        return $this->AgeTo;
    }
    /**
     * Set AgeTo value
     * @param int $ageTo
     * @return \StructType\PersonGroupType
     */
    public function setAgeTo($ageTo = null)
    {
        // validation for constraint: int
        if (!is_null($ageTo) && !(is_int($ageTo) || ctype_digit($ageTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ageTo, true), gettype($ageTo)), __LINE__);
        }
        $this->AgeTo = $ageTo;
        return $this;
    }
    /**
     * Get ValidFrom value
     * @return string
     */
    public function getValidFrom()
    {
        return $this->ValidFrom;
    }
    /**
     * Set ValidFrom value
     * @param string $validFrom
     * @return \StructType\PersonGroupType
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        $this->ValidFrom = $validFrom;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\PersonGroupType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\PersonGroupType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\PersonGroupType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
}
