<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PMSAutoAssignVTBlock StructType
 * @subpackage Structs
 */
class PMSAutoAssignVTBlock extends AbstractStructBase
{
    /**
     * The oestat
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $oestat;
    /**
     * The companyCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $companyCode;
    /**
     * The betriebnr
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $betriebnr;
    /**
     * Constructor method for PMSAutoAssignVTBlock
     * @uses PMSAutoAssignVTBlock::setOestat()
     * @uses PMSAutoAssignVTBlock::setCompanyCode()
     * @uses PMSAutoAssignVTBlock::setBetriebnr()
     * @param int $oestat
     * @param string $companyCode
     * @param string $betriebnr
     */
    public function __construct($oestat = null, $companyCode = null, $betriebnr = null)
    {
        $this
            ->setOestat($oestat)
            ->setCompanyCode($companyCode)
            ->setBetriebnr($betriebnr);
    }
    /**
     * Get oestat value
     * @return int
     */
    public function getOestat()
    {
        return $this->oestat;
    }
    /**
     * Set oestat value
     * @param int $oestat
     * @return \StructType\PMSAutoAssignVTBlock
     */
    public function setOestat($oestat = null)
    {
        // validation for constraint: int
        if (!is_null($oestat) && !(is_int($oestat) || ctype_digit($oestat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oestat, true), gettype($oestat)), __LINE__);
        }
        $this->oestat = $oestat;
        return $this;
    }
    /**
     * Get companyCode value
     * @return string|null
     */
    public function getCompanyCode()
    {
        return $this->companyCode;
    }
    /**
     * Set companyCode value
     * @param string $companyCode
     * @return \StructType\PMSAutoAssignVTBlock
     */
    public function setCompanyCode($companyCode = null)
    {
        // validation for constraint: string
        if (!is_null($companyCode) && !is_string($companyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCode, true), gettype($companyCode)), __LINE__);
        }
        $this->companyCode = $companyCode;
        return $this;
    }
    /**
     * Get betriebnr value
     * @return string|null
     */
    public function getBetriebnr()
    {
        return $this->betriebnr;
    }
    /**
     * Set betriebnr value
     * @param string $betriebnr
     * @return \StructType\PMSAutoAssignVTBlock
     */
    public function setBetriebnr($betriebnr = null)
    {
        // validation for constraint: string
        if (!is_null($betriebnr) && !is_string($betriebnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($betriebnr, true), gettype($betriebnr)), __LINE__);
        }
        $this->betriebnr = $betriebnr;
        return $this;
    }
}
