<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommunityList StructType
 * @subpackage Structs
 */
class CommunityList extends AbstractStructBase
{
    /**
     * The Community
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CommunityType[]
     */
    public $Community;
    /**
     * The Dummy
     * @var string
     */
    public $Dummy;
    /**
     * Constructor method for CommunityList
     * @uses CommunityList::setCommunity()
     * @uses CommunityList::setDummy()
     * @param \StructType\CommunityType[] $community
     * @param string $dummy
     */
    public function __construct(array $community = array(), $dummy = null)
    {
        $this
            ->setCommunity($community)
            ->setDummy($dummy);
    }
    /**
     * Get Community value
     * @return \StructType\CommunityType[]|null
     */
    public function getCommunity()
    {
        return $this->Community;
    }
    /**
     * This method is responsible for validating the values passed to the setCommunity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommunity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommunityForArrayConstraintsFromSetCommunity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $communityListCommunityItem) {
            // validation for constraint: itemType
            if (!$communityListCommunityItem instanceof \StructType\CommunityType) {
                $invalidValues[] = is_object($communityListCommunityItem) ? get_class($communityListCommunityItem) : sprintf('%s(%s)', gettype($communityListCommunityItem), var_export($communityListCommunityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Community property can only contain items of type \StructType\CommunityType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Community value
     * @throws \InvalidArgumentException
     * @param \StructType\CommunityType[] $community
     * @return \StructType\CommunityList
     */
    public function setCommunity(array $community = array())
    {
        // validation for constraint: array
        if ('' !== ($communityArrayErrorMessage = self::validateCommunityForArrayConstraintsFromSetCommunity($community))) {
            throw new \InvalidArgumentException($communityArrayErrorMessage, __LINE__);
        }
        $this->Community = $community;
        return $this;
    }
    /**
     * Add item to Community value
     * @throws \InvalidArgumentException
     * @param \StructType\CommunityType $item
     * @return \StructType\CommunityList
     */
    public function addToCommunity(\StructType\CommunityType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CommunityType) {
            throw new \InvalidArgumentException(sprintf('The Community property can only contain items of type \StructType\CommunityType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Community[] = $item;
        return $this;
    }
    /**
     * Get Dummy value
     * @return string|null
     */
    public function getDummy()
    {
        return $this->Dummy;
    }
    /**
     * Set Dummy value
     * @param string $dummy
     * @return \StructType\CommunityList
     */
    public function setDummy($dummy = null)
    {
        // validation for constraint: string
        if (!is_null($dummy) && !is_string($dummy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dummy, true), gettype($dummy)), __LINE__);
        }
        $this->Dummy = $dummy;
        return $this;
    }
}
