<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClosedPeriodsType StructType
 * @subpackage Structs
 */
class ClosedPeriodsType extends AbstractStructBase
{
    /**
     * The ClosedPeriod
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ClosedPeriodType[]
     */
    public $ClosedPeriod;
    /**
     * The ServiceProviderID
     * @var string
     */
    public $ServiceProviderID;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for ClosedPeriodsType
     * @uses ClosedPeriodsType::setClosedPeriod()
     * @uses ClosedPeriodsType::setServiceProviderID()
     * @uses ClosedPeriodsType::setName()
     * @uses ClosedPeriodsType::setCode()
     * @param \StructType\ClosedPeriodType[] $closedPeriod
     * @param string $serviceProviderID
     * @param string $name
     * @param string $code
     */
    public function __construct(array $closedPeriod = array(), $serviceProviderID = null, $name = null, $code = null)
    {
        $this
            ->setClosedPeriod($closedPeriod)
            ->setServiceProviderID($serviceProviderID)
            ->setName($name)
            ->setCode($code);
    }
    /**
     * Get ClosedPeriod value
     * @return \StructType\ClosedPeriodType[]|null
     */
    public function getClosedPeriod()
    {
        return $this->ClosedPeriod;
    }
    /**
     * This method is responsible for validating the values passed to the setClosedPeriod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClosedPeriod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClosedPeriodForArrayConstraintsFromSetClosedPeriod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $closedPeriodsTypeClosedPeriodItem) {
            // validation for constraint: itemType
            if (!$closedPeriodsTypeClosedPeriodItem instanceof \StructType\ClosedPeriodType) {
                $invalidValues[] = is_object($closedPeriodsTypeClosedPeriodItem) ? get_class($closedPeriodsTypeClosedPeriodItem) : sprintf('%s(%s)', gettype($closedPeriodsTypeClosedPeriodItem), var_export($closedPeriodsTypeClosedPeriodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ClosedPeriod property can only contain items of type \StructType\ClosedPeriodType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ClosedPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\ClosedPeriodType[] $closedPeriod
     * @return \StructType\ClosedPeriodsType
     */
    public function setClosedPeriod(array $closedPeriod = array())
    {
        // validation for constraint: array
        if ('' !== ($closedPeriodArrayErrorMessage = self::validateClosedPeriodForArrayConstraintsFromSetClosedPeriod($closedPeriod))) {
            throw new \InvalidArgumentException($closedPeriodArrayErrorMessage, __LINE__);
        }
        $this->ClosedPeriod = $closedPeriod;
        return $this;
    }
    /**
     * Add item to ClosedPeriod value
     * @throws \InvalidArgumentException
     * @param \StructType\ClosedPeriodType $item
     * @return \StructType\ClosedPeriodsType
     */
    public function addToClosedPeriod(\StructType\ClosedPeriodType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ClosedPeriodType) {
            throw new \InvalidArgumentException(sprintf('The ClosedPeriod property can only contain items of type \StructType\ClosedPeriodType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ClosedPeriod[] = $item;
        return $this;
    }
    /**
     * Get ServiceProviderID value
     * @return string|null
     */
    public function getServiceProviderID()
    {
        return $this->ServiceProviderID;
    }
    /**
     * Set ServiceProviderID value
     * @param string $serviceProviderID
     * @return \StructType\ClosedPeriodsType
     */
    public function setServiceProviderID($serviceProviderID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderID) && !is_string($serviceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceProviderID, true), gettype($serviceProviderID)), __LINE__);
        }
        $this->ServiceProviderID = $serviceProviderID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\ClosedPeriodsType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ClosedPeriodsType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
}
