<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for betrieb StructType
 * @subpackage Structs
 */
class Betrieb extends AbstractStructBase
{
    /**
     * The meldeblatt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Meldeblatt[]
     */
    public $meldeblatt;
    /**
     * The nummernblocklist
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfGemeindeBetriebNummernblock
     */
    public $nummernblocklist;
    /**
     * The gastartlist
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Gastartlist
     */
    public $gastartlist;
    /**
     * The card
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Card[]
     */
    public $card;
    /**
     * The webclient
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Webclient
     */
    public $webclient;
    /**
     * The precheckin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Precheckin
     */
    public $precheckin;
    /**
     * The selfcheckin
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Selfcheckin
     */
    public $selfcheckin;
    /**
     * The betriebnr
     * @var string
     */
    public $betriebnr;
    /**
     * The betriebnr_alpha
     * @var string
     */
    public $betriebnr_alpha;
    /**
     * The uvmnr
     * @var int
     */
    public $uvmnr;
    /**
     * The feratelext_objectcode
     * @var string
     */
    public $feratelext_objectcode;
    /**
     * The oestat_norm
     * @var string
     */
    public $oestat_norm;
    /**
     * The feratelext_id
     * @var string
     */
    public $feratelext_id;
    /**
     * The mcnummer
     * @var int
     */
    public $mcnummer;
    /**
     * The voranmeldung
     * @var int
     */
    public $voranmeldung;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The ort
     * @var string
     */
    public $ort;
    /**
     * The plz
     * @var string
     */
    public $plz;
    /**
     * The strasse
     * @var string
     */
    public $strasse;
    /**
     * Constructor method for betrieb
     * @uses Betrieb::setMeldeblatt()
     * @uses Betrieb::setNummernblocklist()
     * @uses Betrieb::setGastartlist()
     * @uses Betrieb::setCard()
     * @uses Betrieb::setWebclient()
     * @uses Betrieb::setPrecheckin()
     * @uses Betrieb::setSelfcheckin()
     * @uses Betrieb::setBetriebnr()
     * @uses Betrieb::setBetriebnr_alpha()
     * @uses Betrieb::setUvmnr()
     * @uses Betrieb::setFeratelext_objectcode()
     * @uses Betrieb::setOestat_norm()
     * @uses Betrieb::setFeratelext_id()
     * @uses Betrieb::setMcnummer()
     * @uses Betrieb::setVoranmeldung()
     * @uses Betrieb::setName()
     * @uses Betrieb::setOrt()
     * @uses Betrieb::setPlz()
     * @uses Betrieb::setStrasse()
     * @param \StructType\Meldeblatt[] $meldeblatt
     * @param \ArrayType\ArrayOfGemeindeBetriebNummernblock $nummernblocklist
     * @param \StructType\Gastartlist $gastartlist
     * @param \StructType\Card[] $card
     * @param \StructType\Webclient $webclient
     * @param \StructType\Precheckin $precheckin
     * @param \StructType\Selfcheckin $selfcheckin
     * @param string $betriebnr
     * @param string $betriebnr_alpha
     * @param int $uvmnr
     * @param string $feratelext_objectcode
     * @param string $oestat_norm
     * @param string $feratelext_id
     * @param int $mcnummer
     * @param int $voranmeldung
     * @param string $name
     * @param string $ort
     * @param string $plz
     * @param string $strasse
     */
    public function __construct(array $meldeblatt = array(), \ArrayType\ArrayOfGemeindeBetriebNummernblock $nummernblocklist = null, \StructType\Gastartlist $gastartlist = null, array $card = array(), \StructType\Webclient $webclient = null, \StructType\Precheckin $precheckin = null, \StructType\Selfcheckin $selfcheckin = null, $betriebnr = null, $betriebnr_alpha = null, $uvmnr = null, $feratelext_objectcode = null, $oestat_norm = null, $feratelext_id = null, $mcnummer = null, $voranmeldung = null, $name = null, $ort = null, $plz = null, $strasse = null)
    {
        $this
            ->setMeldeblatt($meldeblatt)
            ->setNummernblocklist($nummernblocklist)
            ->setGastartlist($gastartlist)
            ->setCard($card)
            ->setWebclient($webclient)
            ->setPrecheckin($precheckin)
            ->setSelfcheckin($selfcheckin)
            ->setBetriebnr($betriebnr)
            ->setBetriebnr_alpha($betriebnr_alpha)
            ->setUvmnr($uvmnr)
            ->setFeratelext_objectcode($feratelext_objectcode)
            ->setOestat_norm($oestat_norm)
            ->setFeratelext_id($feratelext_id)
            ->setMcnummer($mcnummer)
            ->setVoranmeldung($voranmeldung)
            ->setName($name)
            ->setOrt($ort)
            ->setPlz($plz)
            ->setStrasse($strasse);
    }
    /**
     * Get meldeblatt value
     * @return \StructType\Meldeblatt[]|null
     */
    public function getMeldeblatt()
    {
        return $this->meldeblatt;
    }
    /**
     * This method is responsible for validating the values passed to the setMeldeblatt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeldeblatt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeldeblattForArrayConstraintsFromSetMeldeblatt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $betriebMeldeblattItem) {
            // validation for constraint: itemType
            if (!$betriebMeldeblattItem instanceof \StructType\Meldeblatt) {
                $invalidValues[] = is_object($betriebMeldeblattItem) ? get_class($betriebMeldeblattItem) : sprintf('%s(%s)', gettype($betriebMeldeblattItem), var_export($betriebMeldeblattItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The meldeblatt property can only contain items of type \StructType\Meldeblatt, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set meldeblatt value
     * @throws \InvalidArgumentException
     * @param \StructType\Meldeblatt[] $meldeblatt
     * @return \StructType\Betrieb
     */
    public function setMeldeblatt(array $meldeblatt = array())
    {
        // validation for constraint: array
        if ('' !== ($meldeblattArrayErrorMessage = self::validateMeldeblattForArrayConstraintsFromSetMeldeblatt($meldeblatt))) {
            throw new \InvalidArgumentException($meldeblattArrayErrorMessage, __LINE__);
        }
        $this->meldeblatt = $meldeblatt;
        return $this;
    }
    /**
     * Add item to meldeblatt value
     * @throws \InvalidArgumentException
     * @param \StructType\Meldeblatt $item
     * @return \StructType\Betrieb
     */
    public function addToMeldeblatt(\StructType\Meldeblatt $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Meldeblatt) {
            throw new \InvalidArgumentException(sprintf('The meldeblatt property can only contain items of type \StructType\Meldeblatt, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->meldeblatt[] = $item;
        return $this;
    }
    /**
     * Get nummernblocklist value
     * @return \ArrayType\ArrayOfGemeindeBetriebNummernblock|null
     */
    public function getNummernblocklist()
    {
        return $this->nummernblocklist;
    }
    /**
     * Set nummernblocklist value
     * @param \ArrayType\ArrayOfGemeindeBetriebNummernblock $nummernblocklist
     * @return \StructType\Betrieb
     */
    public function setNummernblocklist(\ArrayType\ArrayOfGemeindeBetriebNummernblock $nummernblocklist = null)
    {
        $this->nummernblocklist = $nummernblocklist;
        return $this;
    }
    /**
     * Get gastartlist value
     * @return \StructType\Gastartlist|null
     */
    public function getGastartlist()
    {
        return $this->gastartlist;
    }
    /**
     * Set gastartlist value
     * @param \StructType\Gastartlist $gastartlist
     * @return \StructType\Betrieb
     */
    public function setGastartlist(\StructType\Gastartlist $gastartlist = null)
    {
        $this->gastartlist = $gastartlist;
        return $this;
    }
    /**
     * Get card value
     * @return \StructType\Card[]|null
     */
    public function getCard()
    {
        return $this->card;
    }
    /**
     * This method is responsible for validating the values passed to the setCard method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCard method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCardForArrayConstraintsFromSetCard(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $betriebCardItem) {
            // validation for constraint: itemType
            if (!$betriebCardItem instanceof \StructType\Card) {
                $invalidValues[] = is_object($betriebCardItem) ? get_class($betriebCardItem) : sprintf('%s(%s)', gettype($betriebCardItem), var_export($betriebCardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The card property can only contain items of type \StructType\Card, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set card value
     * @throws \InvalidArgumentException
     * @param \StructType\Card[] $card
     * @return \StructType\Betrieb
     */
    public function setCard(array $card = array())
    {
        // validation for constraint: array
        if ('' !== ($cardArrayErrorMessage = self::validateCardForArrayConstraintsFromSetCard($card))) {
            throw new \InvalidArgumentException($cardArrayErrorMessage, __LINE__);
        }
        $this->card = $card;
        return $this;
    }
    /**
     * Add item to card value
     * @throws \InvalidArgumentException
     * @param \StructType\Card $item
     * @return \StructType\Betrieb
     */
    public function addToCard(\StructType\Card $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Card) {
            throw new \InvalidArgumentException(sprintf('The card property can only contain items of type \StructType\Card, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->card[] = $item;
        return $this;
    }
    /**
     * Get webclient value
     * @return \StructType\Webclient|null
     */
    public function getWebclient()
    {
        return $this->webclient;
    }
    /**
     * Set webclient value
     * @param \StructType\Webclient $webclient
     * @return \StructType\Betrieb
     */
    public function setWebclient(\StructType\Webclient $webclient = null)
    {
        $this->webclient = $webclient;
        return $this;
    }
    /**
     * Get precheckin value
     * @return \StructType\Precheckin|null
     */
    public function getPrecheckin()
    {
        return $this->precheckin;
    }
    /**
     * Set precheckin value
     * @param \StructType\Precheckin $precheckin
     * @return \StructType\Betrieb
     */
    public function setPrecheckin(\StructType\Precheckin $precheckin = null)
    {
        $this->precheckin = $precheckin;
        return $this;
    }
    /**
     * Get selfcheckin value
     * @return \StructType\Selfcheckin|null
     */
    public function getSelfcheckin()
    {
        return $this->selfcheckin;
    }
    /**
     * Set selfcheckin value
     * @param \StructType\Selfcheckin $selfcheckin
     * @return \StructType\Betrieb
     */
    public function setSelfcheckin(\StructType\Selfcheckin $selfcheckin = null)
    {
        $this->selfcheckin = $selfcheckin;
        return $this;
    }
    /**
     * Get betriebnr value
     * @return string|null
     */
    public function getBetriebnr()
    {
        return $this->betriebnr;
    }
    /**
     * Set betriebnr value
     * @param string $betriebnr
     * @return \StructType\Betrieb
     */
    public function setBetriebnr($betriebnr = null)
    {
        // validation for constraint: string
        if (!is_null($betriebnr) && !is_string($betriebnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($betriebnr, true), gettype($betriebnr)), __LINE__);
        }
        $this->betriebnr = $betriebnr;
        return $this;
    }
    /**
     * Get betriebnr_alpha value
     * @return string|null
     */
    public function getBetriebnr_alpha()
    {
        return $this->betriebnr_alpha;
    }
    /**
     * Set betriebnr_alpha value
     * @param string $betriebnr_alpha
     * @return \StructType\Betrieb
     */
    public function setBetriebnr_alpha($betriebnr_alpha = null)
    {
        // validation for constraint: string
        if (!is_null($betriebnr_alpha) && !is_string($betriebnr_alpha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($betriebnr_alpha, true), gettype($betriebnr_alpha)), __LINE__);
        }
        $this->betriebnr_alpha = $betriebnr_alpha;
        return $this;
    }
    /**
     * Get uvmnr value
     * @return int|null
     */
    public function getUvmnr()
    {
        return $this->uvmnr;
    }
    /**
     * Set uvmnr value
     * @param int $uvmnr
     * @return \StructType\Betrieb
     */
    public function setUvmnr($uvmnr = null)
    {
        // validation for constraint: int
        if (!is_null($uvmnr) && !(is_int($uvmnr) || ctype_digit($uvmnr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uvmnr, true), gettype($uvmnr)), __LINE__);
        }
        $this->uvmnr = $uvmnr;
        return $this;
    }
    /**
     * Get feratelext_objectcode value
     * @return string|null
     */
    public function getFeratelext_objectcode()
    {
        return $this->feratelext_objectcode;
    }
    /**
     * Set feratelext_objectcode value
     * @param string $feratelext_objectcode
     * @return \StructType\Betrieb
     */
    public function setFeratelext_objectcode($feratelext_objectcode = null)
    {
        // validation for constraint: string
        if (!is_null($feratelext_objectcode) && !is_string($feratelext_objectcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feratelext_objectcode, true), gettype($feratelext_objectcode)), __LINE__);
        }
        $this->feratelext_objectcode = $feratelext_objectcode;
        return $this;
    }
    /**
     * Get oestat_norm value
     * @return string|null
     */
    public function getOestat_norm()
    {
        return $this->oestat_norm;
    }
    /**
     * Set oestat_norm value
     * @param string $oestat_norm
     * @return \StructType\Betrieb
     */
    public function setOestat_norm($oestat_norm = null)
    {
        // validation for constraint: string
        if (!is_null($oestat_norm) && !is_string($oestat_norm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oestat_norm, true), gettype($oestat_norm)), __LINE__);
        }
        $this->oestat_norm = $oestat_norm;
        return $this;
    }
    /**
     * Get feratelext_id value
     * @return string|null
     */
    public function getFeratelext_id()
    {
        return $this->feratelext_id;
    }
    /**
     * Set feratelext_id value
     * @param string $feratelext_id
     * @return \StructType\Betrieb
     */
    public function setFeratelext_id($feratelext_id = null)
    {
        // validation for constraint: string
        if (!is_null($feratelext_id) && !is_string($feratelext_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feratelext_id, true), gettype($feratelext_id)), __LINE__);
        }
        $this->feratelext_id = $feratelext_id;
        return $this;
    }
    /**
     * Get mcnummer value
     * @return int|null
     */
    public function getMcnummer()
    {
        return $this->mcnummer;
    }
    /**
     * Set mcnummer value
     * @param int $mcnummer
     * @return \StructType\Betrieb
     */
    public function setMcnummer($mcnummer = null)
    {
        // validation for constraint: int
        if (!is_null($mcnummer) && !(is_int($mcnummer) || ctype_digit($mcnummer))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mcnummer, true), gettype($mcnummer)), __LINE__);
        }
        $this->mcnummer = $mcnummer;
        return $this;
    }
    /**
     * Get voranmeldung value
     * @return int|null
     */
    public function getVoranmeldung()
    {
        return $this->voranmeldung;
    }
    /**
     * Set voranmeldung value
     * @param int $voranmeldung
     * @return \StructType\Betrieb
     */
    public function setVoranmeldung($voranmeldung = null)
    {
        // validation for constraint: int
        if (!is_null($voranmeldung) && !(is_int($voranmeldung) || ctype_digit($voranmeldung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voranmeldung, true), gettype($voranmeldung)), __LINE__);
        }
        $this->voranmeldung = $voranmeldung;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Betrieb
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get ort value
     * @return string|null
     */
    public function getOrt()
    {
        return $this->ort;
    }
    /**
     * Set ort value
     * @param string $ort
     * @return \StructType\Betrieb
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        $this->ort = $ort;
        return $this;
    }
    /**
     * Get plz value
     * @return string|null
     */
    public function getPlz()
    {
        return $this->plz;
    }
    /**
     * Set plz value
     * @param string $plz
     * @return \StructType\Betrieb
     */
    public function setPlz($plz = null)
    {
        // validation for constraint: string
        if (!is_null($plz) && !is_string($plz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plz, true), gettype($plz)), __LINE__);
        }
        $this->plz = $plz;
        return $this;
    }
    /**
     * Get strasse value
     * @return string|null
     */
    public function getStrasse()
    {
        return $this->strasse;
    }
    /**
     * Set strasse value
     * @param string $strasse
     * @return \StructType\Betrieb
     */
    public function setStrasse($strasse = null)
    {
        // validation for constraint: string
        if (!is_null($strasse) && !is_string($strasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strasse, true), gettype($strasse)), __LINE__);
        }
        $this->strasse = $strasse;
        return $this;
    }
}
