<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AutoAssignedVTBlockType StructType
 * @subpackage Structs
 */
class AutoAssignedVTBlockType extends AbstractStructBase
{
    /**
     * The Year
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Year;
    /**
     * The NumberFrom
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $NumberFrom;
    /**
     * The NumberTo
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $NumberTo;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $CreateDate;
    /**
     * The ChangeDate
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ChangeDate;
    /**
     * The BlockID
     * @var string
     */
    public $BlockID;
    /**
     * The Remark
     * @var string
     */
    public $Remark;
    /**
     * Constructor method for AutoAssignedVTBlockType
     * @uses AutoAssignedVTBlockType::setYear()
     * @uses AutoAssignedVTBlockType::setNumberFrom()
     * @uses AutoAssignedVTBlockType::setNumberTo()
     * @uses AutoAssignedVTBlockType::setStatus()
     * @uses AutoAssignedVTBlockType::setCreateDate()
     * @uses AutoAssignedVTBlockType::setChangeDate()
     * @uses AutoAssignedVTBlockType::setBlockID()
     * @uses AutoAssignedVTBlockType::setRemark()
     * @param int $year
     * @param int $numberFrom
     * @param int $numberTo
     * @param string $status
     * @param string $createDate
     * @param string $changeDate
     * @param string $blockID
     * @param string $remark
     */
    public function __construct($year = null, $numberFrom = null, $numberTo = null, $status = null, $createDate = null, $changeDate = null, $blockID = null, $remark = null)
    {
        $this
            ->setYear($year)
            ->setNumberFrom($numberFrom)
            ->setNumberTo($numberTo)
            ->setStatus($status)
            ->setCreateDate($createDate)
            ->setChangeDate($changeDate)
            ->setBlockID($blockID)
            ->setRemark($remark);
    }
    /**
     * Get Year value
     * @return int
     */
    public function getYear()
    {
        return $this->Year;
    }
    /**
     * Set Year value
     * @param int $year
     * @return \StructType\AutoAssignedVTBlockType
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !(is_int($year) || ctype_digit($year))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($year, true), gettype($year)), __LINE__);
        }
        $this->Year = $year;
        return $this;
    }
    /**
     * Get NumberFrom value
     * @return int
     */
    public function getNumberFrom()
    {
        return $this->NumberFrom;
    }
    /**
     * Set NumberFrom value
     * @param int $numberFrom
     * @return \StructType\AutoAssignedVTBlockType
     */
    public function setNumberFrom($numberFrom = null)
    {
        // validation for constraint: int
        if (!is_null($numberFrom) && !(is_int($numberFrom) || ctype_digit($numberFrom))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberFrom, true), gettype($numberFrom)), __LINE__);
        }
        $this->NumberFrom = $numberFrom;
        return $this;
    }
    /**
     * Get NumberTo value
     * @return int
     */
    public function getNumberTo()
    {
        return $this->NumberTo;
    }
    /**
     * Set NumberTo value
     * @param int $numberTo
     * @return \StructType\AutoAssignedVTBlockType
     */
    public function setNumberTo($numberTo = null)
    {
        // validation for constraint: int
        if (!is_null($numberTo) && !(is_int($numberTo) || ctype_digit($numberTo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberTo, true), gettype($numberTo)), __LINE__);
        }
        $this->NumberTo = $numberTo;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\VTBlockStatusEnum::valueIsValid()
     * @uses \EnumType\VTBlockStatusEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\AutoAssignedVTBlockType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VTBlockStatusEnum::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\VTBlockStatusEnum', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\VTBlockStatusEnum::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get CreateDate value
     * @return string
     */
    public function getCreateDate()
    {
        return $this->CreateDate;
    }
    /**
     * Set CreateDate value
     * @param string $createDate
     * @return \StructType\AutoAssignedVTBlockType
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        $this->CreateDate = $createDate;
        return $this;
    }
    /**
     * Get ChangeDate value
     * @return string
     */
    public function getChangeDate()
    {
        return $this->ChangeDate;
    }
    /**
     * Set ChangeDate value
     * @param string $changeDate
     * @return \StructType\AutoAssignedVTBlockType
     */
    public function setChangeDate($changeDate = null)
    {
        // validation for constraint: string
        if (!is_null($changeDate) && !is_string($changeDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($changeDate, true), gettype($changeDate)), __LINE__);
        }
        $this->ChangeDate = $changeDate;
        return $this;
    }
    /**
     * Get BlockID value
     * @return string|null
     */
    public function getBlockID()
    {
        return $this->BlockID;
    }
    /**
     * Set BlockID value
     * @param string $blockID
     * @return \StructType\AutoAssignedVTBlockType
     */
    public function setBlockID($blockID = null)
    {
        // validation for constraint: string
        if (!is_null($blockID) && !is_string($blockID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blockID, true), gettype($blockID)), __LINE__);
        }
        $this->BlockID = $blockID;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\AutoAssignedVTBlockType
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
}
