<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Show ServiceType
 * @subpackage Services
 */
class Show extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ShowStatusVRTransfer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ShowStatusVRTransfer $parameters
     * @return \StructType\ShowStatusVRTransferResponse|bool
     */
    public function ShowStatusVRTransfer(\StructType\ShowStatusVRTransfer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ShowStatusVRTransfer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ShowStatusVRTransferResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
