<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import ServiceType
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ImportPMSString
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @return \StructType\Answer|bool
     */
    public function ImportPMSString()
    {
        try {
            $this->setResult($this->getSoapClient()->ImportPMSString());
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportPMS
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Gemeinde $gemeinde
     * @param string $companyCode
     * @param string $forceImportSettled
     * @param string $forceImportCancelled
     * @param string $loginID
     * @param string $source
     * @param \StructType\VTFormXml $vtFormXml
     * @param string $checkOnly
     * @return \StructType\Answer|bool
     */
    public function ImportPMS(\StructType\Gemeinde $gemeinde, $companyCode, $forceImportSettled, $forceImportCancelled, $loginID, $source, \StructType\VTFormXml $vtFormXml, $checkOnly)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportPMS($gemeinde, $companyCode, $forceImportSettled, $forceImportCancelled, $loginID, $source, $vtFormXml, $checkOnly));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Answer
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
