<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfServiceProviderType ArrayType
 * @subpackage Arrays
 */
class ArrayOfServiceProviderType extends AbstractStructArrayBase
{
    /**
     * The ServiceProvider
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceProviderType[]
     */
    public $ServiceProvider;
    /**
     * Constructor method for ArrayOfServiceProviderType
     * @uses ArrayOfServiceProviderType::setServiceProvider()
     * @param \StructType\ServiceProviderType[] $serviceProvider
     */
    public function __construct(array $serviceProvider = array())
    {
        $this
            ->setServiceProvider($serviceProvider);
    }
    /**
     * Get ServiceProvider value
     * @return \StructType\ServiceProviderType[]|null
     */
    public function getServiceProvider()
    {
        return $this->ServiceProvider;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceProvider method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceProvider method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceProviderForArrayConstraintsFromSetServiceProvider(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfServiceProviderTypeServiceProviderItem) {
            // validation for constraint: itemType
            if (!$arrayOfServiceProviderTypeServiceProviderItem instanceof \StructType\ServiceProviderType) {
                $invalidValues[] = is_object($arrayOfServiceProviderTypeServiceProviderItem) ? get_class($arrayOfServiceProviderTypeServiceProviderItem) : sprintf('%s(%s)', gettype($arrayOfServiceProviderTypeServiceProviderItem), var_export($arrayOfServiceProviderTypeServiceProviderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceProvider property can only contain items of type \StructType\ServiceProviderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceProvider value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceProviderType[] $serviceProvider
     * @return \ArrayType\ArrayOfServiceProviderType
     */
    public function setServiceProvider(array $serviceProvider = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceProviderArrayErrorMessage = self::validateServiceProviderForArrayConstraintsFromSetServiceProvider($serviceProvider))) {
            throw new \InvalidArgumentException($serviceProviderArrayErrorMessage, __LINE__);
        }
        $this->ServiceProvider = $serviceProvider;
        return $this;
    }
    /**
     * Add item to ServiceProvider value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceProviderType $item
     * @return \ArrayType\ArrayOfServiceProviderType
     */
    public function addToServiceProvider(\StructType\ServiceProviderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceProviderType) {
            throw new \InvalidArgumentException(sprintf('The ServiceProvider property can only contain items of type \StructType\ServiceProviderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceProvider[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ServiceProviderType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ServiceProviderType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ServiceProviderType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ServiceProviderType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ServiceProviderType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceProvider
     */
    public function getAttributeName()
    {
        return 'ServiceProvider';
    }
}
