<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for webclient StructType
 * @subpackage Structs
 */
class Webclient extends AbstractStructBase
{
    /**
     * The link
     * @var string
     */
    public $link;
    /**
     * The DBCode
     * @var string
     */
    public $DBCode;
    /**
     * Constructor method for webclient
     * @uses Webclient::setLink()
     * @uses Webclient::setDBCode()
     * @param string $link
     * @param string $dBCode
     */
    public function __construct($link = null, $dBCode = null)
    {
        $this
            ->setLink($link)
            ->setDBCode($dBCode);
    }
    /**
     * Get link value
     * @return string|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * Set link value
     * @param string $link
     * @return \StructType\Webclient
     */
    public function setLink($link = null)
    {
        // validation for constraint: string
        if (!is_null($link) && !is_string($link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($link, true), gettype($link)), __LINE__);
        }
        $this->link = $link;
        return $this;
    }
    /**
     * Get DBCode value
     * @return string|null
     */
    public function getDBCode()
    {
        return $this->DBCode;
    }
    /**
     * Set DBCode value
     * @param string $dBCode
     * @return \StructType\Webclient
     */
    public function setDBCode($dBCode = null)
    {
        // validation for constraint: string
        if (!is_null($dBCode) && !is_string($dBCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dBCode, true), gettype($dBCode)), __LINE__);
        }
        $this->DBCode = $dBCode;
        return $this;
    }
}
