<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VTInventoryList StructType
 * @subpackage Structs
 */
class VTInventoryList extends AbstractStructBase
{
    /**
     * The VTInventory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VTInventoryType[]
     */
    public $VTInventory;
    /**
     * The ServiceProviderID
     * @var string
     */
    public $ServiceProviderID;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for VTInventoryList
     * @uses VTInventoryList::setVTInventory()
     * @uses VTInventoryList::setServiceProviderID()
     * @uses VTInventoryList::setName()
     * @uses VTInventoryList::setCode()
     * @param \StructType\VTInventoryType[] $vTInventory
     * @param string $serviceProviderID
     * @param string $name
     * @param string $code
     */
    public function __construct(array $vTInventory = array(), $serviceProviderID = null, $name = null, $code = null)
    {
        $this
            ->setVTInventory($vTInventory)
            ->setServiceProviderID($serviceProviderID)
            ->setName($name)
            ->setCode($code);
    }
    /**
     * Get VTInventory value
     * @return \StructType\VTInventoryType[]|null
     */
    public function getVTInventory()
    {
        return $this->VTInventory;
    }
    /**
     * This method is responsible for validating the values passed to the setVTInventory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVTInventory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVTInventoryForArrayConstraintsFromSetVTInventory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $vTInventoryListVTInventoryItem) {
            // validation for constraint: itemType
            if (!$vTInventoryListVTInventoryItem instanceof \StructType\VTInventoryType) {
                $invalidValues[] = is_object($vTInventoryListVTInventoryItem) ? get_class($vTInventoryListVTInventoryItem) : sprintf('%s(%s)', gettype($vTInventoryListVTInventoryItem), var_export($vTInventoryListVTInventoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VTInventory property can only contain items of type \StructType\VTInventoryType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VTInventory value
     * @throws \InvalidArgumentException
     * @param \StructType\VTInventoryType[] $vTInventory
     * @return \StructType\VTInventoryList
     */
    public function setVTInventory(array $vTInventory = array())
    {
        // validation for constraint: array
        if ('' !== ($vTInventoryArrayErrorMessage = self::validateVTInventoryForArrayConstraintsFromSetVTInventory($vTInventory))) {
            throw new \InvalidArgumentException($vTInventoryArrayErrorMessage, __LINE__);
        }
        $this->VTInventory = $vTInventory;
        return $this;
    }
    /**
     * Add item to VTInventory value
     * @throws \InvalidArgumentException
     * @param \StructType\VTInventoryType $item
     * @return \StructType\VTInventoryList
     */
    public function addToVTInventory(\StructType\VTInventoryType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VTInventoryType) {
            throw new \InvalidArgumentException(sprintf('The VTInventory property can only contain items of type \StructType\VTInventoryType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VTInventory[] = $item;
        return $this;
    }
    /**
     * Get ServiceProviderID value
     * @return string|null
     */
    public function getServiceProviderID()
    {
        return $this->ServiceProviderID;
    }
    /**
     * Set ServiceProviderID value
     * @param string $serviceProviderID
     * @return \StructType\VTInventoryList
     */
    public function setServiceProviderID($serviceProviderID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceProviderID) && !is_string($serviceProviderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceProviderID, true), gettype($serviceProviderID)), __LINE__);
        }
        $this->ServiceProviderID = $serviceProviderID;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\VTInventoryList
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\VTInventoryList
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
}
