<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VTFormXml StructType
 * @subpackage Structs
 */
class VTFormXml extends BaseObject
{
    /**
     * The CompanyId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $CompanyId;
    /**
     * The ReferenceId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ReferenceId;
    /**
     * The CommunityNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $CommunityNumber;
    /**
     * The CommunityId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $CommunityId;
    /**
     * The SheetNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SheetNumber;
    /**
     * The SheetId
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $SheetId;
    /**
     * The ProviderID
     * Meta information extracted from the WSDL
     * - base: s:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}
     * @var string
     */
    public $ProviderID;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $Status;
    /**
     * The ExImportErrorImportType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ExImportErrorImportType;
    /**
     * The ExImportErrorYear
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ExImportErrorYear;
    /**
     * The MappingCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MappingCode;
    /**
     * The Request
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Request;
    /**
     * The Response
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Response;
    /**
     * The ExCompanyName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExCompanyName;
    /**
     * The ExCommunityName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExCommunityName;
    /**
     * The ExProviderName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExProviderName;
    /**
     * The ExProviderCode
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExProviderCode;
    /**
     * Constructor method for VTFormXml
     * @uses VTFormXml::setCompanyId()
     * @uses VTFormXml::setReferenceId()
     * @uses VTFormXml::setCommunityNumber()
     * @uses VTFormXml::setCommunityId()
     * @uses VTFormXml::setSheetNumber()
     * @uses VTFormXml::setSheetId()
     * @uses VTFormXml::setProviderID()
     * @uses VTFormXml::setStatus()
     * @uses VTFormXml::setExImportErrorImportType()
     * @uses VTFormXml::setExImportErrorYear()
     * @uses VTFormXml::setMappingCode()
     * @uses VTFormXml::setRequest()
     * @uses VTFormXml::setResponse()
     * @uses VTFormXml::setExCompanyName()
     * @uses VTFormXml::setExCommunityName()
     * @uses VTFormXml::setExProviderName()
     * @uses VTFormXml::setExProviderCode()
     * @param string $companyId
     * @param string $referenceId
     * @param int $communityNumber
     * @param string $communityId
     * @param int $sheetNumber
     * @param string $sheetId
     * @param string $providerID
     * @param int $status
     * @param string $exImportErrorImportType
     * @param int $exImportErrorYear
     * @param string $mappingCode
     * @param string $request
     * @param string $response
     * @param string $exCompanyName
     * @param string $exCommunityName
     * @param string $exProviderName
     * @param string $exProviderCode
     */
    public function __construct($companyId = null, $referenceId = null, $communityNumber = null, $communityId = null, $sheetNumber = null, $sheetId = null, $providerID = null, $status = null, $exImportErrorImportType = null, $exImportErrorYear = null, $mappingCode = null, $request = null, $response = null, $exCompanyName = null, $exCommunityName = null, $exProviderName = null, $exProviderCode = null)
    {
        $this
            ->setCompanyId($companyId)
            ->setReferenceId($referenceId)
            ->setCommunityNumber($communityNumber)
            ->setCommunityId($communityId)
            ->setSheetNumber($sheetNumber)
            ->setSheetId($sheetId)
            ->setProviderID($providerID)
            ->setStatus($status)
            ->setExImportErrorImportType($exImportErrorImportType)
            ->setExImportErrorYear($exImportErrorYear)
            ->setMappingCode($mappingCode)
            ->setRequest($request)
            ->setResponse($response)
            ->setExCompanyName($exCompanyName)
            ->setExCommunityName($exCommunityName)
            ->setExProviderName($exProviderName)
            ->setExProviderCode($exProviderCode);
    }
    /**
     * Get CompanyId value
     * @return string
     */
    public function getCompanyId()
    {
        return $this->CompanyId;
    }
    /**
     * Set CompanyId value
     * @param string $companyId
     * @return \StructType\VTFormXml
     */
    public function setCompanyId($companyId = null)
    {
        // validation for constraint: string
        if (!is_null($companyId) && !is_string($companyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyId, true), gettype($companyId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($companyId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $companyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($companyId, true)), __LINE__);
        }
        $this->CompanyId = $companyId;
        return $this;
    }
    /**
     * Get ReferenceId value
     * @return string
     */
    public function getReferenceId()
    {
        return $this->ReferenceId;
    }
    /**
     * Set ReferenceId value
     * @param string $referenceId
     * @return \StructType\VTFormXml
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($referenceId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($referenceId, true)), __LINE__);
        }
        $this->ReferenceId = $referenceId;
        return $this;
    }
    /**
     * Get CommunityNumber value
     * @return int
     */
    public function getCommunityNumber()
    {
        return $this->CommunityNumber;
    }
    /**
     * Set CommunityNumber value
     * @param int $communityNumber
     * @return \StructType\VTFormXml
     */
    public function setCommunityNumber($communityNumber = null)
    {
        // validation for constraint: int
        if (!is_null($communityNumber) && !(is_int($communityNumber) || ctype_digit($communityNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($communityNumber, true), gettype($communityNumber)), __LINE__);
        }
        $this->CommunityNumber = $communityNumber;
        return $this;
    }
    /**
     * Get CommunityId value
     * @return string
     */
    public function getCommunityId()
    {
        return $this->CommunityId;
    }
    /**
     * Set CommunityId value
     * @param string $communityId
     * @return \StructType\VTFormXml
     */
    public function setCommunityId($communityId = null)
    {
        // validation for constraint: string
        if (!is_null($communityId) && !is_string($communityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($communityId, true), gettype($communityId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($communityId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $communityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($communityId, true)), __LINE__);
        }
        $this->CommunityId = $communityId;
        return $this;
    }
    /**
     * Get SheetNumber value
     * @return int
     */
    public function getSheetNumber()
    {
        return $this->SheetNumber;
    }
    /**
     * Set SheetNumber value
     * @param int $sheetNumber
     * @return \StructType\VTFormXml
     */
    public function setSheetNumber($sheetNumber = null)
    {
        // validation for constraint: int
        if (!is_null($sheetNumber) && !(is_int($sheetNumber) || ctype_digit($sheetNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sheetNumber, true), gettype($sheetNumber)), __LINE__);
        }
        $this->SheetNumber = $sheetNumber;
        return $this;
    }
    /**
     * Get SheetId value
     * @return string
     */
    public function getSheetId()
    {
        return $this->SheetId;
    }
    /**
     * Set SheetId value
     * @param string $sheetId
     * @return \StructType\VTFormXml
     */
    public function setSheetId($sheetId = null)
    {
        // validation for constraint: string
        if (!is_null($sheetId) && !is_string($sheetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sheetId, true), gettype($sheetId)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($sheetId) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $sheetId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($sheetId, true)), __LINE__);
        }
        $this->SheetId = $sheetId;
        return $this;
    }
    /**
     * Get ProviderID value
     * @return string
     */
    public function getProviderID()
    {
        return $this->ProviderID;
    }
    /**
     * Set ProviderID value
     * @param string $providerID
     * @return \StructType\VTFormXml
     */
    public function setProviderID($providerID = null)
    {
        // validation for constraint: string
        if (!is_null($providerID) && !is_string($providerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerID, true), gettype($providerID)), __LINE__);
        }
        // validation for constraint: pattern([0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})
        if (!is_null($providerID) && !preg_match('/[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}/', $providerID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}', var_export($providerID, true)), __LINE__);
        }
        $this->ProviderID = $providerID;
        return $this;
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \StructType\VTFormXml
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get ExImportErrorImportType value
     * @return string
     */
    public function getExImportErrorImportType()
    {
        return $this->ExImportErrorImportType;
    }
    /**
     * Set ExImportErrorImportType value
     * @uses \EnumType\ImportType::valueIsValid()
     * @uses \EnumType\ImportType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $exImportErrorImportType
     * @return \StructType\VTFormXml
     */
    public function setExImportErrorImportType($exImportErrorImportType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ImportType::valueIsValid($exImportErrorImportType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ImportType', is_array($exImportErrorImportType) ? implode(', ', $exImportErrorImportType) : var_export($exImportErrorImportType, true), implode(', ', \EnumType\ImportType::getValidValues())), __LINE__);
        }
        $this->ExImportErrorImportType = $exImportErrorImportType;
        return $this;
    }
    /**
     * Get ExImportErrorYear value
     * @return int
     */
    public function getExImportErrorYear()
    {
        return $this->ExImportErrorYear;
    }
    /**
     * Set ExImportErrorYear value
     * @param int $exImportErrorYear
     * @return \StructType\VTFormXml
     */
    public function setExImportErrorYear($exImportErrorYear = null)
    {
        // validation for constraint: int
        if (!is_null($exImportErrorYear) && !(is_int($exImportErrorYear) || ctype_digit($exImportErrorYear))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($exImportErrorYear, true), gettype($exImportErrorYear)), __LINE__);
        }
        $this->ExImportErrorYear = $exImportErrorYear;
        return $this;
    }
    /**
     * Get MappingCode value
     * @return string|null
     */
    public function getMappingCode()
    {
        return $this->MappingCode;
    }
    /**
     * Set MappingCode value
     * @param string $mappingCode
     * @return \StructType\VTFormXml
     */
    public function setMappingCode($mappingCode = null)
    {
        // validation for constraint: string
        if (!is_null($mappingCode) && !is_string($mappingCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mappingCode, true), gettype($mappingCode)), __LINE__);
        }
        $this->MappingCode = $mappingCode;
        return $this;
    }
    /**
     * Get Request value
     * @return string|null
     */
    public function getRequest()
    {
        return $this->Request;
    }
    /**
     * Set Request value
     * @param string $request
     * @return \StructType\VTFormXml
     */
    public function setRequest($request = null)
    {
        // validation for constraint: string
        if (!is_null($request) && !is_string($request)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($request, true), gettype($request)), __LINE__);
        }
        $this->Request = $request;
        return $this;
    }
    /**
     * Get Response value
     * @return string|null
     */
    public function getResponse()
    {
        return $this->Response;
    }
    /**
     * Set Response value
     * @param string $response
     * @return \StructType\VTFormXml
     */
    public function setResponse($response = null)
    {
        // validation for constraint: string
        if (!is_null($response) && !is_string($response)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($response, true), gettype($response)), __LINE__);
        }
        $this->Response = $response;
        return $this;
    }
    /**
     * Get ExCompanyName value
     * @return string|null
     */
    public function getExCompanyName()
    {
        return $this->ExCompanyName;
    }
    /**
     * Set ExCompanyName value
     * @param string $exCompanyName
     * @return \StructType\VTFormXml
     */
    public function setExCompanyName($exCompanyName = null)
    {
        // validation for constraint: string
        if (!is_null($exCompanyName) && !is_string($exCompanyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exCompanyName, true), gettype($exCompanyName)), __LINE__);
        }
        $this->ExCompanyName = $exCompanyName;
        return $this;
    }
    /**
     * Get ExCommunityName value
     * @return string|null
     */
    public function getExCommunityName()
    {
        return $this->ExCommunityName;
    }
    /**
     * Set ExCommunityName value
     * @param string $exCommunityName
     * @return \StructType\VTFormXml
     */
    public function setExCommunityName($exCommunityName = null)
    {
        // validation for constraint: string
        if (!is_null($exCommunityName) && !is_string($exCommunityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exCommunityName, true), gettype($exCommunityName)), __LINE__);
        }
        $this->ExCommunityName = $exCommunityName;
        return $this;
    }
    /**
     * Get ExProviderName value
     * @return string|null
     */
    public function getExProviderName()
    {
        return $this->ExProviderName;
    }
    /**
     * Set ExProviderName value
     * @param string $exProviderName
     * @return \StructType\VTFormXml
     */
    public function setExProviderName($exProviderName = null)
    {
        // validation for constraint: string
        if (!is_null($exProviderName) && !is_string($exProviderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exProviderName, true), gettype($exProviderName)), __LINE__);
        }
        $this->ExProviderName = $exProviderName;
        return $this;
    }
    /**
     * Get ExProviderCode value
     * @return string|null
     */
    public function getExProviderCode()
    {
        return $this->ExProviderCode;
    }
    /**
     * Set ExProviderCode value
     * @param string $exProviderCode
     * @return \StructType\VTFormXml
     */
    public function setExProviderCode($exProviderCode = null)
    {
        // validation for constraint: string
        if (!is_null($exProviderCode) && !is_string($exProviderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exProviderCode, true), gettype($exProviderCode)), __LINE__);
        }
        $this->ExProviderCode = $exProviderCode;
        return $this;
    }
}
