<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VTCategoryType StructType
 * @subpackage Structs
 */
class VTCategoryType extends AbstractStructBase
{
    /**
     * The Commercial
     * Meta information extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Commercial;
    /**
     * The ValidFrom
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ValidFrom;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * Constructor method for VTCategoryType
     * @uses VTCategoryType::setCommercial()
     * @uses VTCategoryType::setValidFrom()
     * @uses VTCategoryType::setID()
     * @uses VTCategoryType::setName()
     * @param bool $commercial
     * @param string $validFrom
     * @param string $iD
     * @param string $name
     */
    public function __construct($commercial = null, $validFrom = null, $iD = null, $name = null)
    {
        $this
            ->setCommercial($commercial)
            ->setValidFrom($validFrom)
            ->setID($iD)
            ->setName($name);
    }
    /**
     * Get Commercial value
     * @return bool
     */
    public function getCommercial()
    {
        return $this->Commercial;
    }
    /**
     * Set Commercial value
     * @param bool $commercial
     * @return \StructType\VTCategoryType
     */
    public function setCommercial($commercial = null)
    {
        // validation for constraint: boolean
        if (!is_null($commercial) && !is_bool($commercial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($commercial, true), gettype($commercial)), __LINE__);
        }
        $this->Commercial = $commercial;
        return $this;
    }
    /**
     * Get ValidFrom value
     * @return string
     */
    public function getValidFrom()
    {
        return $this->ValidFrom;
    }
    /**
     * Set ValidFrom value
     * @param string $validFrom
     * @return \StructType\VTCategoryType
     */
    public function setValidFrom($validFrom = null)
    {
        // validation for constraint: string
        if (!is_null($validFrom) && !is_string($validFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validFrom, true), gettype($validFrom)), __LINE__);
        }
        $this->ValidFrom = $validFrom;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\VTCategoryType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\VTCategoryType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
