<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for nummernblock StructType
 * @subpackage Structs
 */
class Nummernblock extends AbstractStructBase
{
    /**
     * The nrjahr
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $nrjahr;
    /**
     * The nrvon
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $nrvon;
    /**
     * The nrbis
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $nrbis;
    /**
     * The status
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $status;
    /**
     * The nextnr
     * @var int
     */
    public $nextnr;
    /**
     * The typ
     * Meta information extracted from the WSDL
     * - default: HOTELPROGRAMM
     * @var string
     */
    public $typ;
    /**
     * Constructor method for nummernblock
     * @uses Nummernblock::setNrjahr()
     * @uses Nummernblock::setNrvon()
     * @uses Nummernblock::setNrbis()
     * @uses Nummernblock::setStatus()
     * @uses Nummernblock::setNextnr()
     * @uses Nummernblock::setTyp()
     * @param int $nrjahr
     * @param int $nrvon
     * @param int $nrbis
     * @param int $status
     * @param int $nextnr
     * @param string $typ
     */
    public function __construct($nrjahr = null, $nrvon = null, $nrbis = null, $status = null, $nextnr = null, $typ = 'HOTELPROGRAMM')
    {
        $this
            ->setNrjahr($nrjahr)
            ->setNrvon($nrvon)
            ->setNrbis($nrbis)
            ->setStatus($status)
            ->setNextnr($nextnr)
            ->setTyp($typ);
    }
    /**
     * Get nrjahr value
     * @return int
     */
    public function getNrjahr()
    {
        return $this->nrjahr;
    }
    /**
     * Set nrjahr value
     * @param int $nrjahr
     * @return \StructType\Nummernblock
     */
    public function setNrjahr($nrjahr = null)
    {
        // validation for constraint: int
        if (!is_null($nrjahr) && !(is_int($nrjahr) || ctype_digit($nrjahr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nrjahr, true), gettype($nrjahr)), __LINE__);
        }
        $this->nrjahr = $nrjahr;
        return $this;
    }
    /**
     * Get nrvon value
     * @return int
     */
    public function getNrvon()
    {
        return $this->nrvon;
    }
    /**
     * Set nrvon value
     * @param int $nrvon
     * @return \StructType\Nummernblock
     */
    public function setNrvon($nrvon = null)
    {
        // validation for constraint: int
        if (!is_null($nrvon) && !(is_int($nrvon) || ctype_digit($nrvon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nrvon, true), gettype($nrvon)), __LINE__);
        }
        $this->nrvon = $nrvon;
        return $this;
    }
    /**
     * Get nrbis value
     * @return int
     */
    public function getNrbis()
    {
        return $this->nrbis;
    }
    /**
     * Set nrbis value
     * @param int $nrbis
     * @return \StructType\Nummernblock
     */
    public function setNrbis($nrbis = null)
    {
        // validation for constraint: int
        if (!is_null($nrbis) && !(is_int($nrbis) || ctype_digit($nrbis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nrbis, true), gettype($nrbis)), __LINE__);
        }
        $this->nrbis = $nrbis;
        return $this;
    }
    /**
     * Get status value
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\Nummernblock
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get nextnr value
     * @return int|null
     */
    public function getNextnr()
    {
        return $this->nextnr;
    }
    /**
     * Set nextnr value
     * @param int $nextnr
     * @return \StructType\Nummernblock
     */
    public function setNextnr($nextnr = null)
    {
        // validation for constraint: int
        if (!is_null($nextnr) && !(is_int($nextnr) || ctype_digit($nextnr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nextnr, true), gettype($nextnr)), __LINE__);
        }
        $this->nextnr = $nextnr;
        return $this;
    }
    /**
     * Get typ value
     * @return string|null
     */
    public function getTyp()
    {
        return $this->typ;
    }
    /**
     * Set typ value
     * @param string $typ
     * @return \StructType\Nummernblock
     */
    public function setTyp($typ = 'HOTELPROGRAMM')
    {
        // validation for constraint: string
        if (!is_null($typ) && !is_string($typ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typ, true), gettype($typ)), __LINE__);
        }
        $this->typ = $typ;
        return $this;
    }
}
