<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for meldeblatt StructType
 * @subpackage Structs
 */
class Meldeblatt extends AbstractStructBase
{
    /**
     * The ankunft
     * Meta information extracted from the WSDL
     * - use: required
     * @var string
     */
    public $ankunft;
    /**
     * The reisegruppe
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $reisegruppe;
    /**
     * The signatur
     * Meta information extracted from the WSDL
     * - use: required
     * @var string[]
     */
    public $signatur;
    /**
     * The anreisetyp
     * Meta information extracted from the WSDL
     * - choice: anreisetyp | aufenthaltsmotiv | gast | gastart | hobby | landschl | resonanz | anreisetyp | aufenthaltsmotiv | gast | gastart | hobby | landschl | resonanz
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Anreisetyp
     */
    public $anreisetyp;
    /**
     * The aufenthaltsmotiv
     * Meta information extracted from the WSDL
     * - choice: anreisetyp | aufenthaltsmotiv | gast | gastart | hobby | landschl | resonanz | anreisetyp | aufenthaltsmotiv | gast | gastart | hobby | landschl | resonanz
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Aufenthaltsmotiv
     */
    public $aufenthaltsmotiv;
    /**
     * The gast
     * Meta information extracted from the WSDL
     * - choice: anreisetyp | aufenthaltsmotiv | gast | gastart | hobby | landschl | resonanz | anreisetyp | aufenthaltsmotiv | gast | gastart | hobby | landschl | resonanz
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Gast
     */
    public $gast;
    /**
     * The gastart
     * Meta information extracted from the WSDL
     * - choice: anreisetyp | aufenthaltsmotiv | gast | gastart | hobby | landschl | resonanz | anreisetyp | aufenthaltsmotiv | gast | gastart | hobby | landschl | resonanz
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Gastart
     */
    public $gastart;
    /**
     * The hobby
     * Meta information extracted from the WSDL
     * - choice: anreisetyp | aufenthaltsmotiv | gast | gastart | hobby | landschl | resonanz | anreisetyp | aufenthaltsmotiv | gast | gastart | hobby | landschl | resonanz
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Hobby
     */
    public $hobby;
    /**
     * The landschl
     * Meta information extracted from the WSDL
     * - choice: anreisetyp | aufenthaltsmotiv | gast | gastart | hobby | landschl | resonanz | anreisetyp | aufenthaltsmotiv | gast | gastart | hobby | landschl | resonanz
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Landschl
     */
    public $landschl;
    /**
     * The resonanz
     * Meta information extracted from the WSDL
     * - choice: anreisetyp | aufenthaltsmotiv | gast | gastart | hobby | landschl | resonanz | anreisetyp | aufenthaltsmotiv | gast | gastart | hobby | landschl | resonanz
     * - choiceMaxOccurs: unbounded
     * - choiceMinOccurs: 0
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Resonanz
     */
    public $resonanz;
    /**
     * The mblattnr
     * @var int
     */
    public $mblattnr;
    /**
     * The mblattrefnr
     * @var int
     */
    public $mblattrefnr;
    /**
     * The bearbeiter
     * @var string
     */
    public $bearbeiter;
    /**
     * The bemerkung
     * @var string
     */
    public $bemerkung;
    /**
     * The aufenthalte
     * @var int
     */
    public $aufenthalte;
    /**
     * The zahlungsart
     * @var string
     */
    public $zahlungsart;
    /**
     * The abreise
     * @var string
     */
    public $abreise;
    /**
     * The abgeplant
     * @var string
     */
    public $abgeplant;
    /**
     * The undef1
     * @var string
     */
    public $undef1;
    /**
     * The undef2
     * @var string
     */
    public $undef2;
    /**
     * The undef3
     * @var string
     */
    public $undef3;
    /**
     * The errornumber
     * @var int
     */
    public $errornumber;
    /**
     * The errormsg
     * @var string
     */
    public $errormsg;
    /**
     * The timestamp
     * @var string
     */
    public $timestamp;
    /**
     * The storno
     * @var int
     */
    public $storno;
    /**
     * The mguid
     * @var string
     */
    public $mguid;
    /**
     * The guid
     * @var string
     */
    public $guid;
    /**
     * The abgereist
     * @var int
     */
    public $abgereist;
    /**
     * The reservierung
     * @var string
     */
    public $reservierung;
    /**
     * The kontaktverfolgung
     * Meta information extracted from the WSDL
     * - default: 0
     * @var int
     */
    public $kontaktverfolgung;
    /**
     * The kfz
     * @var string
     */
    public $kfz;
    /**
     * The ankunftszeitvon
     * @var string
     */
    public $ankunftszeitvon;
    /**
     * The ankunftszeitbis
     * @var string
     */
    public $ankunftszeitbis;
    /**
     * Constructor method for meldeblatt
     * @uses Meldeblatt::setAnkunft()
     * @uses Meldeblatt::setReisegruppe()
     * @uses Meldeblatt::setSignatur()
     * @uses Meldeblatt::setAnreisetyp()
     * @uses Meldeblatt::setAufenthaltsmotiv()
     * @uses Meldeblatt::setGast()
     * @uses Meldeblatt::setGastart()
     * @uses Meldeblatt::setHobby()
     * @uses Meldeblatt::setLandschl()
     * @uses Meldeblatt::setResonanz()
     * @uses Meldeblatt::setMblattnr()
     * @uses Meldeblatt::setMblattrefnr()
     * @uses Meldeblatt::setBearbeiter()
     * @uses Meldeblatt::setBemerkung()
     * @uses Meldeblatt::setAufenthalte()
     * @uses Meldeblatt::setZahlungsart()
     * @uses Meldeblatt::setAbreise()
     * @uses Meldeblatt::setAbgeplant()
     * @uses Meldeblatt::setUndef1()
     * @uses Meldeblatt::setUndef2()
     * @uses Meldeblatt::setUndef3()
     * @uses Meldeblatt::setErrornumber()
     * @uses Meldeblatt::setErrormsg()
     * @uses Meldeblatt::setTimestamp()
     * @uses Meldeblatt::setStorno()
     * @uses Meldeblatt::setMguid()
     * @uses Meldeblatt::setGuid()
     * @uses Meldeblatt::setAbgereist()
     * @uses Meldeblatt::setReservierung()
     * @uses Meldeblatt::setKontaktverfolgung()
     * @uses Meldeblatt::setKfz()
     * @uses Meldeblatt::setAnkunftszeitvon()
     * @uses Meldeblatt::setAnkunftszeitbis()
     * @param string $ankunft
     * @param int $reisegruppe
     * @param string[] $signatur
     * @param \StructType\Anreisetyp $anreisetyp
     * @param \StructType\Aufenthaltsmotiv $aufenthaltsmotiv
     * @param \StructType\Gast $gast
     * @param \StructType\Gastart $gastart
     * @param \StructType\Hobby $hobby
     * @param \StructType\Landschl $landschl
     * @param \StructType\Resonanz $resonanz
     * @param int $mblattnr
     * @param int $mblattrefnr
     * @param string $bearbeiter
     * @param string $bemerkung
     * @param int $aufenthalte
     * @param string $zahlungsart
     * @param string $abreise
     * @param string $abgeplant
     * @param string $undef1
     * @param string $undef2
     * @param string $undef3
     * @param int $errornumber
     * @param string $errormsg
     * @param string $timestamp
     * @param int $storno
     * @param string $mguid
     * @param string $guid
     * @param int $abgereist
     * @param string $reservierung
     * @param int $kontaktverfolgung
     * @param string $kfz
     * @param string $ankunftszeitvon
     * @param string $ankunftszeitbis
     */
    public function __construct($ankunft = null, $reisegruppe = null, array $signatur = array(), \StructType\Anreisetyp $anreisetyp = null, \StructType\Aufenthaltsmotiv $aufenthaltsmotiv = null, \StructType\Gast $gast = null, \StructType\Gastart $gastart = null, \StructType\Hobby $hobby = null, \StructType\Landschl $landschl = null, \StructType\Resonanz $resonanz = null, $mblattnr = null, $mblattrefnr = null, $bearbeiter = null, $bemerkung = null, $aufenthalte = null, $zahlungsart = null, $abreise = null, $abgeplant = null, $undef1 = null, $undef2 = null, $undef3 = null, $errornumber = null, $errormsg = null, $timestamp = null, $storno = null, $mguid = null, $guid = null, $abgereist = null, $reservierung = null, $kontaktverfolgung = 0, $kfz = null, $ankunftszeitvon = null, $ankunftszeitbis = null)
    {
        $this
            ->setAnkunft($ankunft)
            ->setReisegruppe($reisegruppe)
            ->setSignatur($signatur)
            ->setAnreisetyp($anreisetyp)
            ->setAufenthaltsmotiv($aufenthaltsmotiv)
            ->setGast($gast)
            ->setGastart($gastart)
            ->setHobby($hobby)
            ->setLandschl($landschl)
            ->setResonanz($resonanz)
            ->setMblattnr($mblattnr)
            ->setMblattrefnr($mblattrefnr)
            ->setBearbeiter($bearbeiter)
            ->setBemerkung($bemerkung)
            ->setAufenthalte($aufenthalte)
            ->setZahlungsart($zahlungsart)
            ->setAbreise($abreise)
            ->setAbgeplant($abgeplant)
            ->setUndef1($undef1)
            ->setUndef2($undef2)
            ->setUndef3($undef3)
            ->setErrornumber($errornumber)
            ->setErrormsg($errormsg)
            ->setTimestamp($timestamp)
            ->setStorno($storno)
            ->setMguid($mguid)
            ->setGuid($guid)
            ->setAbgereist($abgereist)
            ->setReservierung($reservierung)
            ->setKontaktverfolgung($kontaktverfolgung)
            ->setKfz($kfz)
            ->setAnkunftszeitvon($ankunftszeitvon)
            ->setAnkunftszeitbis($ankunftszeitbis);
    }
    /**
     * Get ankunft value
     * @return string
     */
    public function getAnkunft()
    {
        return $this->ankunft;
    }
    /**
     * Set ankunft value
     * @param string $ankunft
     * @return \StructType\Meldeblatt
     */
    public function setAnkunft($ankunft = null)
    {
        // validation for constraint: string
        if (!is_null($ankunft) && !is_string($ankunft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ankunft, true), gettype($ankunft)), __LINE__);
        }
        $this->ankunft = $ankunft;
        return $this;
    }
    /**
     * Get reisegruppe value
     * @return int
     */
    public function getReisegruppe()
    {
        return $this->reisegruppe;
    }
    /**
     * Set reisegruppe value
     * @param int $reisegruppe
     * @return \StructType\Meldeblatt
     */
    public function setReisegruppe($reisegruppe = null)
    {
        // validation for constraint: int
        if (!is_null($reisegruppe) && !(is_int($reisegruppe) || ctype_digit($reisegruppe))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reisegruppe, true), gettype($reisegruppe)), __LINE__);
        }
        $this->reisegruppe = $reisegruppe;
        return $this;
    }
    /**
     * Get signatur value
     * @return string[]
     */
    public function getSignatur()
    {
        return $this->signatur;
    }
    /**
     * This method is responsible for validating the values passed to the setSignatur method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSignatur method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSignaturForArrayConstraintsFromSetSignatur(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $meldeblattSignaturItem) {
            // validation for constraint: enumeration
            if (!\EnumType\SignaturEnum::valueIsValid($meldeblattSignaturItem)) {
                $invalidValues[] = is_object($meldeblattSignaturItem) ? get_class($meldeblattSignaturItem) : sprintf('%s(%s)', gettype($meldeblattSignaturItem), var_export($meldeblattSignaturItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SignaturEnum', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \EnumType\SignaturEnum::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set signatur value
     * @uses \EnumType\SignaturEnum::valueIsValid()
     * @uses \EnumType\SignaturEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $signatur
     * @return \StructType\Meldeblatt
     */
    public function setSignatur(array $signatur = array())
    {
        // validation for constraint: array
        if ('' !== ($signaturArrayErrorMessage = self::validateSignaturForArrayConstraintsFromSetSignatur($signatur))) {
            throw new \InvalidArgumentException($signaturArrayErrorMessage, __LINE__);
        }
        $this->signatur = $signatur;
        return $this;
    }
    /**
     * Add item to signatur value
     * @uses \EnumType\SignaturEnum::valueIsValid()
     * @uses \EnumType\SignaturEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\Meldeblatt
     */
    public function addToSignatur($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SignaturEnum::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\SignaturEnum', is_array($item) ? implode(', ', $item) : var_export($item, true), implode(', ', \EnumType\SignaturEnum::getValidValues())), __LINE__);
        }
        $this->signatur[] = $item;
        return $this;
    }
    /**
     * Get anreisetyp value
     * @return \StructType\Anreisetyp|null
     */
    public function getAnreisetyp()
    {
        return isset($this->anreisetyp) ? $this->anreisetyp : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAnreisetyp method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAnreisetyp method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAnreisetypForChoiceConstraintsFromSetAnreisetyp($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'aufenthaltsmotiv',
            'gast',
            'gastart',
            'hobby',
            'landschl',
            'resonanz',
            'aufenthaltsmotiv',
            'gast',
            'gastart',
            'hobby',
            'landschl',
            'resonanz',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property anreisetyp can\'t be set as the property %s is already set. Only one property must be set among these properties: anreisetyp, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set anreisetyp value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Anreisetyp $anreisetyp
     * @return \StructType\Meldeblatt
     */
    public function setAnreisetyp(\StructType\Anreisetyp $anreisetyp = null)
    {
        // validation for constraint: choice(anreisetyp, aufenthaltsmotiv, gast, gastart, hobby, landschl, resonanz, anreisetyp, aufenthaltsmotiv, gast, gastart, hobby, landschl, resonanz)
        if ('' !== ($anreisetypChoiceErrorMessage = self::validateAnreisetypForChoiceConstraintsFromSetAnreisetyp($anreisetyp))) {
            throw new \InvalidArgumentException($anreisetypChoiceErrorMessage, __LINE__);
        }
        if (is_null($anreisetyp) || (is_array($anreisetyp) && empty($anreisetyp))) {
            unset($this->anreisetyp);
        } else {
            $this->anreisetyp = $anreisetyp;
        }
        return $this;
    }
    /**
     * Get aufenthaltsmotiv value
     * @return \StructType\Aufenthaltsmotiv|null
     */
    public function getAufenthaltsmotiv()
    {
        return isset($this->aufenthaltsmotiv) ? $this->aufenthaltsmotiv : null;
    }
    /**
     * This method is responsible for validating the value passed to the setAufenthaltsmotiv method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAufenthaltsmotiv method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateAufenthaltsmotivForChoiceConstraintsFromSetAufenthaltsmotiv($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'anreisetyp',
            'gast',
            'gastart',
            'hobby',
            'landschl',
            'resonanz',
            'anreisetyp',
            'gast',
            'gastart',
            'hobby',
            'landschl',
            'resonanz',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property aufenthaltsmotiv can\'t be set as the property %s is already set. Only one property must be set among these properties: aufenthaltsmotiv, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set aufenthaltsmotiv value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Aufenthaltsmotiv $aufenthaltsmotiv
     * @return \StructType\Meldeblatt
     */
    public function setAufenthaltsmotiv(\StructType\Aufenthaltsmotiv $aufenthaltsmotiv = null)
    {
        // validation for constraint: choice(anreisetyp, aufenthaltsmotiv, gast, gastart, hobby, landschl, resonanz, anreisetyp, aufenthaltsmotiv, gast, gastart, hobby, landschl, resonanz)
        if ('' !== ($aufenthaltsmotivChoiceErrorMessage = self::validateAufenthaltsmotivForChoiceConstraintsFromSetAufenthaltsmotiv($aufenthaltsmotiv))) {
            throw new \InvalidArgumentException($aufenthaltsmotivChoiceErrorMessage, __LINE__);
        }
        if (is_null($aufenthaltsmotiv) || (is_array($aufenthaltsmotiv) && empty($aufenthaltsmotiv))) {
            unset($this->aufenthaltsmotiv);
        } else {
            $this->aufenthaltsmotiv = $aufenthaltsmotiv;
        }
        return $this;
    }
    /**
     * Get gast value
     * @return \StructType\Gast|null
     */
    public function getGast()
    {
        return isset($this->gast) ? $this->gast : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGast method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGast method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGastForChoiceConstraintsFromSetGast($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'anreisetyp',
            'aufenthaltsmotiv',
            'gastart',
            'hobby',
            'landschl',
            'resonanz',
            'anreisetyp',
            'aufenthaltsmotiv',
            'gastart',
            'hobby',
            'landschl',
            'resonanz',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property gast can\'t be set as the property %s is already set. Only one property must be set among these properties: gast, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set gast value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Gast $gast
     * @return \StructType\Meldeblatt
     */
    public function setGast(\StructType\Gast $gast = null)
    {
        // validation for constraint: choice(anreisetyp, aufenthaltsmotiv, gast, gastart, hobby, landschl, resonanz, anreisetyp, aufenthaltsmotiv, gast, gastart, hobby, landschl, resonanz)
        if ('' !== ($gastChoiceErrorMessage = self::validateGastForChoiceConstraintsFromSetGast($gast))) {
            throw new \InvalidArgumentException($gastChoiceErrorMessage, __LINE__);
        }
        if (is_null($gast) || (is_array($gast) && empty($gast))) {
            unset($this->gast);
        } else {
            $this->gast = $gast;
        }
        return $this;
    }
    /**
     * Get gastart value
     * @return \StructType\Gastart|null
     */
    public function getGastart()
    {
        return isset($this->gastart) ? $this->gastart : null;
    }
    /**
     * This method is responsible for validating the value passed to the setGastart method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGastart method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateGastartForChoiceConstraintsFromSetGastart($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'anreisetyp',
            'aufenthaltsmotiv',
            'gast',
            'hobby',
            'landschl',
            'resonanz',
            'anreisetyp',
            'aufenthaltsmotiv',
            'gast',
            'hobby',
            'landschl',
            'resonanz',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property gastart can\'t be set as the property %s is already set. Only one property must be set among these properties: gastart, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set gastart value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Gastart $gastart
     * @return \StructType\Meldeblatt
     */
    public function setGastart(\StructType\Gastart $gastart = null)
    {
        // validation for constraint: choice(anreisetyp, aufenthaltsmotiv, gast, gastart, hobby, landschl, resonanz, anreisetyp, aufenthaltsmotiv, gast, gastart, hobby, landschl, resonanz)
        if ('' !== ($gastartChoiceErrorMessage = self::validateGastartForChoiceConstraintsFromSetGastart($gastart))) {
            throw new \InvalidArgumentException($gastartChoiceErrorMessage, __LINE__);
        }
        if (is_null($gastart) || (is_array($gastart) && empty($gastart))) {
            unset($this->gastart);
        } else {
            $this->gastart = $gastart;
        }
        return $this;
    }
    /**
     * Get hobby value
     * @return \StructType\Hobby|null
     */
    public function getHobby()
    {
        return isset($this->hobby) ? $this->hobby : null;
    }
    /**
     * This method is responsible for validating the value passed to the setHobby method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHobby method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateHobbyForChoiceConstraintsFromSetHobby($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'anreisetyp',
            'aufenthaltsmotiv',
            'gast',
            'gastart',
            'landschl',
            'resonanz',
            'anreisetyp',
            'aufenthaltsmotiv',
            'gast',
            'gastart',
            'landschl',
            'resonanz',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property hobby can\'t be set as the property %s is already set. Only one property must be set among these properties: hobby, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set hobby value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Hobby $hobby
     * @return \StructType\Meldeblatt
     */
    public function setHobby(\StructType\Hobby $hobby = null)
    {
        // validation for constraint: choice(anreisetyp, aufenthaltsmotiv, gast, gastart, hobby, landschl, resonanz, anreisetyp, aufenthaltsmotiv, gast, gastart, hobby, landschl, resonanz)
        if ('' !== ($hobbyChoiceErrorMessage = self::validateHobbyForChoiceConstraintsFromSetHobby($hobby))) {
            throw new \InvalidArgumentException($hobbyChoiceErrorMessage, __LINE__);
        }
        if (is_null($hobby) || (is_array($hobby) && empty($hobby))) {
            unset($this->hobby);
        } else {
            $this->hobby = $hobby;
        }
        return $this;
    }
    /**
     * Get landschl value
     * @return \StructType\Landschl|null
     */
    public function getLandschl()
    {
        return isset($this->landschl) ? $this->landschl : null;
    }
    /**
     * This method is responsible for validating the value passed to the setLandschl method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLandschl method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateLandschlForChoiceConstraintsFromSetLandschl($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'anreisetyp',
            'aufenthaltsmotiv',
            'gast',
            'gastart',
            'hobby',
            'resonanz',
            'anreisetyp',
            'aufenthaltsmotiv',
            'gast',
            'gastart',
            'hobby',
            'resonanz',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property landschl can\'t be set as the property %s is already set. Only one property must be set among these properties: landschl, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set landschl value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Landschl $landschl
     * @return \StructType\Meldeblatt
     */
    public function setLandschl(\StructType\Landschl $landschl = null)
    {
        // validation for constraint: choice(anreisetyp, aufenthaltsmotiv, gast, gastart, hobby, landschl, resonanz, anreisetyp, aufenthaltsmotiv, gast, gastart, hobby, landschl, resonanz)
        if ('' !== ($landschlChoiceErrorMessage = self::validateLandschlForChoiceConstraintsFromSetLandschl($landschl))) {
            throw new \InvalidArgumentException($landschlChoiceErrorMessage, __LINE__);
        }
        if (is_null($landschl) || (is_array($landschl) && empty($landschl))) {
            unset($this->landschl);
        } else {
            $this->landschl = $landschl;
        }
        return $this;
    }
    /**
     * Get resonanz value
     * @return \StructType\Resonanz|null
     */
    public function getResonanz()
    {
        return isset($this->resonanz) ? $this->resonanz : null;
    }
    /**
     * This method is responsible for validating the value passed to the setResonanz method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResonanz method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateResonanzForChoiceConstraintsFromSetResonanz($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'anreisetyp',
            'aufenthaltsmotiv',
            'gast',
            'gastart',
            'hobby',
            'landschl',
            'anreisetyp',
            'aufenthaltsmotiv',
            'gast',
            'gastart',
            'hobby',
            'landschl',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property resonanz can\'t be set as the property %s is already set. Only one property must be set among these properties: resonanz, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set resonanz value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Resonanz $resonanz
     * @return \StructType\Meldeblatt
     */
    public function setResonanz(\StructType\Resonanz $resonanz = null)
    {
        // validation for constraint: choice(anreisetyp, aufenthaltsmotiv, gast, gastart, hobby, landschl, resonanz, anreisetyp, aufenthaltsmotiv, gast, gastart, hobby, landschl, resonanz)
        if ('' !== ($resonanzChoiceErrorMessage = self::validateResonanzForChoiceConstraintsFromSetResonanz($resonanz))) {
            throw new \InvalidArgumentException($resonanzChoiceErrorMessage, __LINE__);
        }
        if (is_null($resonanz) || (is_array($resonanz) && empty($resonanz))) {
            unset($this->resonanz);
        } else {
            $this->resonanz = $resonanz;
        }
        return $this;
    }
    /**
     * Get mblattnr value
     * @return int|null
     */
    public function getMblattnr()
    {
        return $this->mblattnr;
    }
    /**
     * Set mblattnr value
     * @param int $mblattnr
     * @return \StructType\Meldeblatt
     */
    public function setMblattnr($mblattnr = null)
    {
        // validation for constraint: int
        if (!is_null($mblattnr) && !(is_int($mblattnr) || ctype_digit($mblattnr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mblattnr, true), gettype($mblattnr)), __LINE__);
        }
        $this->mblattnr = $mblattnr;
        return $this;
    }
    /**
     * Get mblattrefnr value
     * @return int|null
     */
    public function getMblattrefnr()
    {
        return $this->mblattrefnr;
    }
    /**
     * Set mblattrefnr value
     * @param int $mblattrefnr
     * @return \StructType\Meldeblatt
     */
    public function setMblattrefnr($mblattrefnr = null)
    {
        // validation for constraint: int
        if (!is_null($mblattrefnr) && !(is_int($mblattrefnr) || ctype_digit($mblattrefnr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mblattrefnr, true), gettype($mblattrefnr)), __LINE__);
        }
        $this->mblattrefnr = $mblattrefnr;
        return $this;
    }
    /**
     * Get bearbeiter value
     * @return string|null
     */
    public function getBearbeiter()
    {
        return $this->bearbeiter;
    }
    /**
     * Set bearbeiter value
     * @param string $bearbeiter
     * @return \StructType\Meldeblatt
     */
    public function setBearbeiter($bearbeiter = null)
    {
        // validation for constraint: string
        if (!is_null($bearbeiter) && !is_string($bearbeiter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bearbeiter, true), gettype($bearbeiter)), __LINE__);
        }
        $this->bearbeiter = $bearbeiter;
        return $this;
    }
    /**
     * Get bemerkung value
     * @return string|null
     */
    public function getBemerkung()
    {
        return $this->bemerkung;
    }
    /**
     * Set bemerkung value
     * @param string $bemerkung
     * @return \StructType\Meldeblatt
     */
    public function setBemerkung($bemerkung = null)
    {
        // validation for constraint: string
        if (!is_null($bemerkung) && !is_string($bemerkung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bemerkung, true), gettype($bemerkung)), __LINE__);
        }
        $this->bemerkung = $bemerkung;
        return $this;
    }
    /**
     * Get aufenthalte value
     * @return int|null
     */
    public function getAufenthalte()
    {
        return $this->aufenthalte;
    }
    /**
     * Set aufenthalte value
     * @param int $aufenthalte
     * @return \StructType\Meldeblatt
     */
    public function setAufenthalte($aufenthalte = null)
    {
        // validation for constraint: int
        if (!is_null($aufenthalte) && !(is_int($aufenthalte) || ctype_digit($aufenthalte))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aufenthalte, true), gettype($aufenthalte)), __LINE__);
        }
        $this->aufenthalte = $aufenthalte;
        return $this;
    }
    /**
     * Get zahlungsart value
     * @return string|null
     */
    public function getZahlungsart()
    {
        return $this->zahlungsart;
    }
    /**
     * Set zahlungsart value
     * @param string $zahlungsart
     * @return \StructType\Meldeblatt
     */
    public function setZahlungsart($zahlungsart = null)
    {
        // validation for constraint: string
        if (!is_null($zahlungsart) && !is_string($zahlungsart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zahlungsart, true), gettype($zahlungsart)), __LINE__);
        }
        $this->zahlungsart = $zahlungsart;
        return $this;
    }
    /**
     * Get abreise value
     * @return string|null
     */
    public function getAbreise()
    {
        return $this->abreise;
    }
    /**
     * Set abreise value
     * @param string $abreise
     * @return \StructType\Meldeblatt
     */
    public function setAbreise($abreise = null)
    {
        // validation for constraint: string
        if (!is_null($abreise) && !is_string($abreise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abreise, true), gettype($abreise)), __LINE__);
        }
        $this->abreise = $abreise;
        return $this;
    }
    /**
     * Get abgeplant value
     * @return string|null
     */
    public function getAbgeplant()
    {
        return $this->abgeplant;
    }
    /**
     * Set abgeplant value
     * @param string $abgeplant
     * @return \StructType\Meldeblatt
     */
    public function setAbgeplant($abgeplant = null)
    {
        // validation for constraint: string
        if (!is_null($abgeplant) && !is_string($abgeplant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($abgeplant, true), gettype($abgeplant)), __LINE__);
        }
        $this->abgeplant = $abgeplant;
        return $this;
    }
    /**
     * Get undef1 value
     * @return string|null
     */
    public function getUndef1()
    {
        return $this->undef1;
    }
    /**
     * Set undef1 value
     * @param string $undef1
     * @return \StructType\Meldeblatt
     */
    public function setUndef1($undef1 = null)
    {
        // validation for constraint: string
        if (!is_null($undef1) && !is_string($undef1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($undef1, true), gettype($undef1)), __LINE__);
        }
        $this->undef1 = $undef1;
        return $this;
    }
    /**
     * Get undef2 value
     * @return string|null
     */
    public function getUndef2()
    {
        return $this->undef2;
    }
    /**
     * Set undef2 value
     * @param string $undef2
     * @return \StructType\Meldeblatt
     */
    public function setUndef2($undef2 = null)
    {
        // validation for constraint: string
        if (!is_null($undef2) && !is_string($undef2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($undef2, true), gettype($undef2)), __LINE__);
        }
        $this->undef2 = $undef2;
        return $this;
    }
    /**
     * Get undef3 value
     * @return string|null
     */
    public function getUndef3()
    {
        return $this->undef3;
    }
    /**
     * Set undef3 value
     * @param string $undef3
     * @return \StructType\Meldeblatt
     */
    public function setUndef3($undef3 = null)
    {
        // validation for constraint: string
        if (!is_null($undef3) && !is_string($undef3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($undef3, true), gettype($undef3)), __LINE__);
        }
        $this->undef3 = $undef3;
        return $this;
    }
    /**
     * Get errornumber value
     * @return int|null
     */
    public function getErrornumber()
    {
        return $this->errornumber;
    }
    /**
     * Set errornumber value
     * @param int $errornumber
     * @return \StructType\Meldeblatt
     */
    public function setErrornumber($errornumber = null)
    {
        // validation for constraint: int
        if (!is_null($errornumber) && !(is_int($errornumber) || ctype_digit($errornumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($errornumber, true), gettype($errornumber)), __LINE__);
        }
        $this->errornumber = $errornumber;
        return $this;
    }
    /**
     * Get errormsg value
     * @return string|null
     */
    public function getErrormsg()
    {
        return $this->errormsg;
    }
    /**
     * Set errormsg value
     * @param string $errormsg
     * @return \StructType\Meldeblatt
     */
    public function setErrormsg($errormsg = null)
    {
        // validation for constraint: string
        if (!is_null($errormsg) && !is_string($errormsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errormsg, true), gettype($errormsg)), __LINE__);
        }
        $this->errormsg = $errormsg;
        return $this;
    }
    /**
     * Get timestamp value
     * @return string|null
     */
    public function getTimestamp()
    {
        return $this->timestamp;
    }
    /**
     * Set timestamp value
     * @param string $timestamp
     * @return \StructType\Meldeblatt
     */
    public function setTimestamp($timestamp = null)
    {
        // validation for constraint: string
        if (!is_null($timestamp) && !is_string($timestamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timestamp, true), gettype($timestamp)), __LINE__);
        }
        $this->timestamp = $timestamp;
        return $this;
    }
    /**
     * Get storno value
     * @return int|null
     */
    public function getStorno()
    {
        return $this->storno;
    }
    /**
     * Set storno value
     * @param int $storno
     * @return \StructType\Meldeblatt
     */
    public function setStorno($storno = null)
    {
        // validation for constraint: int
        if (!is_null($storno) && !(is_int($storno) || ctype_digit($storno))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($storno, true), gettype($storno)), __LINE__);
        }
        $this->storno = $storno;
        return $this;
    }
    /**
     * Get mguid value
     * @return string|null
     */
    public function getMguid()
    {
        return $this->mguid;
    }
    /**
     * Set mguid value
     * @param string $mguid
     * @return \StructType\Meldeblatt
     */
    public function setMguid($mguid = null)
    {
        // validation for constraint: string
        if (!is_null($mguid) && !is_string($mguid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mguid, true), gettype($mguid)), __LINE__);
        }
        $this->mguid = $mguid;
        return $this;
    }
    /**
     * Get guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \StructType\Meldeblatt
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guid, true), gettype($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Get abgereist value
     * @return int|null
     */
    public function getAbgereist()
    {
        return $this->abgereist;
    }
    /**
     * Set abgereist value
     * @param int $abgereist
     * @return \StructType\Meldeblatt
     */
    public function setAbgereist($abgereist = null)
    {
        // validation for constraint: int
        if (!is_null($abgereist) && !(is_int($abgereist) || ctype_digit($abgereist))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($abgereist, true), gettype($abgereist)), __LINE__);
        }
        $this->abgereist = $abgereist;
        return $this;
    }
    /**
     * Get reservierung value
     * @return string|null
     */
    public function getReservierung()
    {
        return $this->reservierung;
    }
    /**
     * Set reservierung value
     * @param string $reservierung
     * @return \StructType\Meldeblatt
     */
    public function setReservierung($reservierung = null)
    {
        // validation for constraint: string
        if (!is_null($reservierung) && !is_string($reservierung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reservierung, true), gettype($reservierung)), __LINE__);
        }
        $this->reservierung = $reservierung;
        return $this;
    }
    /**
     * Get kontaktverfolgung value
     * @return int|null
     */
    public function getKontaktverfolgung()
    {
        return $this->kontaktverfolgung;
    }
    /**
     * Set kontaktverfolgung value
     * @param int $kontaktverfolgung
     * @return \StructType\Meldeblatt
     */
    public function setKontaktverfolgung($kontaktverfolgung = 0)
    {
        // validation for constraint: int
        if (!is_null($kontaktverfolgung) && !(is_int($kontaktverfolgung) || ctype_digit($kontaktverfolgung))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($kontaktverfolgung, true), gettype($kontaktverfolgung)), __LINE__);
        }
        $this->kontaktverfolgung = $kontaktverfolgung;
        return $this;
    }
    /**
     * Get kfz value
     * @return string|null
     */
    public function getKfz()
    {
        return $this->kfz;
    }
    /**
     * Set kfz value
     * @param string $kfz
     * @return \StructType\Meldeblatt
     */
    public function setKfz($kfz = null)
    {
        // validation for constraint: string
        if (!is_null($kfz) && !is_string($kfz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kfz, true), gettype($kfz)), __LINE__);
        }
        $this->kfz = $kfz;
        return $this;
    }
    /**
     * Get ankunftszeitvon value
     * @return string|null
     */
    public function getAnkunftszeitvon()
    {
        return $this->ankunftszeitvon;
    }
    /**
     * Set ankunftszeitvon value
     * @param string $ankunftszeitvon
     * @return \StructType\Meldeblatt
     */
    public function setAnkunftszeitvon($ankunftszeitvon = null)
    {
        // validation for constraint: string
        if (!is_null($ankunftszeitvon) && !is_string($ankunftszeitvon)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ankunftszeitvon, true), gettype($ankunftszeitvon)), __LINE__);
        }
        $this->ankunftszeitvon = $ankunftszeitvon;
        return $this;
    }
    /**
     * Get ankunftszeitbis value
     * @return string|null
     */
    public function getAnkunftszeitbis()
    {
        return $this->ankunftszeitbis;
    }
    /**
     * Set ankunftszeitbis value
     * @param string $ankunftszeitbis
     * @return \StructType\Meldeblatt
     */
    public function setAnkunftszeitbis($ankunftszeitbis = null)
    {
        // validation for constraint: string
        if (!is_null($ankunftszeitbis) && !is_string($ankunftszeitbis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ankunftszeitbis, true), gettype($ankunftszeitbis)), __LINE__);
        }
        $this->ankunftszeitbis = $ankunftszeitbis;
        return $this;
    }
}
