<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for hobby StructType
 * @subpackage Structs
 */
class Hobby extends AbstractStructBase
{
    /**
     * The hobby
     * @var string
     */
    public $hobby;
    /**
     * Constructor method for hobby
     * @uses Hobby::setHobby()
     * @param string $hobby
     */
    public function __construct($hobby = null)
    {
        $this
            ->setHobby($hobby);
    }
    /**
     * Get hobby value
     * @return string|null
     */
    public function getHobby()
    {
        return $this->hobby;
    }
    /**
     * Set hobby value
     * @param string $hobby
     * @return \StructType\Hobby
     */
    public function setHobby($hobby = null)
    {
        // validation for constraint: string
        if (!is_null($hobby) && !is_string($hobby)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hobby, true), gettype($hobby)), __LINE__);
        }
        $this->hobby = $hobby;
        return $this;
    }
}
