<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVTInfoResult StructType
 * @subpackage Structs
 */
class GetVTInfoResult extends AbstractStructBase
{
    /**
     * The version
     * Meta information extracted from the WSDL
     * - use: required
     * @var float
     */
    public $version;
    /**
     * The betrieb
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Betrieb[]
     */
    public $betrieb;
    /**
     * The gguid
     * @var string
     */
    public $gguid;
    /**
     * The oestat
     * @var string
     */
    public $oestat;
    /**
     * The source
     * @var int
     */
    public $source;
    /**
     * The feratelext_mcnummer
     * @var string
     */
    public $feratelext_mcnummer;
    /**
     * Constructor method for GetVTInfoResult
     * @uses GetVTInfoResult::setVersion()
     * @uses GetVTInfoResult::setBetrieb()
     * @uses GetVTInfoResult::setGguid()
     * @uses GetVTInfoResult::setOestat()
     * @uses GetVTInfoResult::setSource()
     * @uses GetVTInfoResult::setFeratelext_mcnummer()
     * @param float $version
     * @param \StructType\Betrieb[] $betrieb
     * @param string $gguid
     * @param string $oestat
     * @param int $source
     * @param string $feratelext_mcnummer
     */
    public function __construct($version = null, array $betrieb = array(), $gguid = null, $oestat = null, $source = null, $feratelext_mcnummer = null)
    {
        $this
            ->setVersion($version)
            ->setBetrieb($betrieb)
            ->setGguid($gguid)
            ->setOestat($oestat)
            ->setSource($source)
            ->setFeratelext_mcnummer($feratelext_mcnummer);
    }
    /**
     * Get version value
     * @return float
     */
    public function getVersion()
    {
        return $this->version;
    }
    /**
     * Set version value
     * @param float $version
     * @return \StructType\GetVTInfoResult
     */
    public function setVersion($version = null)
    {
        // validation for constraint: float
        if (!is_null($version) && !(is_float($version) || is_numeric($version))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->version = $version;
        return $this;
    }
    /**
     * Get betrieb value
     * @return \StructType\Betrieb[]|null
     */
    public function getBetrieb()
    {
        return $this->betrieb;
    }
    /**
     * This method is responsible for validating the values passed to the setBetrieb method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBetrieb method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBetriebForArrayConstraintsFromSetBetrieb(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $getVTInfoResultBetriebItem) {
            // validation for constraint: itemType
            if (!$getVTInfoResultBetriebItem instanceof \StructType\Betrieb) {
                $invalidValues[] = is_object($getVTInfoResultBetriebItem) ? get_class($getVTInfoResultBetriebItem) : sprintf('%s(%s)', gettype($getVTInfoResultBetriebItem), var_export($getVTInfoResultBetriebItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The betrieb property can only contain items of type \StructType\Betrieb, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set betrieb value
     * @throws \InvalidArgumentException
     * @param \StructType\Betrieb[] $betrieb
     * @return \StructType\GetVTInfoResult
     */
    public function setBetrieb(array $betrieb = array())
    {
        // validation for constraint: array
        if ('' !== ($betriebArrayErrorMessage = self::validateBetriebForArrayConstraintsFromSetBetrieb($betrieb))) {
            throw new \InvalidArgumentException($betriebArrayErrorMessage, __LINE__);
        }
        $this->betrieb = $betrieb;
        return $this;
    }
    /**
     * Add item to betrieb value
     * @throws \InvalidArgumentException
     * @param \StructType\Betrieb $item
     * @return \StructType\GetVTInfoResult
     */
    public function addToBetrieb(\StructType\Betrieb $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Betrieb) {
            throw new \InvalidArgumentException(sprintf('The betrieb property can only contain items of type \StructType\Betrieb, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->betrieb[] = $item;
        return $this;
    }
    /**
     * Get gguid value
     * @return string|null
     */
    public function getGguid()
    {
        return $this->gguid;
    }
    /**
     * Set gguid value
     * @param string $gguid
     * @return \StructType\GetVTInfoResult
     */
    public function setGguid($gguid = null)
    {
        // validation for constraint: string
        if (!is_null($gguid) && !is_string($gguid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gguid, true), gettype($gguid)), __LINE__);
        }
        $this->gguid = $gguid;
        return $this;
    }
    /**
     * Get oestat value
     * @return string|null
     */
    public function getOestat()
    {
        return $this->oestat;
    }
    /**
     * Set oestat value
     * @param string $oestat
     * @return \StructType\GetVTInfoResult
     */
    public function setOestat($oestat = null)
    {
        // validation for constraint: string
        if (!is_null($oestat) && !is_string($oestat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oestat, true), gettype($oestat)), __LINE__);
        }
        $this->oestat = $oestat;
        return $this;
    }
    /**
     * Get source value
     * @return int|null
     */
    public function getSource()
    {
        return $this->source;
    }
    /**
     * Set source value
     * @param int $source
     * @return \StructType\GetVTInfoResult
     */
    public function setSource($source = null)
    {
        // validation for constraint: int
        if (!is_null($source) && !(is_int($source) || ctype_digit($source))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->source = $source;
        return $this;
    }
    /**
     * Get feratelext_mcnummer value
     * @return string|null
     */
    public function getFeratelext_mcnummer()
    {
        return $this->feratelext_mcnummer;
    }
    /**
     * Set feratelext_mcnummer value
     * @param string $feratelext_mcnummer
     * @return \StructType\GetVTInfoResult
     */
    public function setFeratelext_mcnummer($feratelext_mcnummer = null)
    {
        // validation for constraint: string
        if (!is_null($feratelext_mcnummer) && !is_string($feratelext_mcnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feratelext_mcnummer, true), gettype($feratelext_mcnummer)), __LINE__);
        }
        $this->feratelext_mcnummer = $feratelext_mcnummer;
        return $this;
    }
}
