<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for gastart StructType
 * @subpackage Structs
 */
class Gastart extends AbstractStructBase
{
    /**
     * The altervon
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $altervon;
    /**
     * The alterbis
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $alterbis;
    /**
     * The order
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $order;
    /**
     * The anzpers
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $anzpers;
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The gastart
     * @var string
     */
    public $gastart;
    /**
     * The feratelext_nights
     * Meta information extracted from the WSDL
     * - default: 0
     * @var int
     */
    public $feratelext_nights;
    /**
     * Constructor method for gastart
     * @uses Gastart::setAltervon()
     * @uses Gastart::setAlterbis()
     * @uses Gastart::setOrder()
     * @uses Gastart::setAnzpers()
     * @uses Gastart::setCode()
     * @uses Gastart::setName()
     * @uses Gastart::setGastart()
     * @uses Gastart::setFeratelext_nights()
     * @param int $altervon
     * @param int $alterbis
     * @param int $order
     * @param int $anzpers
     * @param string $code
     * @param string $name
     * @param string $gastart
     * @param int $feratelext_nights
     */
    public function __construct($altervon = null, $alterbis = null, $order = null, $anzpers = null, $code = null, $name = null, $gastart = null, $feratelext_nights = 0)
    {
        $this
            ->setAltervon($altervon)
            ->setAlterbis($alterbis)
            ->setOrder($order)
            ->setAnzpers($anzpers)
            ->setCode($code)
            ->setName($name)
            ->setGastart($gastart)
            ->setFeratelext_nights($feratelext_nights);
    }
    /**
     * Get altervon value
     * @return int
     */
    public function getAltervon()
    {
        return $this->altervon;
    }
    /**
     * Set altervon value
     * @param int $altervon
     * @return \StructType\Gastart
     */
    public function setAltervon($altervon = null)
    {
        // validation for constraint: int
        if (!is_null($altervon) && !(is_int($altervon) || ctype_digit($altervon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($altervon, true), gettype($altervon)), __LINE__);
        }
        $this->altervon = $altervon;
        return $this;
    }
    /**
     * Get alterbis value
     * @return int
     */
    public function getAlterbis()
    {
        return $this->alterbis;
    }
    /**
     * Set alterbis value
     * @param int $alterbis
     * @return \StructType\Gastart
     */
    public function setAlterbis($alterbis = null)
    {
        // validation for constraint: int
        if (!is_null($alterbis) && !(is_int($alterbis) || ctype_digit($alterbis))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alterbis, true), gettype($alterbis)), __LINE__);
        }
        $this->alterbis = $alterbis;
        return $this;
    }
    /**
     * Get order value
     * @return int
     */
    public function getOrder()
    {
        return $this->order;
    }
    /**
     * Set order value
     * @param int $order
     * @return \StructType\Gastart
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        $this->order = $order;
        return $this;
    }
    /**
     * Get anzpers value
     * @return int
     */
    public function getAnzpers()
    {
        return $this->anzpers;
    }
    /**
     * Set anzpers value
     * @param int $anzpers
     * @return \StructType\Gastart
     */
    public function setAnzpers($anzpers = null)
    {
        // validation for constraint: int
        if (!is_null($anzpers) && !(is_int($anzpers) || ctype_digit($anzpers))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzpers, true), gettype($anzpers)), __LINE__);
        }
        $this->anzpers = $anzpers;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\Gastart
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Gastart
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get gastart value
     * @return string|null
     */
    public function getGastart()
    {
        return $this->gastart;
    }
    /**
     * Set gastart value
     * @param string $gastart
     * @return \StructType\Gastart
     */
    public function setGastart($gastart = null)
    {
        // validation for constraint: string
        if (!is_null($gastart) && !is_string($gastart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gastart, true), gettype($gastart)), __LINE__);
        }
        $this->gastart = $gastart;
        return $this;
    }
    /**
     * Get feratelext_nights value
     * @return int|null
     */
    public function getFeratelext_nights()
    {
        return $this->feratelext_nights;
    }
    /**
     * Set feratelext_nights value
     * @param int $feratelext_nights
     * @return \StructType\Gastart
     */
    public function setFeratelext_nights($feratelext_nights = 0)
    {
        // validation for constraint: int
        if (!is_null($feratelext_nights) && !(is_int($feratelext_nights) || ctype_digit($feratelext_nights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($feratelext_nights, true), gettype($feratelext_nights)), __LINE__);
        }
        $this->feratelext_nights = $feratelext_nights;
        return $this;
    }
}
