<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeratelDsiRS StructType
 * @subpackage Structs
 */
class FeratelDsiRS extends AbstractStructBase
{
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Status;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ResponseType[]
     */
    public $Result;
    /**
     * The Message
     * @var string
     */
    public $Message;
    /**
     * Constructor method for FeratelDsiRS
     * @uses FeratelDsiRS::setStatus()
     * @uses FeratelDsiRS::setResult()
     * @uses FeratelDsiRS::setMessage()
     * @param int $status
     * @param \StructType\ResponseType[] $result
     * @param string $message
     */
    public function __construct($status = null, array $result = array(), $message = null)
    {
        $this
            ->setStatus($status)
            ->setResult($result)
            ->setMessage($message);
    }
    /**
     * Get Status value
     * @return int
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param int $status
     * @return \StructType\FeratelDsiRS
     */
    public function setStatus($status = null)
    {
        // validation for constraint: int
        if (!is_null($status) && !(is_int($status) || ctype_digit($status))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Result value
     * @return \StructType\ResponseType[]|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * This method is responsible for validating the values passed to the setResult method
     * This method is willingly generated in order to preserve the one-line inline validation within the setResult method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateResultForArrayConstraintsFromSetResult(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $feratelDsiRSResultItem) {
            // validation for constraint: itemType
            if (!$feratelDsiRSResultItem instanceof \StructType\ResponseType) {
                $invalidValues[] = is_object($feratelDsiRSResultItem) ? get_class($feratelDsiRSResultItem) : sprintf('%s(%s)', gettype($feratelDsiRSResultItem), var_export($feratelDsiRSResultItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Result property can only contain items of type \StructType\ResponseType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Result value
     * @throws \InvalidArgumentException
     * @param \StructType\ResponseType[] $result
     * @return \StructType\FeratelDsiRS
     */
    public function setResult(array $result = array())
    {
        // validation for constraint: array
        if ('' !== ($resultArrayErrorMessage = self::validateResultForArrayConstraintsFromSetResult($result))) {
            throw new \InvalidArgumentException($resultArrayErrorMessage, __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
    /**
     * Add item to Result value
     * @throws \InvalidArgumentException
     * @param \StructType\ResponseType $item
     * @return \StructType\FeratelDsiRS
     */
    public function addToResult(\StructType\ResponseType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ResponseType) {
            throw new \InvalidArgumentException(sprintf('The Result property can only contain items of type \StructType\ResponseType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Result[] = $item;
        return $this;
    }
    /**
     * Get Message value
     * @return string|null
     */
    public function getMessage()
    {
        return $this->Message;
    }
    /**
     * Set Message value
     * @param string $message
     * @return \StructType\FeratelDsiRS
     */
    public function setMessage($message = null)
    {
        // validation for constraint: string
        if (!is_null($message) && !is_string($message)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($message, true), gettype($message)), __LINE__);
        }
        $this->Message = $message;
        return $this;
    }
}
