<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for error StructType
 * @subpackage Structs
 */
class Error extends AbstractStructBase
{
    /**
     * The code
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $code;
    /**
     * The mblattnr
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $mblattnr;
    /**
     * The oestat
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $oestat;
    /**
     * The betriebnr
     * @var string
     */
    public $betriebnr;
    /**
     * The guid
     * @var string
     */
    public $guid;
    /**
     * The lfdnr
     * @var int
     */
    public $lfdnr;
    /**
     * The text
     * @var string
     */
    public $text;
    /**
     * The uvmnr
     * @var string
     */
    public $uvmnr;
    /**
     * Constructor method for error
     * @uses Error::setCode()
     * @uses Error::setMblattnr()
     * @uses Error::setOestat()
     * @uses Error::setBetriebnr()
     * @uses Error::setGuid()
     * @uses Error::setLfdnr()
     * @uses Error::setText()
     * @uses Error::setUvmnr()
     * @param int $code
     * @param int $mblattnr
     * @param int $oestat
     * @param string $betriebnr
     * @param string $guid
     * @param int $lfdnr
     * @param string $text
     * @param string $uvmnr
     */
    public function __construct($code = null, $mblattnr = null, $oestat = null, $betriebnr = null, $guid = null, $lfdnr = null, $text = null, $uvmnr = null)
    {
        $this
            ->setCode($code)
            ->setMblattnr($mblattnr)
            ->setOestat($oestat)
            ->setBetriebnr($betriebnr)
            ->setGuid($guid)
            ->setLfdnr($lfdnr)
            ->setText($text)
            ->setUvmnr($uvmnr);
    }
    /**
     * Get code value
     * @return int
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param int $code
     * @return \StructType\Error
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get mblattnr value
     * @return int
     */
    public function getMblattnr()
    {
        return $this->mblattnr;
    }
    /**
     * Set mblattnr value
     * @param int $mblattnr
     * @return \StructType\Error
     */
    public function setMblattnr($mblattnr = null)
    {
        // validation for constraint: int
        if (!is_null($mblattnr) && !(is_int($mblattnr) || ctype_digit($mblattnr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mblattnr, true), gettype($mblattnr)), __LINE__);
        }
        $this->mblattnr = $mblattnr;
        return $this;
    }
    /**
     * Get oestat value
     * @return int
     */
    public function getOestat()
    {
        return $this->oestat;
    }
    /**
     * Set oestat value
     * @param int $oestat
     * @return \StructType\Error
     */
    public function setOestat($oestat = null)
    {
        // validation for constraint: int
        if (!is_null($oestat) && !(is_int($oestat) || ctype_digit($oestat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($oestat, true), gettype($oestat)), __LINE__);
        }
        $this->oestat = $oestat;
        return $this;
    }
    /**
     * Get betriebnr value
     * @return string|null
     */
    public function getBetriebnr()
    {
        return $this->betriebnr;
    }
    /**
     * Set betriebnr value
     * @param string $betriebnr
     * @return \StructType\Error
     */
    public function setBetriebnr($betriebnr = null)
    {
        // validation for constraint: string
        if (!is_null($betriebnr) && !is_string($betriebnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($betriebnr, true), gettype($betriebnr)), __LINE__);
        }
        $this->betriebnr = $betriebnr;
        return $this;
    }
    /**
     * Get guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \StructType\Error
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guid, true), gettype($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Get lfdnr value
     * @return int|null
     */
    public function getLfdnr()
    {
        return $this->lfdnr;
    }
    /**
     * Set lfdnr value
     * @param int $lfdnr
     * @return \StructType\Error
     */
    public function setLfdnr($lfdnr = null)
    {
        // validation for constraint: int
        if (!is_null($lfdnr) && !(is_int($lfdnr) || ctype_digit($lfdnr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lfdnr, true), gettype($lfdnr)), __LINE__);
        }
        $this->lfdnr = $lfdnr;
        return $this;
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\Error
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($text, true), gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Get uvmnr value
     * @return string|null
     */
    public function getUvmnr()
    {
        return $this->uvmnr;
    }
    /**
     * Set uvmnr value
     * @param string $uvmnr
     * @return \StructType\Error
     */
    public function setUvmnr($uvmnr = null)
    {
        // validation for constraint: string
        if (!is_null($uvmnr) && !is_string($uvmnr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uvmnr, true), gettype($uvmnr)), __LINE__);
        }
        $this->uvmnr = $uvmnr;
        return $this;
    }
}
