<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommunityType StructType
 * @subpackage Structs
 */
class CommunityType extends AbstractStructBase
{
    /**
     * The Number
     * Meta information extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Number;
    /**
     * The ServiceProviders
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfServiceProviderType
     */
    public $ServiceProviders;
    /**
     * The PersonGroups
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfPersonGroupType
     */
    public $PersonGroups;
    /**
     * The ID
     * @var string
     */
    public $ID;
    /**
     * The Name
     * @var string
     */
    public $Name;
    /**
     * Constructor method for CommunityType
     * @uses CommunityType::setNumber()
     * @uses CommunityType::setServiceProviders()
     * @uses CommunityType::setPersonGroups()
     * @uses CommunityType::setID()
     * @uses CommunityType::setName()
     * @param int $number
     * @param \ArrayType\ArrayOfServiceProviderType $serviceProviders
     * @param \ArrayType\ArrayOfPersonGroupType $personGroups
     * @param string $iD
     * @param string $name
     */
    public function __construct($number = null, \ArrayType\ArrayOfServiceProviderType $serviceProviders = null, \ArrayType\ArrayOfPersonGroupType $personGroups = null, $iD = null, $name = null)
    {
        $this
            ->setNumber($number)
            ->setServiceProviders($serviceProviders)
            ->setPersonGroups($personGroups)
            ->setID($iD)
            ->setName($name);
    }
    /**
     * Get Number value
     * @return int
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param int $number
     * @return \StructType\CommunityType
     */
    public function setNumber($number = null)
    {
        // validation for constraint: int
        if (!is_null($number) && !(is_int($number) || ctype_digit($number))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($number, true), gettype($number)), __LINE__);
        }
        $this->Number = $number;
        return $this;
    }
    /**
     * Get ServiceProviders value
     * @return \ArrayType\ArrayOfServiceProviderType|null
     */
    public function getServiceProviders()
    {
        return $this->ServiceProviders;
    }
    /**
     * Set ServiceProviders value
     * @param \ArrayType\ArrayOfServiceProviderType $serviceProviders
     * @return \StructType\CommunityType
     */
    public function setServiceProviders(\ArrayType\ArrayOfServiceProviderType $serviceProviders = null)
    {
        $this->ServiceProviders = $serviceProviders;
        return $this;
    }
    /**
     * Get PersonGroups value
     * @return \ArrayType\ArrayOfPersonGroupType|null
     */
    public function getPersonGroups()
    {
        return $this->PersonGroups;
    }
    /**
     * Set PersonGroups value
     * @param \ArrayType\ArrayOfPersonGroupType $personGroups
     * @return \StructType\CommunityType
     */
    public function setPersonGroups(\ArrayType\ArrayOfPersonGroupType $personGroups = null)
    {
        $this->PersonGroups = $personGroups;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\CommunityType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CommunityType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
}
