<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for card StructType
 * @subpackage Structs
 */
class Card extends AbstractStructBase
{
    /**
     * The link
     * @var string
     */
    public $link;
    /**
     * The mandant
     * @var string
     */
    public $mandant;
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * Constructor method for card
     * @uses Card::setLink()
     * @uses Card::setMandant()
     * @uses Card::setName()
     * @param string $link
     * @param string $mandant
     * @param string $name
     */
    public function __construct($link = null, $mandant = null, $name = null)
    {
        $this
            ->setLink($link)
            ->setMandant($mandant)
            ->setName($name);
    }
    /**
     * Get link value
     * @return string|null
     */
    public function getLink()
    {
        return $this->link;
    }
    /**
     * Set link value
     * @param string $link
     * @return \StructType\Card
     */
    public function setLink($link = null)
    {
        // validation for constraint: string
        if (!is_null($link) && !is_string($link)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($link, true), gettype($link)), __LINE__);
        }
        $this->link = $link;
        return $this;
    }
    /**
     * Get mandant value
     * @return string|null
     */
    public function getMandant()
    {
        return $this->mandant;
    }
    /**
     * Set mandant value
     * @param string $mandant
     * @return \StructType\Card
     */
    public function setMandant($mandant = null)
    {
        // validation for constraint: string
        if (!is_null($mandant) && !is_string($mandant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandant, true), gettype($mandant)), __LINE__);
        }
        $this->mandant = $mandant;
        return $this;
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Card
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
}
