<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for answer StructType
 * @subpackage Structs
 */
class Answer extends AbstractStructBase
{
    /**
     * The error
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Error[]
     */
    public $error;
    /**
     * The warnung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Warnung
     */
    public $warnung;
    /**
     * Constructor method for answer
     * @uses Answer::setError()
     * @uses Answer::setWarnung()
     * @param \StructType\Error[] $error
     * @param \StructType\Warnung $warnung
     */
    public function __construct(array $error = array(), \StructType\Warnung $warnung = null)
    {
        $this
            ->setError($error)
            ->setWarnung($warnung);
    }
    /**
     * Get error value
     * @return \StructType\Error[]|null
     */
    public function getError()
    {
        return $this->error;
    }
    /**
     * This method is responsible for validating the values passed to the setError method
     * This method is willingly generated in order to preserve the one-line inline validation within the setError method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateErrorForArrayConstraintsFromSetError(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $answerErrorItem) {
            // validation for constraint: itemType
            if (!$answerErrorItem instanceof \StructType\Error) {
                $invalidValues[] = is_object($answerErrorItem) ? get_class($answerErrorItem) : sprintf('%s(%s)', gettype($answerErrorItem), var_export($answerErrorItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The error property can only contain items of type \StructType\Error, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set error value
     * @throws \InvalidArgumentException
     * @param \StructType\Error[] $error
     * @return \StructType\Answer
     */
    public function setError(array $error = array())
    {
        // validation for constraint: array
        if ('' !== ($errorArrayErrorMessage = self::validateErrorForArrayConstraintsFromSetError($error))) {
            throw new \InvalidArgumentException($errorArrayErrorMessage, __LINE__);
        }
        $this->error = $error;
        return $this;
    }
    /**
     * Add item to error value
     * @throws \InvalidArgumentException
     * @param \StructType\Error $item
     * @return \StructType\Answer
     */
    public function addToError(\StructType\Error $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Error) {
            throw new \InvalidArgumentException(sprintf('The error property can only contain items of type \StructType\Error, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->error[] = $item;
        return $this;
    }
    /**
     * Get warnung value
     * @return \StructType\Warnung|null
     */
    public function getWarnung()
    {
        return $this->warnung;
    }
    /**
     * Set warnung value
     * @param \StructType\Warnung $warnung
     * @return \StructType\Answer
     */
    public function setWarnung(\StructType\Warnung $warnung = null)
    {
        $this->warnung = $warnung;
        return $this;
    }
}
