<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reset ServiceType
 * @subpackage Services
 */
class Reset extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ResetVRTransfer
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ResetVRTransfer $parameters
     * @return \StructType\ResetVRTransferResponse|bool
     */
    public function ResetVRTransfer(\StructType\ResetVRTransfer $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ResetVRTransfer($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ResetVRTransferResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
