<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Re ServiceType
 * @subpackage Services
 */
class Re extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReProcessOfImportErrorsWithTimeout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReProcessOfImportErrorsWithTimeout $parameters
     * @return \StructType\ReProcessOfImportErrorsWithTimeoutResponse|bool
     */
    public function ReProcessOfImportErrorsWithTimeout(\StructType\ReProcessOfImportErrorsWithTimeout $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReProcessOfImportErrorsWithTimeout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ReProcessOfImportErrors
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReProcessOfImportErrors $parameters
     * @return \StructType\ReProcessOfImportErrorsResponse|bool
     */
    public function ReProcessOfImportErrors(\StructType\ReProcessOfImportErrors $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ReProcessOfImportErrors($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReProcessOfImportErrorsResponse|\StructType\ReProcessOfImportErrorsWithTimeoutResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
