<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Process ServiceType
 * @subpackage Services
 */
class Process extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ProcessInsertedData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessInsertedData $parameters
     * @return \StructType\ProcessInsertedDataResponse|bool
     */
    public function ProcessInsertedData(\StructType\ProcessInsertedData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessInsertedData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessInsertedVRData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessInsertedVRData $parameters
     * @return \StructType\ProcessInsertedVRDataResponse|bool
     */
    public function ProcessInsertedVRData(\StructType\ProcessInsertedVRData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessInsertedVRData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessOfVRImportErrors
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessOfVRImportErrors $parameters
     * @return \StructType\ProcessOfVRImportErrorsResponse|bool
     */
    public function ProcessOfVRImportErrors(\StructType\ProcessOfVRImportErrors $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessOfVRImportErrors($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessOfVRImportError
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessOfVRImportError $parameters
     * @return \StructType\ProcessOfVRImportErrorResponse|bool
     */
    public function ProcessOfVRImportError(\StructType\ProcessOfVRImportError $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessOfVRImportError($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessXMLImportEntry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessXMLImportEntry $parameters
     * @return \StructType\ProcessXMLImportEntryResponse|bool
     */
    public function ProcessXMLImportEntry(\StructType\ProcessXMLImportEntry $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessXMLImportEntry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessInsertedScannerData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessInsertedScannerData $parameters
     * @return \StructType\ProcessInsertedScannerDataResponse|bool
     */
    public function ProcessInsertedScannerData(\StructType\ProcessInsertedScannerData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessInsertedScannerData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessInsertedVT_KWTData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessInsertedVT_KWTData $parameters
     * @return \StructType\ProcessInsertedVT_KWTDataResponse|bool
     */
    public function ProcessInsertedVT_KWTData(\StructType\ProcessInsertedVT_KWTData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessInsertedVT_KWTData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ProcessOfInternalInsertedXMLImport
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ProcessOfInternalInsertedXMLImport $parameters
     * @return \StructType\ProcessOfInternalInsertedXMLImportResponse|bool
     */
    public function ProcessOfInternalInsertedXMLImport(\StructType\ProcessOfInternalInsertedXMLImport $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ProcessOfInternalInsertedXMLImport($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ProcessInsertedDataResponse|\StructType\ProcessInsertedScannerDataResponse|\StructType\ProcessInsertedVRDataResponse|\StructType\ProcessInsertedVT_KWTDataResponse|\StructType\ProcessOfInternalInsertedXMLImportResponse|\StructType\ProcessOfVRImportErrorResponse|\StructType\ProcessOfVRImportErrorsResponse|\StructType\ProcessXMLImportEntryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
