<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for PMSA ServiceType
 * @subpackage Services
 */
class PMSA extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PMSAutoAssignVTBlock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PMSAutoAssignVTBlock $parameters
     * @return \StructType\PMSAutoAssignVTBlockResponse|bool
     */
    public function PMSAutoAssignVTBlock(\StructType\PMSAutoAssignVTBlock $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->PMSAutoAssignVTBlock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PMSAutoAssignVTBlockResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
