<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for VTBlockStatusEnum EnumType
 * @subpackage Enumerations
 */
class VTBlockStatusEnum extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'NotAssigned'
     * @return string 'NotAssigned'
     */
    const VALUE_NOT_ASSIGNED = 'NotAssigned';
    /**
     * Constant for value 'Lost'
     * @return string 'Lost'
     */
    const VALUE_LOST = 'Lost';
    /**
     * Constant for value 'SingleAssigned'
     * @return string 'SingleAssigned'
     */
    const VALUE_SINGLE_ASSIGNED = 'SingleAssigned';
    /**
     * Constant for value 'MultiAssigned'
     * @return string 'MultiAssigned'
     */
    const VALUE_MULTI_ASSIGNED = 'MultiAssigned';
    /**
     * Return allowed values
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_NOT_ASSIGNED
     * @uses self::VALUE_LOST
     * @uses self::VALUE_SINGLE_ASSIGNED
     * @uses self::VALUE_MULTI_ASSIGNED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNKNOWN,
            self::VALUE_NOT_ASSIGNED,
            self::VALUE_LOST,
            self::VALUE_SINGLE_ASSIGNED,
            self::VALUE_MULTI_ASSIGNED,
        );
    }
}
