<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPersonGroupType ArrayType
 * @subpackage Arrays
 */
class ArrayOfPersonGroupType extends AbstractStructArrayBase
{
    /**
     * The PersonGroup
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PersonGroupType[]
     */
    public $PersonGroup;
    /**
     * Constructor method for ArrayOfPersonGroupType
     * @uses ArrayOfPersonGroupType::setPersonGroup()
     * @param \StructType\PersonGroupType[] $personGroup
     */
    public function __construct(array $personGroup = array())
    {
        $this
            ->setPersonGroup($personGroup);
    }
    /**
     * Get PersonGroup value
     * @return \StructType\PersonGroupType[]|null
     */
    public function getPersonGroup()
    {
        return $this->PersonGroup;
    }
    /**
     * This method is responsible for validating the values passed to the setPersonGroup method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPersonGroup method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePersonGroupForArrayConstraintsFromSetPersonGroup(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfPersonGroupTypePersonGroupItem) {
            // validation for constraint: itemType
            if (!$arrayOfPersonGroupTypePersonGroupItem instanceof \StructType\PersonGroupType) {
                $invalidValues[] = is_object($arrayOfPersonGroupTypePersonGroupItem) ? get_class($arrayOfPersonGroupTypePersonGroupItem) : sprintf('%s(%s)', gettype($arrayOfPersonGroupTypePersonGroupItem), var_export($arrayOfPersonGroupTypePersonGroupItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PersonGroup property can only contain items of type \StructType\PersonGroupType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PersonGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonGroupType[] $personGroup
     * @return \ArrayType\ArrayOfPersonGroupType
     */
    public function setPersonGroup(array $personGroup = array())
    {
        // validation for constraint: array
        if ('' !== ($personGroupArrayErrorMessage = self::validatePersonGroupForArrayConstraintsFromSetPersonGroup($personGroup))) {
            throw new \InvalidArgumentException($personGroupArrayErrorMessage, __LINE__);
        }
        $this->PersonGroup = $personGroup;
        return $this;
    }
    /**
     * Add item to PersonGroup value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonGroupType $item
     * @return \ArrayType\ArrayOfPersonGroupType
     */
    public function addToPersonGroup(\StructType\PersonGroupType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonGroupType) {
            throw new \InvalidArgumentException(sprintf('The PersonGroup property can only contain items of type \StructType\PersonGroupType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PersonGroup[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PersonGroupType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PersonGroupType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PersonGroupType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PersonGroupType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PersonGroupType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PersonGroup
     */
    public function getAttributeName()
    {
        return 'PersonGroup';
    }
}
