<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Energieausweis-Daten StructType
 * Meta information extracted from the WSDL
 * - documentation: Weiterhin erforderliche Daten im Falle eines Energieausweises
 * @subpackage Structs
 */
class Energieausweis_Daten extends AbstractStructBase
{
    /**
     * The Gebaeudeart
     * @var string
     */
    public $Gebaeudeart;
    /**
     * The Art
     * @var string
     */
    public $Art;
    /**
     * The Neubau
     * @var string
     */
    public $Neubau;
    /**
     * Constructor method for Energieausweis-Daten
     * @uses Energieausweis_Daten::setGebaeudeart()
     * @uses Energieausweis_Daten::setArt()
     * @uses Energieausweis_Daten::setNeubau()
     * @param string $gebaeudeart
     * @param string $art
     * @param string $neubau
     */
    public function __construct($gebaeudeart = null, $art = null, $neubau = null)
    {
        $this
            ->setGebaeudeart($gebaeudeart)
            ->setArt($art)
            ->setNeubau($neubau);
    }
    /**
     * Get Gebaeudeart value
     * @return string|null
     */
    public function getGebaeudeart()
    {
        return $this->Gebaeudeart;
    }
    /**
     * Set Gebaeudeart value
     * @uses \EnumType\Gebaeudeart::valueIsValid()
     * @uses \EnumType\Gebaeudeart::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gebaeudeart
     * @return \StructType\Energieausweis_Daten
     */
    public function setGebaeudeart($gebaeudeart = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Gebaeudeart::valueIsValid($gebaeudeart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Gebaeudeart', is_array($gebaeudeart) ? implode(', ', $gebaeudeart) : var_export($gebaeudeart, true), implode(', ', \EnumType\Gebaeudeart::getValidValues())), __LINE__);
        }
        $this->Gebaeudeart = $gebaeudeart;
        return $this;
    }
    /**
     * Get Art value
     * @return string|null
     */
    public function getArt()
    {
        return $this->Art;
    }
    /**
     * Set Art value
     * @uses \EnumType\Art::valueIsValid()
     * @uses \EnumType\Art::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $art
     * @return \StructType\Energieausweis_Daten
     */
    public function setArt($art = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Art::valueIsValid($art)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Art', is_array($art) ? implode(', ', $art) : var_export($art, true), implode(', ', \EnumType\Art::getValidValues())), __LINE__);
        }
        $this->Art = $art;
        return $this;
    }
    /**
     * Get Neubau value
     * @return string|null
     */
    public function getNeubau()
    {
        return $this->Neubau;
    }
    /**
     * Set Neubau value
     * @uses \EnumType\Neubau::valueIsValid()
     * @uses \EnumType\Neubau::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $neubau
     * @return \StructType\Energieausweis_Daten
     */
    public function setNeubau($neubau = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\Neubau::valueIsValid($neubau)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\Neubau', is_array($neubau) ? implode(', ', $neubau) : var_export($neubau, true), implode(', ', \EnumType\Neubau::getValidValues())), __LINE__);
        }
        $this->Neubau = $neubau;
        return $this;
    }
}
