<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Datenregistratur ServiceType
 * @subpackage Services
 */
class Datenregistratur extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named Datenregistratur
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Datenregistratur $parameters
     * @return \StructType\DatenregistraturResponse|bool
     */
    public function Datenregistratur(\StructType\Datenregistratur $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Datenregistratur($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DatenregistraturResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
