<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for Bundesland EnumType
 * Meta information extracted from the WSDL
 * - documentation: Bundesland des Gebäudestandortes
 * @subpackage Enumerations
 */
class Bundesland extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Baden-Württemberg'
     * @return string 'Baden-Württemberg'
     */
    const VALUE_BADEN_W_ÜRTTEMBERG = 'Baden-Württemberg';
    /**
     * Constant for value 'Bayern'
     * @return string 'Bayern'
     */
    const VALUE_BAYERN = 'Bayern';
    /**
     * Constant for value 'Berlin'
     * @return string 'Berlin'
     */
    const VALUE_BERLIN = 'Berlin';
    /**
     * Constant for value 'Brandenburg'
     * @return string 'Brandenburg'
     */
    const VALUE_BRANDENBURG = 'Brandenburg';
    /**
     * Constant for value 'Bremen'
     * @return string 'Bremen'
     */
    const VALUE_BREMEN = 'Bremen';
    /**
     * Constant for value 'Hamburg'
     * @return string 'Hamburg'
     */
    const VALUE_HAMBURG = 'Hamburg';
    /**
     * Constant for value 'Hessen'
     * @return string 'Hessen'
     */
    const VALUE_HESSEN = 'Hessen';
    /**
     * Constant for value 'Mecklenburg-Vorpommern'
     * @return string 'Mecklenburg-Vorpommern'
     */
    const VALUE_MECKLENBURG_VORPOMMERN = 'Mecklenburg-Vorpommern';
    /**
     * Constant for value 'Niedersachsen'
     * @return string 'Niedersachsen'
     */
    const VALUE_NIEDERSACHSEN = 'Niedersachsen';
    /**
     * Constant for value 'Nordrhein-Westfalen'
     * @return string 'Nordrhein-Westfalen'
     */
    const VALUE_NORDRHEIN_WESTFALEN = 'Nordrhein-Westfalen';
    /**
     * Constant for value 'Rheinland-Pfalz'
     * @return string 'Rheinland-Pfalz'
     */
    const VALUE_RHEINLAND_PFALZ = 'Rheinland-Pfalz';
    /**
     * Constant for value 'Saarland'
     * @return string 'Saarland'
     */
    const VALUE_SAARLAND = 'Saarland';
    /**
     * Constant for value 'Sachsen'
     * @return string 'Sachsen'
     */
    const VALUE_SACHSEN = 'Sachsen';
    /**
     * Constant for value 'Sachsen-Anhalt'
     * @return string 'Sachsen-Anhalt'
     */
    const VALUE_SACHSEN_ANHALT = 'Sachsen-Anhalt';
    /**
     * Constant for value 'Schleswig-Holstein'
     * @return string 'Schleswig-Holstein'
     */
    const VALUE_SCHLESWIG_HOLSTEIN = 'Schleswig-Holstein';
    /**
     * Constant for value 'Thüringen'
     * @return string 'Thüringen'
     */
    const VALUE_TH_ÜRINGEN = 'Thüringen';
    /**
     * Return allowed values
     * @uses self::VALUE_BADEN_W_ÜRTTEMBERG
     * @uses self::VALUE_BAYERN
     * @uses self::VALUE_BERLIN
     * @uses self::VALUE_BRANDENBURG
     * @uses self::VALUE_BREMEN
     * @uses self::VALUE_HAMBURG
     * @uses self::VALUE_HESSEN
     * @uses self::VALUE_MECKLENBURG_VORPOMMERN
     * @uses self::VALUE_NIEDERSACHSEN
     * @uses self::VALUE_NORDRHEIN_WESTFALEN
     * @uses self::VALUE_RHEINLAND_PFALZ
     * @uses self::VALUE_SAARLAND
     * @uses self::VALUE_SACHSEN
     * @uses self::VALUE_SACHSEN_ANHALT
     * @uses self::VALUE_SCHLESWIG_HOLSTEIN
     * @uses self::VALUE_TH_ÜRINGEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BADEN_W_ÜRTTEMBERG,
            self::VALUE_BAYERN,
            self::VALUE_BERLIN,
            self::VALUE_BRANDENBURG,
            self::VALUE_BREMEN,
            self::VALUE_HAMBURG,
            self::VALUE_HESSEN,
            self::VALUE_MECKLENBURG_VORPOMMERN,
            self::VALUE_NIEDERSACHSEN,
            self::VALUE_NORDRHEIN_WESTFALEN,
            self::VALUE_RHEINLAND_PFALZ,
            self::VALUE_SAARLAND,
            self::VALUE_SACHSEN,
            self::VALUE_SACHSEN_ANHALT,
            self::VALUE_SCHLESWIG_HOLSTEIN,
            self::VALUE_TH_ÜRINGEN,
        );
    }
}
