<?php

namespace AureroIpom\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentyfikatorOIDMT StructType
 * Meta information extracted from the WSDL
 * - documentation: Identyfikator zgodny z OID.
 * @subpackage Structs
 */
class IdentyfikatorOIDMT extends AbstractStructBase
{
    /**
     * The extension
     * Meta information extracted from the WSDL
     * - documentation: Identyfikator unikalny w ramach węzła OID.
     * @var string
     */
    public $extension;
    /**
     * The root
     * Meta information extracted from the WSDL
     * - documentation: Węzeł OID.
     * @var string
     */
    public $root;
    /**
     * Constructor method for IdentyfikatorOIDMT
     * @uses IdentyfikatorOIDMT::setExtension()
     * @uses IdentyfikatorOIDMT::setRoot()
     * @param string $extension
     * @param string $root
     */
    public function __construct($extension = null, $root = null)
    {
        $this
            ->setExtension($extension)
            ->setRoot($root);
    }
    /**
     * Get extension value
     * @return string|null
     */
    public function getExtension()
    {
        return $this->extension;
    }
    /**
     * Set extension value
     * @param string $extension
     * @return \AureroIpom\StructType\IdentyfikatorOIDMT
     */
    public function setExtension($extension = null)
    {
        // validation for constraint: string
        if (!is_null($extension) && !is_string($extension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extension, true), gettype($extension)), __LINE__);
        }
        $this->extension = $extension;
        return $this;
    }
    /**
     * Get root value
     * @return string|null
     */
    public function getRoot()
    {
        return $this->root;
    }
    /**
     * Set root value
     * @param string $root
     * @return \AureroIpom\StructType\IdentyfikatorOIDMT
     */
    public function setRoot($root = null)
    {
        // validation for constraint: string
        if (!is_null($root) && !is_string($root)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($root, true), gettype($root)), __LINE__);
        }
        $this->root = $root;
        return $this;
    }
}
